/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.TopLevelSchemaComponentNode;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCurator;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

class SchemaNode
extends AbstractTreeNodeValueModel
implements Displayable {
    private ValueModel schemaHolder;
    private ValueModel schemaNameHolder;
    private PropertyChangeListener schemaNameListener;
    private ListValueModel childrenModel;

    SchemaNode(ValueModel schemaHolder) {
        this.initialize(schemaHolder);
    }

    private void initialize(ValueModel schemaHolder) {
        this.schemaHolder = schemaHolder;
        this.schemaNameHolder = this.buildSchemaNameHolder();
        this.schemaNameListener = this.buildSchemaNamePropertyChangeListener();
        this.childrenModel = this.buildChildrenModel();
    }

    private ValueModel buildSchemaNameHolder() {
        return new PropertyAspectAdapter(this.schemaHolder, "name"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWXmlSchema)this.subject).getName();
            }
        };
    }

    private PropertyChangeListener buildSchemaNamePropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SchemaNode.this.firePropertyChanged("displayString", evt.getOldValue(), evt.getNewValue());
                SchemaNode.this.fireStateChanged();
            }
        };
    }

    protected ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildComponentNodesAdapter());
    }

    protected ListValueModel buildComponentNodesAdapter() {
        return new TransformationListValueModelAdapter(this.buildStructuralComponentsAdapter()){

            @Override
            protected Object transformItem(Object item) {
                return SchemaNode.this.buildComponentNode((MWNamedSchemaComponent)item);
            }
        };
    }

    protected SchemaComponentNode buildComponentNode(MWNamedSchemaComponent component) {
        return new TopLevelSchemaComponentNode((AbstractTreeNodeValueModel)this, component);
    }

    protected ListValueModel buildStructuralComponentsAdapter() {
        return new ListCurator(this.schemaHolder){

            @Override
            public Iterator getValueForRecord() {
                return ((MWXmlSchema)this.subject).structuralComponents();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.schemaHolder.getValue();
    }

    @Override
    public TreeNodeValueModel getParent() {
        return null;
    }

    @Override
    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    @Override
    protected void engageValue() {
        this.schemaNameHolder.addPropertyChangeListener("value", this.schemaNameListener);
    }

    @Override
    protected void disengageValue() {
        this.schemaNameHolder.removePropertyChangeListener("value", this.schemaNameListener);
    }

    public int compareTo(Object o) {
        return DEFAULT_COMPARATOR.compare(this, o);
    }

    @Override
    public String displayString() {
        String schemaName = this.schema() == null ? "" : this.schema().getName();
        return "schema: " + schemaName;
    }

    @Override
    public Icon icon() {
        return null;
    }

    private MWXmlSchema schema() {
        return (MWXmlSchema)this.schemaHolder.getValue();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        SchemaNode other = (SchemaNode)o;
        return this.schemaHolder.equals(other.schemaHolder);
    }

    @Override
    public int hashCode() {
        return this.schemaHolder.hashCode();
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.schemaHolder);
    }
}

