/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroupDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.AttributeDeclarationNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.ComplexTypeDefinitionNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.ElementDeclarationNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.ModelGroupDefinitionNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.NamedSchemaComponentNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SimpleTypeDefinitionNodeStructure;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;

final class TopLevelSchemaComponentNode
extends SchemaComponentNode
implements Comparable {
    TopLevelSchemaComponentNode(AbstractTreeNodeValueModel parent, MWNamedSchemaComponent component) {
        super(parent, (MWSchemaComponent)component);
    }

    @Override
    protected SchemaComponentNodeStructure buildStructure(MWSchemaComponent component) {
        NamedSchemaComponentNodeStructure structure;
        if (component instanceof MWElementDeclaration) {
            structure = new ElementDeclarationNodeStructure((MWElementDeclaration)component);
        } else if (component instanceof MWModelGroupDefinition) {
            structure = new ModelGroupDefinitionNodeStructure((MWModelGroupDefinition)component);
        } else if (component instanceof MWAttributeDeclaration) {
            structure = new AttributeDeclarationNodeStructure((MWAttributeDeclaration)component);
        } else if (component instanceof MWComplexTypeDefinition) {
            structure = new ComplexTypeDefinitionNodeStructure((MWComplexTypeDefinition)component);
        } else if (component instanceof MWSimpleTypeDefinition) {
            structure = new SimpleTypeDefinitionNodeStructure((MWSimpleTypeDefinition)component);
        } else {
            throw new IllegalArgumentException("Unsupported top level schema component.");
        }
        structure.addPropertyChangeListener("displayString", this.buildDisplayStringChangeListener());
        return structure;
    }

    @Override
    public int compareTo(Object o) {
        return TopLevelSchemaComponentNodeComparator.compare(this, o);
    }

    private static class TopLevelSchemaComponentNodeComparator {
        private TopLevelSchemaComponentNodeComparator() {
        }

        public static int compare(Object o1, Object o2) {
            TopLevelSchemaComponentNode node1 = (TopLevelSchemaComponentNode)o1;
            TopLevelSchemaComponentNode node2 = (TopLevelSchemaComponentNode)o2;
            MWNamedSchemaComponent comp1 = (MWNamedSchemaComponent)node1.component;
            MWNamedSchemaComponent comp2 = (MWNamedSchemaComponent)node2.component;
            int comparison = TopLevelSchemaComponentNodeComparator.compare(comp1.getTargetNamespace(), comp2.getTargetNamespace());
            if (comparison == 0) {
                comparison = TopLevelSchemaComponentNodeComparator.compare((NamedSchemaComponentNodeStructure)node1.structure, (NamedSchemaComponentNodeStructure)node2.structure);
            }
            if (comparison == 0) {
                comparison = comp1.qName().compareTo(comp2.qName());
            }
            return comparison;
        }

        private static int compare(MWNamespace thisNamespace, MWNamespace otherNamespace) {
            if (thisNamespace.isTargetNamespace() && !otherNamespace.isTargetNamespace()) {
                return -1;
            }
            if (!thisNamespace.isTargetNamespace() && otherNamespace.isTargetNamespace()) {
                return 1;
            }
            if (thisNamespace.getNamespacePrefix() != otherNamespace.getNamespacePrefix()) {
                return thisNamespace.getNamespacePrefix().compareToIgnoreCase(otherNamespace.getNamespacePrefix());
            }
            return 0;
        }

        private static int compare(NamedSchemaComponentNodeStructure structure1, NamedSchemaComponentNodeStructure structure2) {
            return structure1.topLevelOrderIndex().compareTo(structure2.topLevelOrderIndex());
        }
    }
}

