/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractSpinnerModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class SpinnerModelAdapter
extends AbstractSpinnerModel {
    protected SpinnerModel delegate;
    protected ChangeListener delegateListener;
    protected PropertyValueModel valueHolder;
    protected PropertyChangeListener valueListener;

    private SpinnerModelAdapter() {
        this.initialize();
    }

    public SpinnerModelAdapter(PropertyValueModel valueHolder, SpinnerModel delegate) {
        this();
        if (valueHolder == null || delegate == null) {
            throw new NullPointerException();
        }
        this.valueHolder = valueHolder;
        this.delegate = delegate;
    }

    public SpinnerModelAdapter(PropertyValueModel valueHolder) {
        this(valueHolder, new SpinnerNumberModel());
    }

    protected void initialize() {
        this.valueListener = this.buildValueListener();
        this.delegateListener = this.buildDelegateListener();
    }

    protected PropertyChangeListener buildValueListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SpinnerModelAdapter.this.valueChanged(e);
            }

            public String toString() {
                return "value listener";
            }
        };
    }

    @Override
    protected void fireStateChanged() {
        super.fireStateChanged();
    }

    protected ChangeListener buildDelegateListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerModelAdapter.this.fireStateChanged();
            }

            public String toString() {
                return "delegate listener";
            }
        };
    }

    @Override
    public Object getValue() {
        return this.delegate.getValue();
    }

    @Override
    public void setValue(Object value) {
        this.delegate.setValue(value);
        this.valueHolder.setValue(value);
    }

    @Override
    public Object getNextValue() {
        return this.delegate.getNextValue();
    }

    @Override
    public Object getPreviousValue() {
        return this.delegate.getPreviousValue();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.listenerList.getListenerCount(ChangeListener.class) == 0) {
            this.delegate.addChangeListener(this.delegateListener);
            this.engageValueHolder();
        }
        super.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.listenerList.getListenerCount(ChangeListener.class) == 0) {
            this.disengageValueHolder();
            this.delegate.removeChangeListener(this.delegateListener);
        }
    }

    protected void valueChanged(PropertyChangeEvent e) {
        this.synchronizeDelegate(e.getNewValue());
    }

    protected void synchronizeDelegate(Object value) {
        if (!this.delegate.getValue().equals(value)) {
            this.delegate.setValue(value);
        }
    }

    protected void engageValueHolder() {
        this.valueHolder.addPropertyChangeListener("value", this.valueListener);
        this.synchronizeDelegate(this.valueHolder.getValue());
    }

    protected void disengageValueHolder() {
        this.valueHolder.removePropertyChangeListener("value", this.valueListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.valueHolder);
    }
}

