/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.uitools.app.AspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullListIterator;

public abstract class ListAspectAdapter
extends AspectAdapter
implements ListValueModel {
    protected String listName;
    protected ListChangeListener listChangeListener;

    protected ListAspectAdapter(String listName, Model subject) {
        super(subject);
        this.listName = listName;
    }

    protected ListAspectAdapter(ValueModel subjectHolder, String listName) {
        super(subjectHolder);
        this.listName = listName;
    }

    protected ListAspectAdapter(ValueModel subjectHolder) {
        this(subjectHolder, null);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.listChangeListener = this.buildListChangeListener();
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                ListAspectAdapter.this.itemsAdded(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                ListAspectAdapter.this.itemsRemoved(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                ListAspectAdapter.this.itemsReplaced(e);
            }

            public void listChanged(ListChangeEvent e) {
                ListAspectAdapter.this.listChanged(e);
            }

            public String toString() {
                return "list change listener: " + ListAspectAdapter.this.listName;
            }
        };
    }

    @Override
    public Object getValue() {
        if (this.subject == null) {
            return NullListIterator.instance();
        }
        return this.getValueFromSubject();
    }

    protected ListIterator getValueFromSubject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addItem(int index, Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addItems(int index, List items) {
        for (int i = 0; i < items.size(); ++i) {
            this.addItem(index + i, items.get(i));
        }
    }

    @Override
    public Object removeItem(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List removeItems(int index, int length) {
        ArrayList<Object> removedItems = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            removedItems.add(this.removeItem(index));
        }
        return removedItems;
    }

    @Override
    public Object replaceItem(int index, Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List replaceItems(int index, List items) {
        ArrayList<Object> replacedItems = new ArrayList<Object>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            replacedItems.add(this.replaceItem(index + i, items.get(i)));
        }
        return replacedItems;
    }

    @Override
    public Object getItem(int index) {
        return CollectionTools.get((ListIterator)((ListIterator)this.getValue()), (int)index);
    }

    @Override
    public int size() {
        return this.subject == null ? 0 : this.sizeFromSubject();
    }

    protected int sizeFromSubject() {
        return CollectionTools.size((Iterator)((ListIterator)this.getValue()));
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("value");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.fireListChanged("value");
    }

    @Override
    protected void engageNonNullSubject() {
        if (this.listName != null) {
            ((Model)this.subject).addListChangeListener(this.listName, this.listChangeListener);
        }
    }

    @Override
    protected void disengageNonNullSubject() {
        if (this.listName != null) {
            ((Model)this.subject).removeListChangeListener(this.listName, this.listChangeListener);
        }
    }

    public void toString(StringBuffer sb) {
        sb.append(this.listName);
    }

    protected void itemsAdded(ListChangeEvent e) {
        this.fireItemsAdded(e.cloneWithSource((Object)this, "value"));
    }

    protected void itemsRemoved(ListChangeEvent e) {
        this.fireItemsRemoved(e.cloneWithSource((Object)this, "value"));
    }

    protected void itemsReplaced(ListChangeEvent e) {
        this.fireItemsReplaced(e.cloneWithSource((Object)this, "value"));
    }

    protected void listChanged(ListChangeEvent e) {
        this.fireListChanged("value");
    }
}

