/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.relationshipmaintenance;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.relationshipmaintenance.Customer;
import org.eclipse.persistence.testing.models.relationshipmaintenance.Dept;
import org.eclipse.persistence.testing.models.relationshipmaintenance.Emp;
import org.eclipse.persistence.testing.models.relationshipmaintenance.FieldLocation;
import org.eclipse.persistence.testing.models.relationshipmaintenance.FieldManager;
import org.eclipse.persistence.testing.models.relationshipmaintenance.FieldOffice;
import org.eclipse.persistence.testing.models.relationshipmaintenance.Resource;
import org.eclipse.persistence.testing.models.relationshipmaintenance.SalesPerson;

public class RelationshipsProject
extends Project {
    public RelationshipsProject() {
        this.setName("Relationships");
        this.applyLogin();
        this.addDescriptor((ClassDescriptor)this.buildCustomerDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildFieldLocationDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildFieldManagerDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildFieldOfficeDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildSalesPersonDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildEmpDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildDeptDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildResourceDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        this.setLogin(login);
    }

    public RelationalDescriptor buildCustomerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Customer.class);
        descriptor.addTableName("REL_CUSTOMER");
        descriptor.addPrimaryKeyFieldName("REL_CUSTOMER.ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("REL_CUSTOMER.ID");
        descriptor.setSequenceNumberName("REL_CUSTOMER_SEQ");
        descriptor.getQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("REL_CUSTOMER.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("REL_CUSTOMER.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        ManyToManyMapping salespeopleMapping = new ManyToManyMapping();
        salespeopleMapping.setAttributeName("salespeople");
        salespeopleMapping.setReferenceClass(SalesPerson.class);
        salespeopleMapping.useTransparentCollection();
        salespeopleMapping.useCollectionClass(IndirectSet.class);
        salespeopleMapping.readOnly();
        salespeopleMapping.setRelationTableName("SALES_CUST");
        salespeopleMapping.addSourceRelationKeyFieldName("SALES_CUST.CUST_ID", "REL_CUSTOMER.ID");
        salespeopleMapping.addTargetRelationKeyFieldName("SALES_CUST.SALES_ID", "SALESPERSON.ID");
        salespeopleMapping.setRelationshipPartnerAttributeName("customers");
        descriptor.addMapping((DatabaseMapping)salespeopleMapping);
        return descriptor;
    }

    public RelationalDescriptor buildFieldLocationDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(FieldLocation.class);
        descriptor.addTableName("FIELDLOCATION");
        descriptor.addPrimaryKeyFieldName("FIELDLOCATION.ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("FIELDLOCATION.ID");
        descriptor.setSequenceNumberName("REL_FIELD_LOC_SEQ");
        descriptor.getQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("FIELDLOCATION.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping cityMapping = new DirectToFieldMapping();
        cityMapping.setAttributeName("city");
        cityMapping.setFieldName("FIELDLOCATION.CITY");
        descriptor.addMapping((DatabaseMapping)cityMapping);
        return descriptor;
    }

    public RelationalDescriptor buildFieldManagerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(FieldManager.class);
        descriptor.addTableName("FIELDMANAGER");
        descriptor.addPrimaryKeyFieldName("FIELDMANAGER.ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("FIELDMANAGER.ID");
        descriptor.setSequenceNumberName("REL_FIELD_MANAGER_SEQ");
        descriptor.getQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("FIELDMANAGER.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("FIELDMANAGER.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToOneMapping officeMapping = new OneToOneMapping();
        officeMapping.setAttributeName("office");
        officeMapping.setReferenceClass(FieldOffice.class);
        officeMapping.useBasicIndirection();
        officeMapping.addTargetForeignKeyFieldName("FIELDOFFICE.MANAGER_ID", "FIELDMANAGER.ID");
        officeMapping.setRelationshipPartnerAttributeName("manager");
        descriptor.addMapping((DatabaseMapping)officeMapping);
        return descriptor;
    }

    public RelationalDescriptor buildFieldOfficeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(FieldOffice.class);
        descriptor.addTableName("FIELDOFFICE");
        descriptor.addPrimaryKeyFieldName("FIELDOFFICE.ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("FIELDOFFICE.ID");
        descriptor.setSequenceNumberName("REL_FIELD_OFFICE_SEQ");
        descriptor.getQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("FIELDOFFICE.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        OneToOneMapping locationMapping = new OneToOneMapping();
        locationMapping.setAttributeName("location");
        locationMapping.setReferenceClass(FieldLocation.class);
        locationMapping.useBasicIndirection();
        locationMapping.addForeignKeyFieldName("FIELDOFFICE.LOCATION_ID", "FIELDLOCATION.ID");
        descriptor.addMapping((DatabaseMapping)locationMapping);
        OneToOneMapping managerMapping = new OneToOneMapping();
        managerMapping.setAttributeName("manager");
        managerMapping.setReferenceClass(FieldManager.class);
        managerMapping.useBasicIndirection();
        managerMapping.addForeignKeyFieldName("FIELDOFFICE.MANAGER_ID", "FIELDMANAGER.ID");
        managerMapping.setRelationshipPartnerAttributeName("office");
        descriptor.addMapping((DatabaseMapping)managerMapping);
        OneToManyMapping salespeopleMapping = new OneToManyMapping();
        salespeopleMapping.setAttributeName("salespeople");
        salespeopleMapping.setReferenceClass(SalesPerson.class);
        salespeopleMapping.useTransparentCollection();
        salespeopleMapping.useCollectionClass(IndirectSet.class);
        salespeopleMapping.addTargetForeignKeyFieldName("SALESPERSON.OFFICE_ID", "FIELDOFFICE.ID");
        salespeopleMapping.setRelationshipPartnerAttributeName("fieldOffice");
        descriptor.addMapping((DatabaseMapping)salespeopleMapping);
        OneToManyMapping resourceMapping = new OneToManyMapping();
        resourceMapping.setAttributeName("resources");
        resourceMapping.setReferenceClass(Resource.class);
        resourceMapping.dontUseIndirection();
        resourceMapping.useCollectionClass(IndirectList.class);
        resourceMapping.addTargetForeignKeyFieldName("REL_RESOURCE.OFFICE_ID", "FIELDOFFICE.ID");
        resourceMapping.setRelationshipPartnerAttributeName("deptno");
        descriptor.addMapping((DatabaseMapping)resourceMapping);
        return descriptor;
    }

    public RelationalDescriptor buildSalesPersonDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(SalesPerson.class);
        descriptor.addTableName("SALESPERSON");
        descriptor.addPrimaryKeyFieldName("SALESPERSON.ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("SALESPERSON.ID");
        descriptor.setSequenceNumberName("REL_SALESPERSON_SEQ");
        descriptor.getQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("SALESPERSON.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("SALESPERSON.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToOneMapping fieldOfficeMapping = new OneToOneMapping();
        fieldOfficeMapping.setAttributeName("fieldOffice");
        fieldOfficeMapping.setReferenceClass(FieldOffice.class);
        fieldOfficeMapping.useBasicIndirection();
        fieldOfficeMapping.addForeignKeyFieldName("SALESPERSON.OFFICE_ID", "FIELDOFFICE.ID");
        fieldOfficeMapping.setRelationshipPartnerAttributeName("salespeople");
        descriptor.addMapping((DatabaseMapping)fieldOfficeMapping);
        ManyToManyMapping customersMapping = new ManyToManyMapping();
        customersMapping.setAttributeName("customers");
        customersMapping.setReferenceClass(Customer.class);
        customersMapping.useTransparentCollection();
        customersMapping.useCollectionClass(IndirectSet.class);
        customersMapping.setRelationTableName("SALES_CUST");
        customersMapping.addSourceRelationKeyFieldName("SALES_CUST.SALES_ID", "SALESPERSON.ID");
        customersMapping.addTargetRelationKeyFieldName("SALES_CUST.CUST_ID", "REL_CUSTOMER.ID");
        customersMapping.setRelationshipPartnerAttributeName("salespeople");
        descriptor.addMapping((DatabaseMapping)customersMapping);
        return descriptor;
    }

    public RelationalDescriptor buildEmpDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Emp.class);
        descriptor.addTableName("REL_EMP");
        descriptor.addPrimaryKeyFieldName("REL_EMP.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(10);
        descriptor.getQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("empno");
        idMapping.setFieldName("REL_EMP.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("ename");
        nameMapping.setFieldName("REL_EMP.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToOneMapping deptMapping = new OneToOneMapping();
        deptMapping.setAttributeName("deptno");
        deptMapping.setReferenceClass(Dept.class);
        deptMapping.useBasicIndirection();
        deptMapping.addForeignKeyFieldName("REL_EMP.DEPTNO", "REL_DEPT.DEPTNO");
        deptMapping.setRelationshipPartnerAttributeName("empCollection");
        descriptor.addMapping((DatabaseMapping)deptMapping);
        return descriptor;
    }

    public RelationalDescriptor buildDeptDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Dept.class);
        descriptor.addTableName("REL_DEPT");
        descriptor.addPrimaryKeyFieldName("REL_DEPT.DEPTNO");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(10);
        descriptor.getQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("deptno");
        idMapping.setFieldName("REL_DEPT.DEPTNO");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("dname");
        nameMapping.setFieldName("REL_DEPT.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToManyMapping empMapping = new OneToManyMapping();
        empMapping.setAttributeName("empCollection");
        empMapping.setReferenceClass(Emp.class);
        empMapping.useTransparentCollection();
        empMapping.useCollectionClass(IndirectList.class);
        empMapping.addTargetForeignKeyFieldName("REL_EMP.DEPTNO", "REL_DEPT.DEPTNO");
        empMapping.setRelationshipPartnerAttributeName("deptno");
        descriptor.addMapping((DatabaseMapping)empMapping);
        return descriptor;
    }

    public RelationalDescriptor buildResourceDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Resource.class);
        descriptor.addTableName("REL_RESOURCE");
        descriptor.addPrimaryKeyFieldName("REL_RESOURCE.ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("REL_RESOURCE.ID");
        descriptor.setSequenceNumberName("REL_RESOURCE_SEQ");
        descriptor.getQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("REL_RESOURCE.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("REL_RESOURCE.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToOneMapping officeMapping = new OneToOneMapping();
        officeMapping.setAttributeName("office");
        officeMapping.setReferenceClass(FieldOffice.class);
        officeMapping.useBasicIndirection();
        officeMapping.addForeignKeyFieldName("REL_RESOURCE.OFFICE_ID", "FIELDOFFICE.ID");
        descriptor.addMapping((DatabaseMapping)officeMapping);
        return descriptor;
    }
}

