/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.conversion;

import java.math.BigInteger;
import java.sql.Date;
import java.util.GregorianCalendar;
import junit.framework.Test;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.conversion.ConversionDataObject;
import org.eclipse.persistence.testing.models.conversion.ConversionManagerSystem;
import org.eclipse.persistence.testing.tests.conversion.ClassLoaderTest;
import org.eclipse.persistence.testing.tests.conversion.ConvertByteCharArrayToStringTest;
import org.eclipse.persistence.testing.tests.conversion.ConvertClassTypeTest;
import org.eclipse.persistence.testing.tests.conversion.ConvertObjectTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class ConversionManagerTestModel
extends TestModel {
    public ConversionManagerTestModel() {
        this.setDescription("This suite tests all possible conversions through direct field mapping.");
    }

    public void addForcedRequiredSystems() {
        this.addForcedRequiredSystem(new ConversionManagerSystem());
    }

    public void addTests() {
        this.addTest((Test)this.getReadObjectTestSuite());
        this.addTest((Test)this.getReadAllTestSuite());
        this.addTest((Test)this.getDeleteObjectTestSuite());
        this.addTest((Test)this.getInsertObjectTestSuite());
        this.addTest((Test)this.getUpdateObjectTestSuite());
        this.addTest((Test)this.getConvertObjectTestSuite());
        this.addTest((Test)this.getConvertClassTypeTestSuite());
        this.addTest((Test)this.getClassLoaderTestSuite());
    }

    public TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ConversionManagerDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the conversion manager model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(ConversionDataObject.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(ConversionDataObject.class, "example2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(ConversionDataObject.class, "example3")));
        return suite;
    }

    public TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ConversionManagerInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the conversion manager model.");
        suite.addTest((Test)new InsertObjectTest((Object)ConversionDataObject.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)ConversionDataObject.example2()));
        suite.addTest((Test)new InsertObjectTest((Object)ConversionDataObject.example3()));
        return suite;
    }

    public TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ConversionManagerReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the conversion manager model.");
        suite.addTest((Test)new ReadAllTest(ConversionDataObject.class, 3));
        return suite;
    }

    public TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ConversionManagerReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the conversion manager model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(ConversionDataObject.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(ConversionDataObject.class, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(ConversionDataObject.class, "example3")));
        return suite;
    }

    public TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ConversionManagerUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the conversion manager model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(ConversionDataObject.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(ConversionDataObject.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(ConversionDataObject.class, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(ConversionDataObject.class, "example3")));
        return suite;
    }

    public TestSuite getConvertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ConversionManagerConvertObjectTestSuite");
        suite.setDescription("This test suite verifies object conversion.");
        suite.addTest((Test)new ConvertObjectTest(Helper.buildHexStringFromBytes((byte[])new byte[]{4, 5, 6}), ClassConstants.ABYTE));
        suite.addTest((Test)new ConvertObjectTest(new char[]{'a', 'b', 'c'}, ClassConstants.ACHAR));
        suite.addTest((Test)new ConvertObjectTest(new BigInteger("100"), ClassConstants.BIGDECIMAL));
        suite.addTest((Test)new ConvertObjectTest(new BigInteger("100"), ClassConstants.BIGINTEGER));
        suite.addTest((Test)new ConvertObjectTest(new String("100"), ClassConstants.BIGINTEGER));
        suite.addTest((Test)new ConvertObjectTest(new Integer(100), ClassConstants.BIGINTEGER));
        suite.addTest((Test)new ConvertObjectTest(new Character('1'), ClassConstants.BOOLEAN));
        suite.addTest((Test)new ConvertObjectTest(new Character('t'), ClassConstants.BOOLEAN));
        suite.addTest((Test)new ConvertObjectTest(new Character('0'), ClassConstants.BOOLEAN));
        suite.addTest((Test)new ConvertObjectTest(new Character('f'), ClassConstants.BOOLEAN));
        suite.addTest((Test)new ConvertObjectTest(Helper.buildHexStringFromBytes((byte[])new byte[]{4}), ClassConstants.PBYTE));
        suite.addTest((Test)new ConvertObjectTest(new Integer(100), ClassConstants.CHAR));
        suite.addTest((Test)new ConvertObjectTest(new GregorianCalendar(), ClassConstants.SQLDATE));
        suite.addTest((Test)new ConvertObjectTest(new Long(100L), ClassConstants.SQLDATE));
        suite.addTest((Test)new ConvertObjectTest(new Boolean("true"), ClassConstants.LONG));
        suite.addTest((Test)new ConvertObjectTest(new Boolean("false"), ClassConstants.LONG));
        suite.addTest((Test)new ConvertObjectTest(new String("1"), ClassConstants.NUMBER));
        suite.addTest((Test)new ConvertObjectTest(new Boolean("true"), ClassConstants.NUMBER));
        suite.addTest((Test)new ConvertObjectTest(new Boolean("false"), ClassConstants.NUMBER));
        suite.addTest((Test)new ConvertObjectTest(new Integer(1), ClassConstants.SHORT));
        suite.addTest((Test)new ConvertObjectTest(new Boolean("true"), ClassConstants.SHORT));
        suite.addTest((Test)new ConvertObjectTest(new Boolean("false"), ClassConstants.SHORT));
        suite.addTest((Test)new ConvertObjectTest(new String("12:00:00"), ClassConstants.TIME));
        suite.addTest((Test)new ConvertObjectTest(new java.util.Date(100L), ClassConstants.TIME));
        suite.addTest((Test)new ConvertObjectTest(new GregorianCalendar(), ClassConstants.TIME));
        suite.addTest((Test)new ConvertObjectTest(new Long(100L), ClassConstants.TIME));
        suite.addTest((Test)new ConvertObjectTest(new String("12:00:00"), ClassConstants.TIMESTAMP));
        suite.addTest((Test)new ConvertObjectTest(new java.util.Date(100L), ClassConstants.TIMESTAMP));
        suite.addTest((Test)new ConvertObjectTest(new GregorianCalendar(), ClassConstants.TIMESTAMP));
        suite.addTest((Test)new ConvertObjectTest(new GregorianCalendar(), ClassConstants.UTILDATE));
        suite.addTest((Test)new ConvertObjectTest(new Long(100L), ClassConstants.UTILDATE));
        suite.addTest((Test)new ConvertObjectTest(new Character('1'), ClassConstants.BIGDECIMAL, true));
        suite.addTest((Test)new ConvertObjectTest(new Character('1'), ClassConstants.BIGINTEGER, true));
        suite.addTest((Test)new ConvertObjectTest(new String("a"), ClassConstants.BIGINTEGER, true));
        suite.addTest((Test)new ConvertObjectTest(new Date(1L), ClassConstants.BOOLEAN, true));
        suite.addTest((Test)new ConvertObjectTest(new Date(1L), ClassConstants.BYTE, true));
        suite.addTest((Test)new ConvertObjectTest(new String("a"), ClassConstants.BYTE, true));
        suite.addTest((Test)new ConvertObjectTest(new char[]{'a'}, ClassConstants.APBYTE, true));
        suite.addTest((Test)new ConvertObjectTest(new GregorianCalendar(), ClassConstants.CHAR, true));
        suite.addTest((Test)new ConvertObjectTest(new Boolean("true"), ClassConstants.SQLDATE, true));
        suite.addTest((Test)new ConvertObjectTest(new String("a"), ClassConstants.DOUBLE, true));
        suite.addTest((Test)new ConvertObjectTest(new Boolean("true"), ClassConstants.DOUBLE, true));
        suite.addTest((Test)new ConvertObjectTest(new String("a"), ClassConstants.FLOAT, true));
        suite.addTest((Test)new ConvertObjectTest(new Boolean("true"), ClassConstants.FLOAT, true));
        suite.addTest((Test)new ConvertObjectTest(new Date(1L), ClassConstants.INTEGER, true));
        suite.addTest((Test)new ConvertObjectTest(new String("a"), ClassConstants.LONG, true));
        suite.addTest((Test)new ConvertObjectTest(new GregorianCalendar(), ClassConstants.LONG, true));
        suite.addTest((Test)new ConvertObjectTest(new String("a"), ClassConstants.NUMBER, true));
        suite.addTest((Test)new ConvertObjectTest(new GregorianCalendar(), ClassConstants.NUMBER, true));
        suite.addTest((Test)new ConvertObjectTest(new String("a"), ClassConstants.SHORT, true));
        suite.addTest((Test)new ConvertObjectTest(new GregorianCalendar(), ClassConstants.SHORT, true));
        suite.addTest((Test)new ConvertObjectTest(new Boolean("true"), ClassConstants.TIME, true));
        suite.addTest((Test)new ConvertObjectTest(new Boolean("true"), ClassConstants.TIMESTAMP, true));
        suite.addTest((Test)new ConvertObjectTest(new Boolean("true"), ClassConstants.UTILDATE, true));
        suite.addTest((Test)new ConvertObjectTest(new Integer(1), ConversionManager.class, true));
        suite.addTest((Test)new ConvertByteCharArrayToStringTest());
        return suite;
    }

    public TestSuite getConvertClassTypeTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ConversionManagerConvertClassTypeTestSuite");
        suite.setDescription("This test suite verifies class type conversion.");
        suite.addTest((Test)new ConvertClassTypeTest("int", Integer.TYPE));
        suite.addTest((Test)new ConvertClassTypeTest("boolean", Boolean.TYPE));
        suite.addTest((Test)new ConvertClassTypeTest("char", Character.TYPE));
        suite.addTest((Test)new ConvertClassTypeTest("short", Short.TYPE));
        suite.addTest((Test)new ConvertClassTypeTest("byte", Byte.TYPE));
        suite.addTest((Test)new ConvertClassTypeTest("float", Float.TYPE));
        suite.addTest((Test)new ConvertClassTypeTest("double", Double.TYPE));
        suite.addTest((Test)new ConvertClassTypeTest("long", Long.TYPE));
        suite.addTest((Test)new ConvertClassTypeTest("", null));
        suite.addTest((Test)new ConvertClassTypeTest(Character.TYPE, Character.class));
        suite.addTest((Test)new ConvertClassTypeTest(Float.TYPE, Float.class));
        suite.addTest((Test)new ConvertClassTypeTest(Short.TYPE, Short.class));
        suite.addTest((Test)new ConvertClassTypeTest(Byte.TYPE, Byte.class));
        suite.addTest((Test)new ConvertClassTypeTest(Boolean.TYPE, Boolean.class));
        return suite;
    }

    public TestSuite getClassLoaderTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ConversionManagerClassLoaderTestSuite");
        suite.setDescription("This test suite tests the getLoader method.");
        suite.addTest((Test)new ClassLoaderTest());
        return suite;
    }
}

