/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.Address;
import org.eclipse.persistence.testing.tests.proxyindirection.AddressImpl;
import org.eclipse.persistence.testing.tests.proxyindirection.Employee;

public class UnitOfWorkReplaceTest
extends AutoVerifyTestCase {
    public UnitOfWorkReplaceTest() {
        this.setDescription("Tests uow works when the proxy is replaced without first accessing the proxy.");
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employee = (Employee)uow.readObject(Employee.class, new ExpressionBuilder().get("firstName").like("%Angie%"));
        employee.setAddress(new AddressImpl());
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Angie"));
        Address address = emp.getAddress();
        if (address.getStreet() != null) {
            throw new TestErrorException("Proxy object update did not work properly.\n" + address);
        }
    }
}

