/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;

public class UpdateCacheKeyPropertiesTest
extends AutoVerifyTestCase {
    Employee emp = null;
    SmallProject project = null;

    protected void setup() throws Throwable {
        super.setup();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.project = new SmallProject();
        uow.registerNewObject((Object)this.project);
        this.emp = new Employee();
        uow.registerNewObject((Object)this.emp);
        uow.commit();
    }

    protected void test() throws Throwable {
        block4: {
            super.test();
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            Thread reader = new Thread(new Reader(uow, this.emp, this.project));
            Thread writer = new Thread(new Writer(uow, this.emp, this.project));
            reader.start();
            writer.start();
            writer.join(60000L);
            try {
                if (!writer.isAlive()) break block4;
                try {
                    writer.interrupt();
                    reader.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                UpdateCacheKeyPropertiesTest.fail((String)"Bug 9484687 - deadlock occured.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void reset() throws Throwable {
        super.reset();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.project = (SmallProject)uow.readObject((Object)this.project);
        this.emp = (Employee)uow.readObject((Object)this.emp);
        uow.deleteObject((Object)this.project);
        uow.deleteObject((Object)this.emp);
        uow.commit();
    }

    public static class Writer
    implements Runnable {
        protected UnitOfWork uow;
        protected Project project;
        protected Employee emp;

        public Writer(UnitOfWork uow, Employee emp, Project project) {
            this.uow = uow;
            this.project = project;
            this.emp = emp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UnitOfWork unitOfWork;
            this.project = (Project)this.uow.readObject((Object)this.project);
            this.project.setTeamLeader((org.eclipse.persistence.testing.models.employee.interfaces.Employee)this.uow.readObject((Object)this.emp));
            try {
                unitOfWork = this.uow;
                synchronized (unitOfWork) {
                    try {
                        this.uow.notifyAll();
                        this.uow.wait(6000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.uow.commit();
            }
            catch (Exception ex) {
                System.out.println("Thread was interrupted");
            }
            unitOfWork = this.uow;
            synchronized (unitOfWork) {
                this.uow.notifyAll();
            }
        }
    }

    public static class Reader
    implements Runnable {
        protected UnitOfWork uow;
        protected Project project;
        protected Employee emp;

        public Reader(UnitOfWork uow, Employee emp, Project project) {
            this.uow = uow;
            this.project = project;
            this.emp = emp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UnitOfWork unitOfWork = this.uow;
            synchronized (unitOfWork) {
                try {
                    this.uow.wait(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            AbstractSession session = this.uow.getParent();
            CacheKey zonKey = ((IdentityMapAccessor)session.getIdentityMapAccessor()).getCacheKeyForObject((Object)this.emp);
            zonKey.acquireDeferredLock();
            UnitOfWork unitOfWork2 = this.uow;
            synchronized (unitOfWork2) {
                this.uow.notifyAll();
                try {
                    this.uow.wait(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CacheKey empKey = ((IdentityMapAccessor)session.getIdentityMapAccessor()).getCacheKeyForObject((Object)this.project);
            empKey.acquireDeferredLock();
            empKey.releaseDeferredLock();
            zonKey.releaseDeferredLock();
        }
    }
}

