/*******************************************************************************
 * Copyright (c) 2013, 2015  Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Guy Pelletier - initial API and implementation
 ******************************************************************************/
package org.eclipse.persistence.jpa.config;

/**
 * JPA scripting API implementation.
 *
 * @author Guy Pelletier
 * @since EclipseLink 2.5.1
 */
public interface Version {

    public Property addProperty();
    public Version setAccess(String access);
    public AccessMethods setAccessMethods();
    public Version setAttributeType(String attributeType);
    public Column setColumn();
    public Version setConvert(String convert);
    public Converter setConverter();
    public Index setIndex();
    public Version setMutable(Boolean mutable);
    public Version setName(String name);
    public ObjectTypeConverter setObjectTypeConverter();
    public StructConverter setStructConverter();
    public Temporal setTemporal();
    public TypeConverter setTypeConverter();

}
