/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.tests.aggregate.AgentBuilderHelper;

public class AggregateCollectionClearTest
extends TransactionalTestCase {
    public Object object;
    public Class cls;

    public AggregateCollectionClearTest(Class cls) {
        this.cls = cls;
        this.setName(this.getName() + AgentBuilderHelper.getNameInBrackets(cls));
        this.setDescription("Verifies that when aggregate collections get cleared that the changes are merged.  CR 3013");
    }

    public void setup() {
        super.setup();
        Vector objects = this.getSession().readAllObjects(this.cls);
        for (int index = 0; index < objects.size() && (this.object == null || AgentBuilderHelper.getCustomers(this.object).get(0) == null); ++index) {
            this.object = objects.get(index);
        }
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Object objectClone = uow.readObject(this.object);
        AgentBuilderHelper.getCustomers(objectClone).clear();
        uow.commit();
    }

    public void verify() {
        Object object1 = this.getSession().readObject(this.object);
        if (!AgentBuilderHelper.getCustomers(object1).isEmpty()) {
            throw new TestErrorException("Did not merge change");
        }
    }

    public void reset() {
        super.reset();
    }
}

