/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.jpql.JPQLParameterTestCase;

public class SimpleParameterTestChangingParameters
extends JPQLParameterTestCase {
    Employee first;
    Employee second;
    Vector firstParameters;
    Vector secondParameters;

    @Override
    public void setup() {
        Vector employees = this.getSomeEmployees();
        this.first = (Employee)employees.firstElement();
        this.second = (Employee)employees.elementAt(1);
        String parameterName = "firstName";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").equal(builder.getParameter(parameterName));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.addArgument(parameterName);
        this.firstParameters = new Vector();
        this.firstParameters.add(this.first.getFirstName());
        this.secondParameters = new Vector();
        this.secondParameters.add(this.second.getFirstName());
        Vector firstEmployees = (Vector)this.getSession().executeQuery((DatabaseQuery)raq, (List)this.firstParameters);
        Vector secondEmployees = (Vector)this.getSession().executeQuery((DatabaseQuery)raq, (List)this.secondParameters);
        Vector allEmployees = new Vector();
        allEmployees.addAll(firstEmployees);
        allEmployees.addAll(secondEmployees);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "emp.firstName = ?1 ";
        this.setEjbqlString(ejbqlString);
        this.setOriginalOject(allEmployees);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        super.setup();
    }

    @Override
    public void test() {
        try {
            this.getQuery().addArgument("1");
            this.getSession().logMessage("Running EJBQL -> " + this.getEjbqlString());
            Vector firstSetOfResults = (Vector)this.getSession().executeQuery((DatabaseQuery)this.getQuery(), (List)this.firstParameters);
            Vector secondSetOfResults = (Vector)this.getSession().executeQuery((DatabaseQuery)this.getQuery(), (List)this.secondParameters);
            Vector allResults = new Vector();
            allResults.addAll(firstSetOfResults);
            allResults.addAll(secondSetOfResults);
            this.setReturnedObjects(allResults);
        }
        catch (Exception e) {
            throw new TestErrorException(e.getMessage());
        }
    }
}

