/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class RemoteValueHolderGarbageCollectedOriginalTest
extends TestCase {
    protected Employee originalEmp;
    protected Session originalSession;

    public RemoteValueHolderGarbageCollectedOriginalTest(Session originalSession) {
        this.originalSession = originalSession;
        this.setDescription("Tests committing changes in the UnitOfWork when the originals have been Garbage Collected from the Server");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
        this.originalEmp = (Employee)this.getSession().readObject(Employee.class);
        this.originalEmp.getAddress();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employeeClone = (Employee)uow.registerObject((Object)this.originalEmp);
        this.originalSession.getIdentityMapAccessor().initializeAllIdentityMaps();
        employeeClone.setLastName("Something other than what it was");
        try {
            uow.commit();
            employeeClone = (Employee)this.getSession().readObject((Object)this.originalEmp);
            employeeClone.getAddress();
        }
        catch (Exception exception) {
            throw new TestErrorException("Test failed.  The RemoteValueHolder did not merge correctly when Original had been garbage collected.  Exception:" + exception.toString());
        }
    }
}

