/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.misc.Unsafe;

public class ReflectionHelper {
    private static final Unsafe unsafe;

    public static final void setPrivateStatic(Class c, String name, Object newValue) throws ReflectiveOperationException {
        Field field = c.getDeclaredField(name);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        field.set(null, newValue);
        field.setAccessible(accessible);
    }

    public static final void setPrivateStaticFinal(Class c, String name, Object newValue) throws ReflectiveOperationException {
        Field field = c.getDeclaredField(name);
        Object base = unsafe.staticFieldBase(field);
        long offset = unsafe.staticFieldOffset(field);
        unsafe.putObject(base, offset, newValue);
    }

    public static final <T> T getPrivateStatic(Class c, String name) throws ReflectiveOperationException {
        Field field = c.getDeclaredField(name);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        Object value = field.get(null);
        field.setAccessible(accessible);
        return (T)value;
    }

    public static final <T> T getInstance(Class<T> c, Class<?>[] parameterTypes, Object ... args) throws ReflectiveOperationException {
        Constructor<T> co = c.getDeclaredConstructor(parameterTypes);
        return co.newInstance(args);
    }

    public static final Object invokeMethod(String name, Object obj, Class<?>[] parameterTypes, Object ... args) throws ReflectiveOperationException {
        Method m = obj.getClass().getDeclaredMethod(name, parameterTypes);
        boolean accessible = m.isAccessible();
        if (!accessible) {
            m.setAccessible(true);
        }
        Object result = m.invoke(obj, args);
        if (!accessible) {
            m.setAccessible(accessible);
        }
        return result;
    }

    public static final Object invokeStaticMethod(String name, Class c, Class<?>[] parameterTypes, Object ... args) throws ReflectiveOperationException {
        Method m = c.getDeclaredMethod(name, parameterTypes);
        boolean accessible = m.isAccessible();
        if (!accessible) {
            m.setAccessible(true);
        }
        Object result = m.invoke(null, args);
        if (!accessible) {
            m.setAccessible(accessible);
        }
        return result;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

