/*******************************************************************************
 * Copyright (c) 1998, 2017 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 *     02/20/2009-1.1 Guy Pelletier
 *       - 259829: TABLE_PER_CLASS with abstract classes does not work
 *     12/18/2009-2.1 Guy Pelletier
 *       - 211323: Add class extractor support to the EclipseLink-ORM.XML Schema
 *     01/26/2011-2.3 Guy Pelletier
 *       - 307664:  Lifecycle callbacks not called for object from IndirectSet
 ******************************************************************************/
package org.eclipse.persistence.testing.models.jpa.inheritance;

import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.TogglingFastTableCreator;
import org.eclipse.persistence.tools.schemaframework.*;

/**
 * This class was generated by the TopLink table creator generator.
 * It stores the meta-data (tables) that define the database schema.
 * @see org.eclipse.persistence.sessions.factories.TableCreatorClassGenerator
 */
public class InheritanceTableCreator extends TogglingFastTableCreator {
    public InheritanceTableCreator() {
        setName("EJB3InheritanceProject");

        addTableDefinition(buildBICYCLETable());
        addTableDefinition(buildBOATTable());
        addTableDefinition(buildBUS_TIRETable());
        addTableDefinition(buildBUSTable());
        addTableDefinition(buildCOMPANYTable());
        addTableDefinition(buildFUEL_VEHTable());
        addTableDefinition(buildNONFUEL_VEHTable());
        addTableDefinition(buildSPORTSCARTable());
        addTableDefinition(buildJALOPYTable());
        addTableDefinition(buildVEHICLETable());
        addTableDefinition(buildVEHICLE_DIRECTORYTable());
        addTableDefinition(buildPERSONTable());
        addTableDefinition(buildENGINEERTable());
        addTableDefinition(buildTIREINFOTable());
        addTableDefinition(buildOFFROADTIREINFOTable());
        addTableDefinition(buildMUDTIREINFOTable());
        addTableDefinition(buildTIRERATINGCOMMENTTable());
        addTableDefinition(buildROCKTIREINFOTable());
        addTableDefinition(buildAAATable());
        addTableDefinition(buildAAA_STRINGSETTable());
        addTableDefinition(buildBBBTable());
        addTableDefinition(buildCCCTable());
        addTableDefinition(buildDDDTable());
        addTableDefinition(buildCOMPUTERTable());
        addTableDefinition(buildDESKTOPTable());
        addTableDefinition(buildENGINEER_DESKTOPTable());
        addTableDefinition(buildLAPTOPTable());
        addTableDefinition(buildENGINEER_LAPTOPTable());

        // Table per class testing, all tables prefixed with TPC_
        addTableDefinition(buildWEAPONTable());
        addTableDefinition(buildDIRECTWEAPONTable());
        addTableDefinition(buildINDIRECTWEAPONTable());
        addTableDefinition(buildGUNTable());
        addTableDefinition(buildKNIFETable());
        addTableDefinition(buildPOISONTable());
        addTableDefinition(buildBOMBTable());
        addTableDefinition(buildELIMINATIONTable());
        addTableDefinition(buildDIRECTELIMINATIONTable());
        addTableDefinition(buildINDIRECTELIMINATIONTable());
        addTableDefinition(buildCONTRACTEDPERSONELTable());
        addTableDefinition(buildASSASSINTable());
        addTableDefinition(buildSPECIALASSASSINTable());
        addTableDefinition(buildSOCIALCLUBTable());
        addTableDefinition(buildPERSONELCLUBTable());
        addTableDefinition(buildSMALLASSIGNMENTTable());
        addTableDefinition(buildNICKNAMESTable());

        addTableDefinition(buildAPPLETable());
        addTableDefinition(buildMACBOOKTable());
        addTableDefinition(buildMACBOOKPROTable());

        // bug 396587
        addTableDefinition(buildTPC_SUPERCLASSTable());
        addTableDefinition(buildTPC_SUBCLASSTable());
        addTableDefinition(buildJOINED_SUPERCLASSTable());
        addTableDefinition(buildJOINED_SUBCLASSTable());
        addTableDefinition(buildSTI_SUPERCLASSTable());

        // Bug 404071
        addTableDefinition(buildCMP3_SEEDTable());
        addTableDefinition(buildCMP3_SEEDED_FRUITTable());
        addTableDefinition(buildCMP3_CITRUS_FRUITTable());

        // Bug 458177
        addTableDefinition(buildJPA_FISHTable());
        addTableDefinition(buildJPA_BETTATable());
        addTableDefinition(buildJPA_FISH_TANKTable());
        // Bug 355721
        addTableDefinition(buildJPA_PET_STORETable());
    }

    public TableDefinition buildSTI_SUPERCLASSTable() {
        TableDefinition table = new TableDefinition();
        table.setName("JPA_STI_SUPERCLASS");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldCLASSTYPE = new FieldDefinition();
        fieldCLASSTYPE.setName("CLASSTYPE");
        fieldCLASSTYPE.setTypeName("VARCHAR2");
        fieldCLASSTYPE.setSize(3);
        fieldCLASSTYPE.setSubSize(0);
        fieldCLASSTYPE.setIsPrimaryKey(false);
        fieldCLASSTYPE.setIsIdentity(false);
        fieldCLASSTYPE.setUnique(false);
        fieldCLASSTYPE.setShouldAllowNull(false);
        table.addField(fieldCLASSTYPE);

        FieldDefinition fieldSUPERCLASS_ATTRIBUTE = new FieldDefinition();
        fieldSUPERCLASS_ATTRIBUTE.setName("SUPERCLASS_ATTRIBUTE");
        fieldSUPERCLASS_ATTRIBUTE.setTypeName("VARCHAR2");
        fieldSUPERCLASS_ATTRIBUTE.setSize(64);
        fieldSUPERCLASS_ATTRIBUTE.setSubSize(0);
        fieldSUPERCLASS_ATTRIBUTE.setIsPrimaryKey(false);
        fieldSUPERCLASS_ATTRIBUTE.setIsIdentity(false);
        fieldSUPERCLASS_ATTRIBUTE.setUnique(false);
        fieldSUPERCLASS_ATTRIBUTE.setShouldAllowNull(false);
        table.addField(fieldSUPERCLASS_ATTRIBUTE);

        FieldDefinition fieldSUBCLASS_ATTRIBUTE = new FieldDefinition();
        fieldSUBCLASS_ATTRIBUTE.setName("SUBCLASS_ATTRIBUTE");
        fieldSUBCLASS_ATTRIBUTE.setTypeName("VARCHAR2");
        fieldSUBCLASS_ATTRIBUTE.setSize(64);
        fieldSUBCLASS_ATTRIBUTE.setSubSize(0);
        fieldSUBCLASS_ATTRIBUTE.setIsPrimaryKey(false);
        fieldSUBCLASS_ATTRIBUTE.setIsIdentity(false);
        fieldSUBCLASS_ATTRIBUTE.setUnique(false);
        fieldSUBCLASS_ATTRIBUTE.setShouldAllowNull(true);
        table.addField(fieldSUBCLASS_ATTRIBUTE);

        return table;
    }

    public TableDefinition buildJOINED_SUPERCLASSTable() {
        TableDefinition table = new TableDefinition();
        table.setName("JPA_JOINED_SUPERCLASS");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldCLASSTYPE = new FieldDefinition();
        fieldCLASSTYPE.setName("CLASSTYPE");
        fieldCLASSTYPE.setTypeName("VARCHAR2");
        fieldCLASSTYPE.setSize(3);
        fieldCLASSTYPE.setSubSize(0);
        fieldCLASSTYPE.setIsPrimaryKey(false);
        fieldCLASSTYPE.setIsIdentity(false);
        fieldCLASSTYPE.setUnique(false);
        fieldCLASSTYPE.setShouldAllowNull(false);
        table.addField(fieldCLASSTYPE);

        FieldDefinition fieldSUPERCLASS_ATTRIBUTE = new FieldDefinition();
        fieldSUPERCLASS_ATTRIBUTE.setName("SUPERCLASS_ATTRIBUTE");
        fieldSUPERCLASS_ATTRIBUTE.setTypeName("VARCHAR2");
        fieldSUPERCLASS_ATTRIBUTE.setSize(64);
        fieldSUPERCLASS_ATTRIBUTE.setSubSize(0);
        fieldSUPERCLASS_ATTRIBUTE.setIsPrimaryKey(false);
        fieldSUPERCLASS_ATTRIBUTE.setIsIdentity(false);
        fieldSUPERCLASS_ATTRIBUTE.setUnique(false);
        fieldSUPERCLASS_ATTRIBUTE.setShouldAllowNull(false);
        table.addField(fieldSUPERCLASS_ATTRIBUTE);

        return table;
    }

    public TableDefinition buildJOINED_SUBCLASSTable() {
        TableDefinition table = new TableDefinition();
        table.setName("JPA_JOINED_SUBCLASS");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldSUBCLASS_ATTRIBUTE = new FieldDefinition();
        fieldSUBCLASS_ATTRIBUTE.setName("SUBCLASS_ATTRIBUTE");
        fieldSUBCLASS_ATTRIBUTE.setTypeName("VARCHAR2");
        fieldSUBCLASS_ATTRIBUTE.setSize(64);
        fieldSUBCLASS_ATTRIBUTE.setSubSize(0);
        fieldSUBCLASS_ATTRIBUTE.setIsPrimaryKey(false);
        fieldSUBCLASS_ATTRIBUTE.setIsIdentity(false);
        fieldSUBCLASS_ATTRIBUTE.setUnique(false);
        fieldSUBCLASS_ATTRIBUTE.setShouldAllowNull(true);
        table.addField(fieldSUBCLASS_ATTRIBUTE);

        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        fkConstraint.setName("JPA_JOINED_SUBCLASS_FK1");
        fkConstraint.setTargetTable("JPA_JOINED_SUPERCLASS");
        fkConstraint.addSourceField("ID");
        fkConstraint.addTargetField("ID");
        table.addForeignKeyConstraint(fkConstraint);

        return table;
    }

    public TableDefinition buildTPC_SUPERCLASSTable() {
        TableDefinition table = new TableDefinition();
        table.setName("JPA_TPC_SUPERCLASS");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldSUPERCLASS_ATTRIBUTE = new FieldDefinition();
        fieldSUPERCLASS_ATTRIBUTE.setName("SUPERCLASS_ATTRIBUTE");
        fieldSUPERCLASS_ATTRIBUTE.setTypeName("VARCHAR2");
        fieldSUPERCLASS_ATTRIBUTE.setSize(64);
        fieldSUPERCLASS_ATTRIBUTE.setSubSize(0);
        fieldSUPERCLASS_ATTRIBUTE.setIsPrimaryKey(false);
        fieldSUPERCLASS_ATTRIBUTE.setIsIdentity(false);
        fieldSUPERCLASS_ATTRIBUTE.setUnique(false);
        fieldSUPERCLASS_ATTRIBUTE.setShouldAllowNull(false);
        table.addField(fieldSUPERCLASS_ATTRIBUTE);

        return table;
    }

    public TableDefinition buildTPC_SUBCLASSTable() {
        TableDefinition table = new TableDefinition();
        table.setName("JPA_TPC_SUBCLASS");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldSUPERCLASS_ATTRIBUTE = new FieldDefinition();
        fieldSUPERCLASS_ATTRIBUTE.setName("SUPERCLASS_ATTRIBUTE");
        fieldSUPERCLASS_ATTRIBUTE.setTypeName("VARCHAR2");
        fieldSUPERCLASS_ATTRIBUTE.setSize(64);
        fieldSUPERCLASS_ATTRIBUTE.setSubSize(0);
        fieldSUPERCLASS_ATTRIBUTE.setIsPrimaryKey(false);
        fieldSUPERCLASS_ATTRIBUTE.setIsIdentity(false);
        fieldSUPERCLASS_ATTRIBUTE.setUnique(false);
        fieldSUPERCLASS_ATTRIBUTE.setShouldAllowNull(false);
        table.addField(fieldSUPERCLASS_ATTRIBUTE);

        FieldDefinition fieldSUBCLASS_ATTRIBUTE = new FieldDefinition();
        fieldSUBCLASS_ATTRIBUTE.setName("SUBCLASS_ATTRIBUTE");
        fieldSUBCLASS_ATTRIBUTE.setTypeName("VARCHAR2");
        fieldSUBCLASS_ATTRIBUTE.setSize(64);
        fieldSUBCLASS_ATTRIBUTE.setSubSize(0);
        fieldSUBCLASS_ATTRIBUTE.setIsPrimaryKey(false);
        fieldSUBCLASS_ATTRIBUTE.setIsIdentity(false);
        fieldSUBCLASS_ATTRIBUTE.setUnique(false);
        fieldSUBCLASS_ATTRIBUTE.setShouldAllowNull(true);
        table.addField(fieldSUBCLASS_ATTRIBUTE);

        return table;
    }

    public TableDefinition buildAPPLETable() {
        TableDefinition table = new TableDefinition();
        table.setName("JPA_APPLE");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        return table;
    }

    public TableDefinition buildMACBOOKTable() {
        TableDefinition table = new TableDefinition();
        table.setName("JPA_MACBOOK");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("JPA_APPLE.ID");
        table.addField(fieldID);

        FieldDefinition fieldRAM = new FieldDefinition();
        fieldRAM.setName("RAM");
        fieldRAM.setTypeName("NUMBER");
        fieldRAM.setSize(10);
        fieldRAM.setSubSize(0);
        fieldRAM.setIsPrimaryKey(false);
        fieldRAM.setIsIdentity(false);
        fieldRAM.setUnique(false);
        fieldRAM.setShouldAllowNull(true);
        table.addField(fieldRAM);

        return table;
    }

    public TableDefinition buildMACBOOKPROTable() {
        TableDefinition table = new TableDefinition();
        table.setName("JPA_MACBOOK_PRO");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("JPA_MACBOOK.ID");
        table.addField(fieldID);

        FieldDefinition fieldCOLOR = new FieldDefinition();
        fieldCOLOR.setName("COLOR");
        fieldCOLOR.setTypeName("VARCHAR2");
        fieldCOLOR.setSize(10);
        fieldCOLOR.setSubSize(0);
        fieldCOLOR.setIsPrimaryKey(false);
        fieldCOLOR.setIsIdentity(false);
        fieldCOLOR.setUnique(false);
        fieldCOLOR.setShouldAllowNull(true);
        table.addField(fieldCOLOR);

        return table;
    }

    public TableDefinition buildBICYCLETable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_BICYCLE");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_NONFUEL_VEH.ID");
        table.addField(fieldID);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR2");
        fieldDESCRIP.setSize(10);
        fieldDESCRIP.setSubSize(0);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        return table;
    }

    public TableDefinition buildBOATTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_BOAT");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("BOAT_ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_NONFUEL_VEH.ID");
        table.addField(fieldID);

        FieldDefinition fieldMODEL = new FieldDefinition();
        fieldMODEL.setName("MODEL");
        fieldMODEL.setTypeName("VARCHAR2");
        fieldMODEL.setSize(10);
        fieldMODEL.setSubSize(0);
        fieldMODEL.setIsPrimaryKey(false);
        fieldMODEL.setIsIdentity(false);
        fieldMODEL.setUnique(false);
        fieldMODEL.setShouldAllowNull(true);
        table.addField(fieldMODEL);

        return table;
    }

    public TableDefinition buildBUS_TIRETable(){
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_BUS_CMP3_TIRE");

        FieldDefinition fieldBusID = new FieldDefinition();
        fieldBusID.setName("Bus_ID");
        fieldBusID.setTypeName("NUMBER");
        fieldBusID.setSize(15);
        fieldBusID.setSubSize(0);
        fieldBusID.setIsPrimaryKey(true);
        fieldBusID.setIsIdentity(false);
        fieldBusID.setUnique(false);
        fieldBusID.setShouldAllowNull(false);
        fieldBusID.setForeignKeyFieldName("CMP3_BUS.BUS_ID");
        table.addField(fieldBusID);

        FieldDefinition fieldTireID = new FieldDefinition();
        fieldTireID.setName("tires_ID");
        fieldTireID.setTypeName("NUMBER");
        fieldTireID.setSize(15);
        fieldTireID.setSubSize(0);
        fieldTireID.setIsPrimaryKey(true);
        fieldTireID.setIsIdentity(false);
        fieldTireID.setUnique(false);
        fieldTireID.setShouldAllowNull(false);
        fieldTireID.setForeignKeyFieldName("CMP3_TIRE.ID");
        table.addField(fieldTireID);

        return table;
    }

    public TableDefinition buildBUSTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_BUS");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("BUS_ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_FUEL_VEH.ID");
        table.addField(fieldID);

        FieldDefinition fieldDRIVER_ID = new FieldDefinition();
        fieldDRIVER_ID.setName("DRIVER_ID");
        fieldDRIVER_ID.setTypeName("NUMBER");
        fieldDRIVER_ID.setSize(15);
        fieldDRIVER_ID.setSubSize(0);
        fieldDRIVER_ID.setIsPrimaryKey(false);
        fieldDRIVER_ID.setIsIdentity(false);
        fieldDRIVER_ID.setUnique(false);
        fieldDRIVER_ID.setShouldAllowNull(true);
        table.addField(fieldDRIVER_ID);

        ForeignKeyConstraint foreignKeyBUS_PERSON = new ForeignKeyConstraint();
        foreignKeyBUS_PERSON.setName("BUSDRIVER_ID");
        foreignKeyBUS_PERSON.setTargetTable("CMP3_PERSON");
        foreignKeyBUS_PERSON.addSourceField("DRIVER_ID");
        foreignKeyBUS_PERSON.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyBUS_PERSON);

        return table;
    }

    public TableDefinition buildROCKTIREINFOTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_ROCK_TIRE");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_OFFROAD_TIRE.ID");
        table.addField(fieldID);

        FieldDefinition fieldGRIP = new FieldDefinition();
        fieldGRIP.setName("GRIP");
        fieldGRIP.setTypeName("NUMBER");
        fieldGRIP.setSize(15);
        fieldGRIP.setSubSize(0);
        fieldGRIP.setIsPrimaryKey(false);
        fieldGRIP.setIsIdentity(false);
        fieldGRIP.setUnique(false);
        fieldGRIP.setShouldAllowNull(true);
        table.addField(fieldGRIP);

        return table;
    }

    public TableDefinition buildSPORTSCARTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_SPORTS_CAR");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_FUEL_VEH.ID");
        table.addField(fieldID);

        FieldDefinition fieldFUEL_CAP = new FieldDefinition();
        fieldFUEL_CAP.setName("MAX_SPEED");
        fieldFUEL_CAP.setTypeName("NUMBER");
        fieldFUEL_CAP.setSize(10);
        fieldFUEL_CAP.setSubSize(0);
        fieldFUEL_CAP.setIsPrimaryKey(false);
        fieldFUEL_CAP.setIsIdentity(false);
        fieldFUEL_CAP.setUnique(false);
        fieldFUEL_CAP.setShouldAllowNull(true);
        table.addField(fieldFUEL_CAP);

        return table;
    }

    public TableDefinition buildJALOPYTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_JALOPY");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_FUEL_VEH.ID");
        table.addField(fieldID);

        FieldDefinition fieldRUST = new FieldDefinition();
        fieldRUST.setName("PERCENTRUST");
        fieldRUST.setTypeName("NUMBER");
        fieldRUST.setSize(10);
        fieldRUST.setSubSize(0);
        fieldRUST.setIsPrimaryKey(false);
        fieldRUST.setIsIdentity(false);
        fieldRUST.setUnique(false);
        fieldRUST.setShouldAllowNull(true);
        table.addField(fieldRUST);

        return table;
    }
    public TableDefinition buildCOMPANYTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_COMPANY");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR2");
        fieldNAME.setSize(100);
        fieldNAME.setSubSize(0);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(false);
        table.addField(fieldNAME);

        return table;
    }

    public TableDefinition buildFUEL_VEHTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_FUEL_VEH");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_VEHICLE.ID");
        table.addField(fieldID);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR2");
        fieldDESCRIP.setSize(30);
        fieldDESCRIP.setSubSize(0);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        FieldDefinition fieldFUEL_CAP = new FieldDefinition();
        fieldFUEL_CAP.setName("FUEL_CAP");
        fieldFUEL_CAP.setTypeName("NUMBER");
        fieldFUEL_CAP.setSize(10);
        fieldFUEL_CAP.setSubSize(0);
        fieldFUEL_CAP.setIsPrimaryKey(false);
        fieldFUEL_CAP.setIsIdentity(false);
        fieldFUEL_CAP.setUnique(false);
        fieldFUEL_CAP.setShouldAllowNull(true);
        table.addField(fieldFUEL_CAP);

        FieldDefinition fieldFUEL_TYP = new FieldDefinition();
        fieldFUEL_TYP.setName("FUEL_TYP");
        fieldFUEL_TYP.setTypeName("VARCHAR2");
        fieldFUEL_TYP.setSize(30);
        fieldFUEL_TYP.setSubSize(0);
        fieldFUEL_TYP.setIsPrimaryKey(false);
        fieldFUEL_TYP.setIsIdentity(false);
        fieldFUEL_TYP.setUnique(false);
        fieldFUEL_TYP.setShouldAllowNull(true);
        table.addField(fieldFUEL_TYP);

        FieldDefinition fieldCOLOUR = new FieldDefinition();
        fieldCOLOUR.setName("COLOUR");
        fieldCOLOUR.setTypeName("VARCHAR2");
        fieldCOLOUR.setSize(20);
        fieldCOLOUR.setSubSize(0);
        fieldCOLOUR.setIsPrimaryKey(false);
        fieldCOLOUR.setIsIdentity(false);
        fieldCOLOUR.setUnique(false);
        fieldCOLOUR.setShouldAllowNull(true);
        table.addField(fieldCOLOUR);

        return table;
    }

    public TableDefinition buildMUDTIREINFOTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_MUD_TIRE");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_OFFROAD_TIRE.ID");
        table.addField(fieldID);

        FieldDefinition fieldTREAD = new FieldDefinition();
        fieldTREAD.setName("TREAD_DEPTH");
        fieldTREAD.setTypeName("NUMBER");
        fieldTREAD.setSize(15);
        fieldTREAD.setSubSize(0);
        fieldTREAD.setIsPrimaryKey(false);
        fieldTREAD.setIsIdentity(false);
        fieldTREAD.setUnique(false);
        fieldTREAD.setShouldAllowNull(true);
        table.addField(fieldTREAD);

        FieldDefinition fieldRATING = new FieldDefinition();
        fieldRATING.setName("RATING");
        fieldRATING.setTypeName("VARCHAR2");
        fieldRATING.setSize(20);
        fieldRATING.setSubSize(0);
        fieldRATING.setIsPrimaryKey(false);
        fieldRATING.setIsIdentity(false);
        fieldRATING.setUnique(false);
        fieldRATING.setShouldAllowNull(true);
        table.addField(fieldRATING);

        FieldDefinition fieldCOMMENT = new FieldDefinition();
        fieldCOMMENT.setName("COMMENT_ID");
        fieldCOMMENT.setTypeName("NUMBER");
        fieldCOMMENT.setSize(15);
        fieldCOMMENT.setSubSize(0);
        fieldCOMMENT.setShouldAllowNull(true);
        fieldCOMMENT.setIsPrimaryKey(false);
        fieldCOMMENT.setIsIdentity(false);
        fieldCOMMENT.setUnique(false);
        fieldCOMMENT.setForeignKeyFieldName("CMP3_TIRE_RATING_COMMENT.ID");
        table.addField(fieldCOMMENT);

        return table;
    }

    public TableDefinition buildTIRERATINGCOMMENTTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_TIRE_RATING_COMMENT");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR2");
        fieldDESCRIP.setSize(100);
        fieldDESCRIP.setSubSize(0);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        return table;
    }

    public TableDefinition buildNONFUEL_VEHTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_NONFUEL_VEH");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_VEHICLE.ID");
        table.addField(fieldID);

        FieldDefinition fieldCOLOR = new FieldDefinition();
        fieldCOLOR.setName("COLOR");
        fieldCOLOR.setTypeName("VARCHAR2");
        fieldCOLOR.setSize(20);
        fieldCOLOR.setSubSize(0);
        fieldCOLOR.setIsPrimaryKey(false);
        fieldCOLOR.setIsIdentity(false);
        fieldCOLOR.setUnique(false);
        fieldCOLOR.setShouldAllowNull(true);
        table.addField(fieldCOLOR);

        return table;
    }

    public TableDefinition buildENGINEERTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_ENGINEER");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_PERSON.ID");
        table.addField(fieldID);

        FieldDefinition fieldTITLE = new FieldDefinition();
        fieldTITLE.setName("TITLE");
        fieldTITLE.setTypeName("VARCHAR2");
        fieldTITLE.setSize(26);
        fieldTITLE.setSubSize(0);
        fieldTITLE.setIsPrimaryKey(false);
        fieldTITLE.setIsIdentity(false);
        fieldTITLE.setUnique(false);
        fieldTITLE.setShouldAllowNull(true);
        table.addField(fieldTITLE);

        FieldDefinition fieldCOMPANY_ID = new FieldDefinition();
        fieldCOMPANY_ID.setName("COMPANY_ID");
        fieldCOMPANY_ID.setTypeName("NUMBER");
        fieldCOMPANY_ID.setSize(15);
        fieldCOMPANY_ID.setSubSize(0);
        fieldCOMPANY_ID.setIsPrimaryKey(false);
        fieldCOMPANY_ID.setIsIdentity(false);
        fieldCOMPANY_ID.setUnique(false);
        fieldCOMPANY_ID.setShouldAllowNull(true);
        fieldCOMPANY_ID.setForeignKeyFieldName("CMP3_COMPANY.ID");
        table.addField(fieldCOMPANY_ID);

        return table;
    }

    public TableDefinition buildOFFROADTIREINFOTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_OFFROAD_TIRE");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_TIRE.ID");
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR2");
        fieldNAME.setSize(25);
        fieldNAME.setSubSize(0);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        FieldDefinition fieldCODE = new FieldDefinition();
        fieldCODE.setName("CODE");
        fieldCODE.setTypeName("VARCHAR2");
        fieldCODE.setSize(20);
        fieldCODE.setSubSize(0);
        fieldCODE.setIsPrimaryKey(false);
        fieldCODE.setIsIdentity(false);
        fieldCODE.setUnique(false);
        fieldCODE.setShouldAllowNull(true);
        table.addField(fieldCODE);

        FieldDefinition fieldDTYPE = new FieldDefinition();
        fieldDTYPE.setName("DTYPE");
        fieldDTYPE.setTypeName("VARCHAR2");
        fieldDTYPE.setSize(15);
        fieldDTYPE.setSubSize(0);
        fieldDTYPE.setIsPrimaryKey(false);
        fieldDTYPE.setIsIdentity(false);
        fieldDTYPE.setUnique(false);
        fieldDTYPE.setShouldAllowNull(true);
        table.addField(fieldDTYPE);

        return table;
    }

    public TableDefinition buildPERSONTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_PERSON");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR2");
        fieldNAME.setSize(20);
        fieldNAME.setSubSize(0);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        FieldDefinition fieldC_TYPE = new FieldDefinition();
        fieldC_TYPE.setName("DTYPE");
        fieldC_TYPE.setTypeName("NUMBER");
        fieldC_TYPE.setSize(15);
        fieldC_TYPE.setSubSize(0);
        fieldC_TYPE.setIsPrimaryKey(false);
        fieldC_TYPE.setIsIdentity(false);
        fieldC_TYPE.setUnique(false);
        fieldC_TYPE.setShouldAllowNull(true);
        table.addField(fieldC_TYPE);

        FieldDefinition fieldREP_ID = new FieldDefinition();
        fieldREP_ID.setName("REP_ID");
        fieldREP_ID.setTypeName("NUMBER");
        fieldREP_ID.setSize(15);
        fieldREP_ID.setSubSize(0);
        fieldREP_ID.setIsPrimaryKey(false);
        fieldREP_ID.setIsIdentity(false);
        fieldREP_ID.setUnique(false);
        fieldREP_ID.setShouldAllowNull(true);
        table.addField(fieldREP_ID);

        FieldDefinition fieldFRIEND_ID = new FieldDefinition();
        fieldFRIEND_ID.setName("FRIEND_ID");
        fieldFRIEND_ID.setTypeName("NUMBER");
        fieldFRIEND_ID.setSize(15);
        fieldFRIEND_ID.setSubSize(0);
        fieldFRIEND_ID.setIsPrimaryKey(false);
        fieldFRIEND_ID.setIsIdentity(false);
        fieldFRIEND_ID.setUnique(false);
        fieldFRIEND_ID.setShouldAllowNull(true);
        table.addField(fieldFRIEND_ID);

        FieldDefinition fieldCAR_ID = new FieldDefinition();
        fieldCAR_ID.setName("CAR_ID");
        fieldCAR_ID.setTypeName("NUMBER");
        fieldCAR_ID.setSize(15);
        fieldCAR_ID.setSubSize(0);
        fieldCAR_ID.setIsPrimaryKey(false);
        fieldCAR_ID.setIsIdentity(false);
        fieldCAR_ID.setUnique(false);
        fieldCAR_ID.setShouldAllowNull(true);
        table.addField(fieldCAR_ID);

        ForeignKeyConstraint foreignKeyPERSON_CAR = new ForeignKeyConstraint();
        foreignKeyPERSON_CAR.setName("PERSON_CAR");
        foreignKeyPERSON_CAR.setTargetTable("CMP3_VEHICLE");
        foreignKeyPERSON_CAR.addSourceField("CAR_ID");
        foreignKeyPERSON_CAR.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyPERSON_CAR);

        ForeignKeyConstraint foreignKeyPERSON_ENGINEER = new ForeignKeyConstraint();
        foreignKeyPERSON_ENGINEER.setName("PERSON_ENGINEER");
        foreignKeyPERSON_ENGINEER.setTargetTable("CMP3_ENGINEER");
        foreignKeyPERSON_ENGINEER.addSourceField("FRIEND_ID");
        foreignKeyPERSON_ENGINEER.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyPERSON_ENGINEER);

        ForeignKeyConstraint foreignKeyPERSON_REP = new ForeignKeyConstraint();
        foreignKeyPERSON_REP.setName("PERSON_LAWYER");
        foreignKeyPERSON_REP.setTargetTable("CMP3_PERSON");
        foreignKeyPERSON_REP.addSourceField("REP_ID");
        foreignKeyPERSON_REP.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyPERSON_REP);

        return table;
    }

    public TableDefinition buildVEHICLETable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_VEHICLE");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldTYPE = new FieldDefinition();
        fieldTYPE.setName("VEH_TYPE");
        fieldTYPE.setTypeName("VARCHAR2");
        fieldTYPE.setSize(15);
        fieldTYPE.setSubSize(0);
        fieldTYPE.setIsPrimaryKey(false);
        fieldTYPE.setIsIdentity(false);
        fieldTYPE.setUnique(false);
        fieldTYPE.setShouldAllowNull(true);
        table.addField(fieldTYPE);

        FieldDefinition fieldCAPACITY = new FieldDefinition();
        fieldCAPACITY.setName("CAPACITY");
        fieldCAPACITY.setTypeName("NUMBER");
        fieldCAPACITY.setSize(10);
        fieldCAPACITY.setSubSize(0);
        fieldCAPACITY.setIsPrimaryKey(false);
        fieldCAPACITY.setIsIdentity(false);
        fieldCAPACITY.setUnique(false);
        fieldCAPACITY.setShouldAllowNull(true);
        table.addField(fieldCAPACITY);

        FieldDefinition fieldOWNER_ID = new FieldDefinition();
        fieldOWNER_ID.setName("OWNER_ID");
        fieldOWNER_ID.setTypeName("NUMBER");
        fieldOWNER_ID.setSize(15);
        fieldOWNER_ID.setSubSize(0);
        fieldOWNER_ID.setIsPrimaryKey(false);
        fieldOWNER_ID.setIsIdentity(false);
        fieldOWNER_ID.setUnique(false);
        fieldOWNER_ID.setShouldAllowNull(true);
        table.addField(fieldOWNER_ID);

        FieldDefinition fieldDIRECTORY_ID = new FieldDefinition();
        fieldDIRECTORY_ID.setName("DIRECTORY_ID");
        fieldDIRECTORY_ID.setTypeName("NUMBER");
        fieldDIRECTORY_ID.setSize(15);
        fieldDIRECTORY_ID.setSubSize(0);
        fieldDIRECTORY_ID.setIsPrimaryKey(false);
        fieldDIRECTORY_ID.setIsIdentity(false);
        fieldDIRECTORY_ID.setUnique(false);
        fieldDIRECTORY_ID.setShouldAllowNull(true);
        table.addField(fieldDIRECTORY_ID);

        ForeignKeyConstraint foreignKeyVEHICLE_COMPANY = new ForeignKeyConstraint();
        foreignKeyVEHICLE_COMPANY.setName("VEHICLE_COMPANY_FK");
        foreignKeyVEHICLE_COMPANY.setTargetTable("CMP3_COMPANY");
        foreignKeyVEHICLE_COMPANY.addSourceField("OWNER_ID");
        foreignKeyVEHICLE_COMPANY.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyVEHICLE_COMPANY);

        ForeignKeyConstraint foreignKeyVEHICLE_DIRECTORY = new ForeignKeyConstraint();
        foreignKeyVEHICLE_DIRECTORY.setName("VEHICLE_DIRECTORY_FK");
        foreignKeyVEHICLE_DIRECTORY.setTargetTable("CMP3_VEHICLE_DIRECTORY");
        foreignKeyVEHICLE_DIRECTORY.addSourceField("DIRECTORY_ID");
        foreignKeyVEHICLE_DIRECTORY.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyVEHICLE_DIRECTORY);


        return table;
    }

    public TableDefinition buildVEHICLE_DIRECTORYTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_VEHICLE_DIRECTORY");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR2");
        fieldNAME.setSize(15);
        fieldNAME.setSubSize(0);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        return table;
    }

    public TableDefinition buildTIREINFOTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_TIRE");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        fieldID = new FieldDefinition();
        fieldID.setName("PRESSURE");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(false);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(true);
        table.addField(fieldID);

        fieldID = new FieldDefinition();
        fieldID.setName("SPEEDRATING");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(false);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(true);
        table.addField(fieldID);

        FieldDefinition fieldTYPE = new FieldDefinition();
        fieldTYPE.setName("TIRE_TYPE");
        fieldTYPE.setTypeName("VARCHAR2");
        fieldTYPE.setSize(15);
        fieldTYPE.setSubSize(0);
        fieldTYPE.setIsPrimaryKey(false);
        fieldTYPE.setIsIdentity(false);
        fieldTYPE.setUnique(false);
        fieldTYPE.setShouldAllowNull(true);
        table.addField(fieldTYPE);

        return table;
    }

    public TableDefinition buildAAATable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_AAA");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldDTYPES = new FieldDefinition();
        fieldDTYPES.setName("DTYPES");
        fieldDTYPES.setTypeName("VARCHAR");
        fieldDTYPES.setSize(2);
        fieldDTYPES.setIsPrimaryKey(false);
        fieldDTYPES.setIsIdentity(false);
        fieldDTYPES.setUnique(false);
        fieldDTYPES.setShouldAllowNull(true);
        table.addField(fieldDTYPES);

        FieldDefinition fieldSTRINGDATA = new FieldDefinition();
        fieldSTRINGDATA.setName("FOO");
        fieldSTRINGDATA.setTypeName("VARCHAR");
        fieldSTRINGDATA.setSize(30);
        fieldSTRINGDATA.setIsPrimaryKey(false);
        fieldSTRINGDATA.setIsIdentity(false);
        fieldSTRINGDATA.setUnique(false);
        fieldSTRINGDATA.setShouldAllowNull(true);
        table.addField(fieldSTRINGDATA);

        return table;
    }

    public static TableDefinition buildAAA_STRINGSETTable() {
        TableDefinition table = new TableDefinition();
        table.setName("AAA_STRINGSET");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("AAA_ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);//needed to prevent duplicates
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition DESCRIP_field = new FieldDefinition();
        DESCRIP_field.setName("STRINGSET");
        DESCRIP_field.setTypeName("VARCHAR");
        DESCRIP_field.setSize(40);
        fieldID.setIsPrimaryKey(true);//needed to prevent duplicates
        DESCRIP_field.setIsPrimaryKey(false);
        DESCRIP_field.setUnique(false);
        DESCRIP_field.setIsIdentity(false);
        table.addField(DESCRIP_field);

        return table;
    }

    public TableDefinition buildBBBTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_BBB");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_AAA.ID");
        table.addField(fieldID);

        FieldDefinition fieldSTRINGDATA = new FieldDefinition();
        fieldSTRINGDATA.setName("BAR");
        fieldSTRINGDATA.setTypeName("VARCHAR");
        fieldSTRINGDATA.setSize(30);
        fieldSTRINGDATA.setIsPrimaryKey(false);
        fieldSTRINGDATA.setIsIdentity(false);
        fieldSTRINGDATA.setUnique(false);
        fieldSTRINGDATA.setShouldAllowNull(true);
        table.addField(fieldSTRINGDATA);

        return table;
    }

    public TableDefinition buildCCCTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_CCC");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_BBB.ID");
        table.addField(fieldID);

        FieldDefinition fieldSTRINGDATA = new FieldDefinition();
        fieldSTRINGDATA.setName("XYZ");
        fieldSTRINGDATA.setTypeName("VARCHAR");
        fieldSTRINGDATA.setSize(30);
        fieldSTRINGDATA.setIsPrimaryKey(false);
        fieldSTRINGDATA.setIsIdentity(false);
        fieldSTRINGDATA.setUnique(false);
        fieldSTRINGDATA.setShouldAllowNull(true);
        table.addField(fieldSTRINGDATA);

        return table;
    }

    public TableDefinition buildDDDTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_DDD");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldPOSTLOADCOUNT = new FieldDefinition();
        fieldPOSTLOADCOUNT.setName("POST_LOAD_COUNT");
        fieldPOSTLOADCOUNT.setTypeName("NUMBER");
        fieldPOSTLOADCOUNT.setSize(15);
        fieldPOSTLOADCOUNT.setSubSize(0);
        fieldPOSTLOADCOUNT.setIsPrimaryKey(false);
        fieldPOSTLOADCOUNT.setIsIdentity(false);
        fieldPOSTLOADCOUNT.setUnique(false);
        fieldPOSTLOADCOUNT.setShouldAllowNull(true);
        table.addField(fieldPOSTLOADCOUNT);

        FieldDefinition fieldELPOSTLOADCOUNT = new FieldDefinition();
        fieldELPOSTLOADCOUNT.setName("EL_POST_LOAD_COUNT");
        fieldELPOSTLOADCOUNT.setTypeName("NUMBER");
        fieldELPOSTLOADCOUNT.setSize(15);
        fieldELPOSTLOADCOUNT.setSubSize(0);
        fieldELPOSTLOADCOUNT.setIsPrimaryKey(false);
        fieldELPOSTLOADCOUNT.setIsIdentity(false);
        fieldELPOSTLOADCOUNT.setUnique(false);
        fieldELPOSTLOADCOUNT.setShouldAllowNull(true);
        table.addField(fieldELPOSTLOADCOUNT);

        FieldDefinition aaaID = new FieldDefinition();
        aaaID.setName("AAA_ID");
        aaaID.setTypeName("NUMBER");
        aaaID.setSize(15);
        aaaID.setSubSize(0);
        aaaID.setShouldAllowNull(true);
        aaaID.setIsPrimaryKey(false);
        aaaID.setUnique(false);
        aaaID.setIsIdentity(false);
        aaaID.setForeignKeyFieldName("CMP3_AAA.ID");
        table.addField(aaaID);

        return table;
    }

    public TableDefinition buildCOMPUTERTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_COMPUTER");

        FieldDefinition fieldMFR = new FieldDefinition();
        fieldMFR.setName("MFR");
        fieldMFR.setTypeName("VARCHAR");
        fieldMFR.setSize(30);
        fieldMFR.setIsPrimaryKey(true);
        fieldMFR.setIsIdentity(false);
        fieldMFR.setUnique(false);
        fieldMFR.setShouldAllowNull(false);
        table.addField(fieldMFR);

        FieldDefinition fieldSNO = new FieldDefinition();
        fieldSNO.setName("SNO");
        fieldSNO.setTypeName("NUMBER");
        fieldSNO.setSize(10);
        fieldSNO.setSubSize(0);
        fieldSNO.setIsPrimaryKey(true);
        fieldSNO.setIsIdentity(false);
        fieldSNO.setUnique(false);
        fieldSNO.setShouldAllowNull(false);
        table.addField(fieldSNO);

        FieldDefinition fieldDTYPE = new FieldDefinition();
        fieldDTYPE.setName("DTYPE");
        fieldDTYPE.setTypeName("VARCHAR");
        fieldDTYPE.setSize(20);
        fieldDTYPE.setIsPrimaryKey(false);
        fieldDTYPE.setIsIdentity(false);
        fieldDTYPE.setUnique(false);
        fieldDTYPE.setShouldAllowNull(true);
        table.addField(fieldDTYPE);

        return table;
    }

    public TableDefinition buildDESKTOPTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_DESKTOP");

        FieldDefinition fieldMFR = new FieldDefinition();
        fieldMFR.setName("DT_MFR");
        fieldMFR.setTypeName("VARCHAR");
        fieldMFR.setSize(30);
        fieldMFR.setIsPrimaryKey(true);
        fieldMFR.setIsIdentity(false);
        fieldMFR.setUnique(false);
        fieldMFR.setShouldAllowNull(false);
        table.addField(fieldMFR);

        FieldDefinition fieldSNO = new FieldDefinition();
        fieldSNO.setName("DT_SNO");
        fieldSNO.setTypeName("NUMBER");
        fieldSNO.setSize(10);
        fieldSNO.setSubSize(0);
        fieldSNO.setIsPrimaryKey(true);
        fieldSNO.setIsIdentity(false);
        fieldSNO.setUnique(false);
        fieldSNO.setShouldAllowNull(false);
        table.addField(fieldSNO);

        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        fkConstraint.setName("CMP3_DESKTOP_FK");
        fkConstraint.addSourceField("DT_MFR");
        fkConstraint.addSourceField("DT_SNO");
        fkConstraint.setTargetTable("CMP3_COMPUTER");
        fkConstraint.addTargetField("MFR");
        fkConstraint.addTargetField("SNO");
        table.addForeignKeyConstraint(fkConstraint);

        return table;
    }

    // Engineer-Desktop many-to-many relationship table
    public TableDefinition buildENGINEER_DESKTOPTable() {
        TableDefinition table = new TableDefinition();

        table.setName("CMP3_ENGINEER_DESKTOP");

        FieldDefinition fieldEngineerId = new FieldDefinition();
        fieldEngineerId.setName("ENGINEER_ID");
        fieldEngineerId.setTypeName("NUMBER");
        fieldEngineerId.setSize(15);
        fieldEngineerId.setSubSize(0);
        fieldEngineerId.setShouldAllowNull(false);
        fieldEngineerId.setIsPrimaryKey(true);
        fieldEngineerId.setUnique(false);
        fieldEngineerId.setIsIdentity(false);
        fieldEngineerId.setForeignKeyFieldName("CMP3_ENGINEER.ID");
        table.addField(fieldEngineerId);

        FieldDefinition fieldDesktopMFR = new FieldDefinition();
        fieldDesktopMFR.setName("DESKTOP_MFR");
        fieldDesktopMFR.setTypeName("VARCHAR");
        fieldDesktopMFR.setSize(30);
        fieldDesktopMFR.setIsPrimaryKey(true);
        fieldDesktopMFR.setIsIdentity(false);
        fieldDesktopMFR.setUnique(false);
        fieldDesktopMFR.setShouldAllowNull(false);
        table.addField(fieldDesktopMFR);

        FieldDefinition fieldDesktopSNO = new FieldDefinition();
        fieldDesktopSNO.setName("DESKTOP_SNO");
        fieldDesktopSNO.setTypeName("NUMBER");
        fieldDesktopSNO.setSize(10);
        fieldDesktopSNO.setSubSize(0);
        fieldDesktopSNO.setIsPrimaryKey(true);
        fieldDesktopSNO.setIsIdentity(false);
        fieldDesktopSNO.setUnique(false);
        fieldDesktopSNO.setShouldAllowNull(false);
        table.addField(fieldDesktopSNO);

        return table;
    }

    public TableDefinition buildLAPTOPTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_LAPTOP");

        FieldDefinition fieldMFR = new FieldDefinition();
        fieldMFR.setName("MFR");
        fieldMFR.setTypeName("VARCHAR");
        fieldMFR.setSize(30);
        fieldMFR.setIsPrimaryKey(true);
        fieldMFR.setIsIdentity(false);
        fieldMFR.setUnique(false);
        fieldMFR.setShouldAllowNull(false);
        table.addField(fieldMFR);

        FieldDefinition fieldSNO = new FieldDefinition();
        fieldSNO.setName("SNO");
        fieldSNO.setTypeName("NUMBER");
        fieldSNO.setSize(10);
        fieldSNO.setSubSize(0);
        fieldSNO.setIsPrimaryKey(true);
        fieldSNO.setIsIdentity(false);
        fieldSNO.setUnique(false);
        fieldSNO.setShouldAllowNull(false);
        table.addField(fieldSNO);

        // FOREIGN KEY (MFR, SNO) REFERENCES CMP3_COMPUTER (MFR, SNO)
        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        fkConstraint.setName("CMP3_LAPTOP_FK1");
        fkConstraint.addSourceField("MFR");
        fkConstraint.addSourceField("SNO");
        fkConstraint.setTargetTable("CMP3_COMPUTER");
        fkConstraint.addTargetField("MFR");
        fkConstraint.addTargetField("SNO");

        table.addForeignKeyConstraint(fkConstraint);
        return table;
    }

    // Engineer-Laptop many-to-many relationship table
    public TableDefinition buildENGINEER_LAPTOPTable() {
        TableDefinition table = new TableDefinition();

        table.setName("CMP3_ENGINEER_LAPTOP");

        FieldDefinition fieldEngineerId = new FieldDefinition();
        fieldEngineerId.setName("ENGINEER_ID");
        fieldEngineerId.setTypeName("NUMBER");
        fieldEngineerId.setSize(15);
        fieldEngineerId.setSubSize(0);
        fieldEngineerId.setShouldAllowNull(false);
        fieldEngineerId.setIsPrimaryKey(true);
        fieldEngineerId.setUnique(false);
        fieldEngineerId.setIsIdentity(false);
        fieldEngineerId.setForeignKeyFieldName("CMP3_ENGINEER.ID");
        table.addField(fieldEngineerId);

        FieldDefinition fieldLaptopMFR = new FieldDefinition();
        fieldLaptopMFR.setName("LAPTOP_MFR");
        fieldLaptopMFR.setTypeName("VARCHAR");
        fieldLaptopMFR.setSize(30);
        fieldLaptopMFR.setIsPrimaryKey(true);
        fieldLaptopMFR.setIsIdentity(false);
        fieldLaptopMFR.setUnique(false);
        fieldLaptopMFR.setShouldAllowNull(false);
        table.addField(fieldLaptopMFR);

        FieldDefinition fieldLaptopSNO = new FieldDefinition();
        fieldLaptopSNO.setName("LAPTOP_SNO");
        fieldLaptopSNO.setTypeName("NUMBER");
        fieldLaptopSNO.setSize(10);
        fieldLaptopSNO.setSubSize(0);
        fieldLaptopSNO.setIsPrimaryKey(true);
        fieldLaptopSNO.setIsIdentity(false);
        fieldLaptopSNO.setUnique(false);
        fieldLaptopSNO.setShouldAllowNull(false);
        table.addField(fieldLaptopSNO);

        // FOREIGN KEY (LAPTOP_MFR, LAPTOP_SNO) REFERENCES CMP3_LAPTOP (MFR, SNO)
        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        fkConstraint.setName("CMP3_ENG_LAP_FK1");
        fkConstraint.addSourceField("LAPTOP_MFR");
        fkConstraint.addSourceField("LAPTOP_SNO");
        fkConstraint.setTargetTable("CMP3_LAPTOP");
        fkConstraint.addTargetField("MFR");
        fkConstraint.addTargetField("SNO");

        table.addForeignKeyConstraint(fkConstraint);
        return table;
    }

    public TableDefinition buildWEAPONTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_WEAPON");

        FieldDefinition fieldSERIAL_NUMBER = new FieldDefinition();
        fieldSERIAL_NUMBER.setName("SERIAL_NUMBER");
        fieldSERIAL_NUMBER.setTypeName("NUMBER");
        fieldSERIAL_NUMBER.setSize(10);
        fieldSERIAL_NUMBER.setIsPrimaryKey(true);
        fieldSERIAL_NUMBER.setIsIdentity(false);
        fieldSERIAL_NUMBER.setUnique(false);
        fieldSERIAL_NUMBER.setShouldAllowNull(false);
        table.addField(fieldSERIAL_NUMBER);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR");
        fieldDESCRIP.setSize(50);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        return table;
    }

    public TableDefinition buildDIRECTWEAPONTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_DIR_WEAPON");

        FieldDefinition fieldSERIAL_NUMBER = new FieldDefinition();
        fieldSERIAL_NUMBER.setName("SERIAL_NUMBER");
        fieldSERIAL_NUMBER.setTypeName("NUMBER");
        fieldSERIAL_NUMBER.setSize(10);
        fieldSERIAL_NUMBER.setIsPrimaryKey(true);
        fieldSERIAL_NUMBER.setIsIdentity(false);
        fieldSERIAL_NUMBER.setUnique(false);
        fieldSERIAL_NUMBER.setShouldAllowNull(false);
        table.addField(fieldSERIAL_NUMBER);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR");
        fieldDESCRIP.setSize(50);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        return table;
    }

    public TableDefinition buildINDIRECTWEAPONTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_IND_WEAPON");

        FieldDefinition fieldSERIAL_NUMBER = new FieldDefinition();
        fieldSERIAL_NUMBER.setName("SERIAL_NUMBER");
        fieldSERIAL_NUMBER.setTypeName("NUMBER");
        fieldSERIAL_NUMBER.setSize(10);
        fieldSERIAL_NUMBER.setIsPrimaryKey(true);
        fieldSERIAL_NUMBER.setIsIdentity(false);
        fieldSERIAL_NUMBER.setUnique(false);
        fieldSERIAL_NUMBER.setShouldAllowNull(false);
        table.addField(fieldSERIAL_NUMBER);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR");
        fieldDESCRIP.setSize(50);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        return table;
    }

    public TableDefinition buildGUNTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_GUN");

        FieldDefinition fieldSERIAL_NUMBER = new FieldDefinition();
        fieldSERIAL_NUMBER.setName("SERIAL_NUMBER");
        fieldSERIAL_NUMBER.setTypeName("NUMBER");
        fieldSERIAL_NUMBER.setSize(10);
        fieldSERIAL_NUMBER.setIsPrimaryKey(true);
        fieldSERIAL_NUMBER.setIsIdentity(false);
        fieldSERIAL_NUMBER.setUnique(false);
        fieldSERIAL_NUMBER.setShouldAllowNull(false);
        table.addField(fieldSERIAL_NUMBER);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR");
        fieldDESCRIP.setSize(50);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        FieldDefinition fieldCALIBER = new FieldDefinition();
        fieldCALIBER.setName("CALIBER");
        fieldCALIBER.setTypeName("NUMBER");
        fieldCALIBER.setSize(10);
        fieldCALIBER.setIsPrimaryKey(false);
        fieldCALIBER.setIsIdentity(false);
        fieldCALIBER.setUnique(false);
        fieldCALIBER.setShouldAllowNull(false);
        table.addField(fieldCALIBER);

        FieldDefinition fieldMODEL = new FieldDefinition();
        fieldMODEL.setName("MODEL");
        fieldMODEL.setTypeName("VARCHAR");
        fieldMODEL.setSize(50);
        fieldMODEL.setIsPrimaryKey(false);
        fieldMODEL.setIsIdentity(false);
        fieldMODEL.setUnique(false);
        fieldMODEL.setShouldAllowNull(true);
        table.addField(fieldMODEL);

        return table;
    }

    public TableDefinition buildKNIFETable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_KNIFE");

        FieldDefinition fieldSERIAL_NUMBER = new FieldDefinition();
        fieldSERIAL_NUMBER.setName("SERIAL_NUMBER");
        fieldSERIAL_NUMBER.setTypeName("NUMBER");
        fieldSERIAL_NUMBER.setSize(10);
        fieldSERIAL_NUMBER.setIsPrimaryKey(true);
        fieldSERIAL_NUMBER.setIsIdentity(false);
        fieldSERIAL_NUMBER.setUnique(false);
        fieldSERIAL_NUMBER.setShouldAllowNull(false);
        table.addField(fieldSERIAL_NUMBER);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR");
        fieldDESCRIP.setSize(50);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR");
        fieldNAME.setSize(50);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        FieldDefinition fieldBLADE = new FieldDefinition();
        fieldBLADE.setName("BLADE");
        fieldBLADE.setTypeName("NUMBER");
        fieldBLADE.setSize(10);
        fieldBLADE.setIsPrimaryKey(false);
        fieldBLADE.setIsIdentity(false);
        fieldBLADE.setUnique(false);
        fieldBLADE.setShouldAllowNull(false);
        table.addField(fieldBLADE);

        FieldDefinition fieldKNIFE_TYPE = new FieldDefinition();
        fieldKNIFE_TYPE.setName("KNIFE_TYPE");
        fieldKNIFE_TYPE.setTypeName("VARCHAR");
        fieldKNIFE_TYPE.setSize(50);
        fieldKNIFE_TYPE.setIsPrimaryKey(false);
        fieldKNIFE_TYPE.setIsIdentity(false);
        fieldKNIFE_TYPE.setUnique(false);
        fieldKNIFE_TYPE.setShouldAllowNull(true);
        table.addField(fieldKNIFE_TYPE);

        return table;
    }

    public TableDefinition buildPOISONTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_POISON");

        FieldDefinition fieldSERIAL_NUMBER = new FieldDefinition();
        fieldSERIAL_NUMBER.setName("SERIAL_NUMBER");
        fieldSERIAL_NUMBER.setTypeName("NUMBER");
        fieldSERIAL_NUMBER.setSize(10);
        fieldSERIAL_NUMBER.setIsPrimaryKey(true);
        fieldSERIAL_NUMBER.setIsIdentity(false);
        fieldSERIAL_NUMBER.setUnique(false);
        fieldSERIAL_NUMBER.setShouldAllowNull(false);
        table.addField(fieldSERIAL_NUMBER);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR");
        fieldDESCRIP.setSize(50);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("E_TIME");
        fieldNAME.setTypeName("VARCHAR");
        fieldNAME.setSize(50);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        return table;
    }

    public TableDefinition buildBOMBTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_BOMB");

        FieldDefinition fieldSERIAL_NUMBER = new FieldDefinition();
        fieldSERIAL_NUMBER.setName("SERIAL_NUMBER");
        fieldSERIAL_NUMBER.setTypeName("NUMBER");
        fieldSERIAL_NUMBER.setSize(10);
        fieldSERIAL_NUMBER.setIsPrimaryKey(true);
        fieldSERIAL_NUMBER.setIsIdentity(false);
        fieldSERIAL_NUMBER.setUnique(false);
        fieldSERIAL_NUMBER.setShouldAllowNull(false);
        table.addField(fieldSERIAL_NUMBER);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR");
        fieldDESCRIP.setSize(50);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        FieldDefinition fieldBOMB_TYPE = new FieldDefinition();
        fieldBOMB_TYPE.setName("B_TYPE");
        fieldBOMB_TYPE.setTypeName("NUMBER");
        fieldBOMB_TYPE.setSize(10);
        fieldBOMB_TYPE.setIsPrimaryKey(false);
        fieldBOMB_TYPE.setIsIdentity(false);
        fieldBOMB_TYPE.setUnique(false);
        fieldBOMB_TYPE.setShouldAllowNull(true);
        table.addField(fieldBOMB_TYPE);

        return table;
    }

    public TableDefinition buildELIMINATIONTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_ELIMINATION");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(false);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR");
        fieldNAME.setSize(50);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(false);
        table.addField(fieldNAME);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR");
        fieldDESCRIP.setSize(50);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        FieldDefinition fieldASSASSIN = new FieldDefinition();
        fieldASSASSIN.setName("ASSASSIN_ID");
        fieldASSASSIN.setTypeName("NUMBER");
        fieldASSASSIN.setSize(10);
        fieldASSASSIN.setIsPrimaryKey(false);
        fieldASSASSIN.setIsIdentity(false);
        fieldASSASSIN.setUnique(false);
        fieldASSASSIN.setShouldAllowNull(false);
        table.addField(fieldASSASSIN);

        return table;
    }

    public TableDefinition buildDIRECTELIMINATIONTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_DIR_ELIMINATION");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(false);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR");
        fieldNAME.setSize(50);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(false);
        table.addField(fieldNAME);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR");
        fieldDESCRIP.setSize(50);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        FieldDefinition fieldASSASSIN = new FieldDefinition();
        fieldASSASSIN.setName("ASSASSIN_ID");
        fieldASSASSIN.setTypeName("NUMBER");
        fieldASSASSIN.setSize(10);
        fieldASSASSIN.setIsPrimaryKey(false);
        fieldASSASSIN.setIsIdentity(false);
        fieldASSASSIN.setUnique(false);
        fieldASSASSIN.setShouldAllowNull(false);
        table.addField(fieldASSASSIN);

        FieldDefinition fieldWEAPON = new FieldDefinition();
        fieldWEAPON.setName("WEAPON_ID");
        fieldWEAPON.setTypeName("NUMBER");
        fieldWEAPON.setSize(10);
        fieldWEAPON.setIsPrimaryKey(false);
        fieldWEAPON.setIsIdentity(false);
        fieldWEAPON.setUnique(false);
        fieldWEAPON.setShouldAllowNull(false);
        table.addField(fieldWEAPON);

        return table;
    }

    public TableDefinition buildINDIRECTELIMINATIONTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_IND_ELIMINATION");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(false);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR");
        fieldNAME.setSize(50);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(false);
        table.addField(fieldNAME);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR");
        fieldDESCRIP.setSize(50);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        FieldDefinition fieldASSASSIN = new FieldDefinition();
        fieldASSASSIN.setName("ASSASSIN_ID");
        fieldASSASSIN.setTypeName("NUMBER");
        fieldASSASSIN.setSize(10);
        fieldASSASSIN.setIsPrimaryKey(false);
        fieldASSASSIN.setIsIdentity(false);
        fieldASSASSIN.setUnique(false);
        fieldASSASSIN.setShouldAllowNull(false);
        table.addField(fieldASSASSIN);

        FieldDefinition fieldWEAPON = new FieldDefinition();
        fieldWEAPON.setName("WEAPON_ID");
        fieldWEAPON.setTypeName("NUMBER");
        fieldWEAPON.setSize(10);
        fieldWEAPON.setIsPrimaryKey(false);
        fieldWEAPON.setIsIdentity(false);
        fieldWEAPON.setUnique(false);
        fieldWEAPON.setShouldAllowNull(false);
        table.addField(fieldWEAPON);

        return table;
    }

    public TableDefinition buildCONTRACTEDPERSONELTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_PERSONEL");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR");
        fieldNAME.setSize(50);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("VERSION");
        fieldVERSION.setTypeName("NUMERIC");
        fieldVERSION.setSize(15);
        fieldVERSION.setShouldAllowNull(true);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setIsIdentity(false);
        table.addField(fieldVERSION);

        return table;
    }

    public TableDefinition buildASSASSINTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_ASSASSIN");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR");
        fieldNAME.setSize(50);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        FieldDefinition fieldWEAPON = new FieldDefinition();
        fieldWEAPON.setName("WEAPON_ID");
        fieldWEAPON.setTypeName("NUMBER");
        fieldWEAPON.setSize(10);
        fieldWEAPON.setIsPrimaryKey(false);
        fieldWEAPON.setIsIdentity(false);
        fieldWEAPON.setUnique(false);
        fieldWEAPON.setShouldAllowNull(true);
        table.addField(fieldWEAPON);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("VERSION");
        fieldVERSION.setTypeName("NUMERIC");
        fieldVERSION.setSize(15);
        fieldVERSION.setShouldAllowNull(true);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setIsIdentity(false);
        table.addField(fieldVERSION);

        return table;
    }

    public TableDefinition buildSPECIALASSASSINTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_SPECIAL_ASSASSIN");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR");
        fieldNAME.setSize(50);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        FieldDefinition fieldWEAPON = new FieldDefinition();
        fieldWEAPON.setName("WEAPON_ID");
        fieldWEAPON.setTypeName("NUMBER");
        fieldWEAPON.setSize(10);
        fieldWEAPON.setIsPrimaryKey(false);
        fieldWEAPON.setIsIdentity(false);
        fieldWEAPON.setUnique(false);
        fieldWEAPON.setShouldAllowNull(true);
        table.addField(fieldWEAPON);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("SP_VERSION");
        fieldVERSION.setTypeName("NUMERIC");
        fieldVERSION.setSize(15);
        fieldVERSION.setShouldAllowNull(true);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setIsIdentity(false);
        table.addField(fieldVERSION);

        return table;
    }

    public TableDefinition buildSOCIALCLUBTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_SOCIAL_CLUB");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR");
        fieldNAME.setSize(50);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        return table;
    }

    public TableDefinition buildPERSONELCLUBTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_PERSONEL_CLUB");

        FieldDefinition fieldPERSONELID = new FieldDefinition();
        fieldPERSONELID.setName("PERSONEL_ID");
        fieldPERSONELID.setTypeName("NUMERIC");
        fieldPERSONELID.setSize(10);
        fieldPERSONELID.setShouldAllowNull(false);
        fieldPERSONELID.setIsPrimaryKey(true);
        fieldPERSONELID.setUnique(false);
        fieldPERSONELID.setIsIdentity(false);
        // Can't set foreign key field constraints.
        //fieldPERSONELID.setForeignKeyFieldName("CMP3_PERSONEL.ID");
        table.addField(fieldPERSONELID);

        FieldDefinition fieldCLUBID = new FieldDefinition();
        fieldCLUBID.setName("CLUB_ID");
        fieldCLUBID.setTypeName("NUMERIC");
        fieldCLUBID.setSize(10);
        fieldCLUBID.setShouldAllowNull(false);
        fieldCLUBID.setIsPrimaryKey(true);
        fieldCLUBID.setUnique(false);
        fieldCLUBID.setIsIdentity(false);
        // Can't set foreign key field constraints.
        //fieldCLUBID.setForeignKeyFieldName("CMP3_SOCIAL_CLUB.ID");
        table.addField(fieldCLUBID);

        return table;
    }

    public TableDefinition buildNICKNAMESTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_NICKNAMES");

        FieldDefinition fieldPERSONELID = new FieldDefinition();
        fieldPERSONELID.setName("PERSONEL_ID");
        fieldPERSONELID.setTypeName("NUMERIC");
        fieldPERSONELID.setSize(10);
        fieldPERSONELID.setShouldAllowNull(false);
        fieldPERSONELID.setIsPrimaryKey(true);
        fieldPERSONELID.setUnique(false);
        fieldPERSONELID.setIsIdentity(false);
        // Can't set foreign key field constraints.
        //fieldPERSONELID.setForeignKeyFieldName("CMP3_PERSONEL.ID");
        table.addField(fieldPERSONELID);

        FieldDefinition fieldNICKNAME = new FieldDefinition();
        fieldNICKNAME.setName("NICKNAME");
        fieldNICKNAME.setTypeName("VARCHAR");
        fieldNICKNAME.setSize(50);
        fieldNICKNAME.setShouldAllowNull(false);
        fieldNICKNAME.setIsPrimaryKey(true);
        fieldNICKNAME.setUnique(false);
        fieldNICKNAME.setIsIdentity(false);
        table.addField(fieldNICKNAME);

        return table;
    }

    public TableDefinition buildSMALLASSIGNMENTTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TPC_SMALL_ASSIGNMENT");

        FieldDefinition fieldSMALLID = new FieldDefinition();
        fieldSMALLID.setName("SMALL_ID");
        fieldSMALLID.setTypeName("NUMERIC");
        fieldSMALLID.setSize(10);
        fieldSMALLID.setShouldAllowNull(false);
        fieldSMALLID.setIsPrimaryKey(true);
        fieldSMALLID.setUnique(false);
        fieldSMALLID.setIsIdentity(false);
        table.addField(fieldSMALLID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR");
        fieldNAME.setSize(50);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        return table;
    }

    public TableDefinition buildCMP3_SEEDED_FRUITTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_SEEDED_FRUIT");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR");
        fieldNAME.setSize(255);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        FieldDefinition fieldCLASS_TYPE = new FieldDefinition();
        fieldCLASS_TYPE.setName("CLASS_TYPE");
        fieldCLASS_TYPE.setTypeName("VARCHAR");
        fieldCLASS_TYPE.setSize(1);
        fieldCLASS_TYPE.setIsPrimaryKey(false);
        fieldCLASS_TYPE.setIsIdentity(false);
        fieldCLASS_TYPE.setUnique(false);
        fieldCLASS_TYPE.setShouldAllowNull(true);
        table.addField(fieldCLASS_TYPE);

        return table;
    }

    public TableDefinition buildCMP3_CITRUS_FRUITTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_CITRUS_FRUIT");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        fieldID.setForeignKeyFieldName("CMP3_SEEDED_FRUIT.ID");
        table.addField(fieldID);

        FieldDefinition fieldGRADE = new FieldDefinition();
        fieldGRADE.setName("GRADE");
        fieldGRADE.setTypeName("NUMBER");
        fieldGRADE.setSize(10);
        fieldGRADE.setIsPrimaryKey(false);
        fieldGRADE.setIsIdentity(false);
        fieldGRADE.setUnique(false);
        fieldGRADE.setShouldAllowNull(true);
        table.addField(fieldGRADE);

        return table;
    }

    public TableDefinition buildCMP3_SEEDTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_SEED");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR");
        fieldNAME.setSize(64);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        FieldDefinition fieldSEEDEDFRUIT_ID = new FieldDefinition();
        fieldSEEDEDFRUIT_ID.setName("SEEDEDFRUIT_ID");
        fieldSEEDEDFRUIT_ID.setTypeName("NUMBER");
        fieldSEEDEDFRUIT_ID.setSize(10);
        fieldSEEDEDFRUIT_ID.setIsPrimaryKey(false);
        fieldSEEDEDFRUIT_ID.setIsIdentity(false);
        fieldSEEDEDFRUIT_ID.setUnique(false);
        fieldSEEDEDFRUIT_ID.setShouldAllowNull(true);
        fieldSEEDEDFRUIT_ID.setForeignKeyFieldName("CMP3_SEEDED_FRUIT.ID");
        table.addField(fieldSEEDEDFRUIT_ID);

        return table;
    }

    public TableDefinition buildJPA_FISHTable() {
        TableDefinition table = new TableDefinition();
        table.setName("JPA_FISH");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR");
        fieldNAME.setSize(64);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        FieldDefinition fieldTYPE = new FieldDefinition();
        fieldTYPE.setName("TYPE");
        fieldTYPE.setTypeName("VARCHAR");
        fieldTYPE.setSize(1);
        fieldTYPE.setIsPrimaryKey(false);
        fieldTYPE.setIsIdentity(false);
        fieldTYPE.setUnique(false);
        fieldTYPE.setShouldAllowNull(true);
        table.addField(fieldTYPE);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("VERSION");
        fieldVERSION.setTypeName("NUMBER");
        fieldVERSION.setSize(10);
        fieldVERSION.setShouldAllowNull(true);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setIsIdentity(false);
        table.addField(fieldVERSION);

        FieldDefinition fieldTANK_ID = new FieldDefinition();
        fieldTANK_ID.setName("TANK_ID");
        fieldTANK_ID.setTypeName("NUMBER");
        fieldTANK_ID.setSize(10);
        fieldTANK_ID.setShouldAllowNull(true);
        fieldTANK_ID.setIsPrimaryKey(false);
        fieldTANK_ID.setUnique(false);
        fieldTANK_ID.setIsIdentity(false);
        table.addField(fieldTANK_ID);

        return table;
    }

    public TableDefinition buildJPA_FISH_TANKTable() {
        TableDefinition table = new TableDefinition();
        table.setName("JPA_FISH_TANK");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("VERSION");
        fieldVERSION.setTypeName("NUMBER");
        fieldVERSION.setSize(10);
        fieldVERSION.setShouldAllowNull(true);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setIsIdentity(false);
        table.addField(fieldVERSION);

        FieldDefinition fieldSTOREID = new FieldDefinition();
        fieldSTOREID.setName("STORE_ID");
        fieldSTOREID.setTypeName("NUMBER");
        fieldSTOREID.setSize(10);
        fieldSTOREID.setIsPrimaryKey(false);
        fieldSTOREID.setIsIdentity(false);
        fieldSTOREID.setUnique(false);
        fieldSTOREID.setShouldAllowNull(true);
        table.addField(fieldSTOREID);

        return table;
    }

    public TableDefinition buildJPA_BETTATable() {
        TableDefinition table = new TableDefinition();
        table.setName("JPA_BETTA");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldCOLOR = new FieldDefinition();
        fieldCOLOR.setName("COLOR");
        fieldCOLOR.setTypeName("VARCHAR");
        fieldCOLOR.setSize(64);
        fieldCOLOR.setIsPrimaryKey(false);
        fieldCOLOR.setIsIdentity(false);
        fieldCOLOR.setUnique(false);
        fieldCOLOR.setShouldAllowNull(true);
        table.addField(fieldCOLOR);

        return table;
    }

    public TableDefinition buildJPA_PET_STORETable() {
        TableDefinition table = new TableDefinition();
        table.setName("JPA_PET_STORE");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("VERSION");
        fieldVERSION.setTypeName("NUMBER");
        fieldVERSION.setSize(10);
        fieldVERSION.setShouldAllowNull(true);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setIsIdentity(false);
        table.addField(fieldVERSION);

        FieldDefinition fieldSTORENAME = new FieldDefinition();
        fieldSTORENAME.setName("STORE_NAME");
        fieldSTORENAME.setTypeName("VARCHAR");
        fieldSTORENAME.setSize(64);
        fieldSTORENAME.setIsPrimaryKey(false);
        fieldSTORENAME.setIsIdentity(false);
        fieldSTORENAME.setUnique(false);
        fieldSTORENAME.setShouldAllowNull(true);
        table.addField(fieldSTORENAME);

        return table;
    }

    /**
     * Dropping old foreign keys from schema change.
     */
    public void replaceTables(DatabaseSession session) {
        try {
            if (session.getPlatform().supportsUniqueKeyConstraints()
                    && !session.getPlatform().requiresUniqueConstraintCreationOnTableCreate()) {
                if (!session.getPlatform().isMySQL()) {
                    session.executeNonSelectingSQL("Alter table CMP3_ENGINEER_LAPTOP drop constraint CMP3_ENGINEER_LAPTOP_FK1");
                }
            }
        } catch (Exception ignore) {}
        super.replaceTables(session);
    }
}
