/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.sequencing.SequencingServer;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.ExclusiveIsolatedClientSession;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ExternalConnectionPool;
import org.eclipse.persistence.sessions.server.ReadConnectionPool;
import org.eclipse.persistence.sessions.server.Server;

public class ServerSession
extends DatabaseSessionImpl
implements Server {
    protected ConnectionPool readConnectionPool;
    protected Map<String, ConnectionPool> connectionPools = new HashMap<String, ConnectionPool>(10);
    protected ConnectionPolicy defaultConnectionPolicy;
    protected int numberOfNonPooledConnectionsUsed;
    protected int maxNumberOfNonPooledConnections;
    public static final int NO_MAX = -1;
    public static final String DEFAULT_POOL = "default";
    public static final String NOT_POOLED = "not-pooled";

    public ServerSession() {
    }

    public ServerSession(Login login) {
        this(new Project(login));
    }

    public ServerSession(Login login, int minNumberOfPooledConnection, int maxNumberOfPooledConnection) {
        this(new Project(login), minNumberOfPooledConnection, maxNumberOfPooledConnection);
    }

    public ServerSession(Login login, ConnectionPolicy defaultConnectionPolicy) {
        this(new Project(login), defaultConnectionPolicy);
    }

    public ServerSession(Project project) {
        this(project, 32, 32);
    }

    public ServerSession(Project project, int minNumberOfPooledConnection, int maxNumberOfPooledConnection) {
        this(project, 1, minNumberOfPooledConnection, maxNumberOfPooledConnection);
    }

    public ServerSession(Project project, int initialNumberOfPooledConnection, int minNumberOfPooledConnection, int maxNumberOfPooledConnection) {
        this(project, new ConnectionPolicy(DEFAULT_POOL), initialNumberOfPooledConnection, minNumberOfPooledConnection, maxNumberOfPooledConnection, null, null);
    }

    public ServerSession(Project project, int minNumberOfPooledConnection, int maxNumberOfPooledConnection, Login readLogin) {
        this(project, minNumberOfPooledConnection, maxNumberOfPooledConnection, readLogin, null);
    }

    public ServerSession(Project project, int minNumberOfPooledConnection, int maxNumberOfPooledConnection, Login readLogin, Login sequenceLogin) {
        this(project, new ConnectionPolicy(DEFAULT_POOL), 1, minNumberOfPooledConnection, maxNumberOfPooledConnection, readLogin, sequenceLogin);
    }

    public ServerSession(Project project, ConnectionPolicy defaultConnectionPolicy, int initialNumberOfPooledConnections, int minNumberOfPooledConnections, int maxNumberOfPooledConnections, Login readLogin, Login sequenceLogin) {
        super(project);
        this.defaultConnectionPolicy = defaultConnectionPolicy;
        this.maxNumberOfNonPooledConnections = 50;
        this.numberOfNonPooledConnectionsUsed = 0;
        ConnectionPool pool = null;
        pool = project.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(DEFAULT_POOL, project.getDatasourceLogin(), this) : new ConnectionPool(DEFAULT_POOL, project.getDatasourceLogin(), initialNumberOfPooledConnections, minNumberOfPooledConnections, maxNumberOfPooledConnections, this);
        this.connectionPools.put(DEFAULT_POOL, pool);
        if (readLogin != null) {
            this.setReadConnectionPool(readLogin);
        } else {
            this.setReadConnectionPool(pool);
        }
        if (sequenceLogin != null) {
            this.getSequencingControl().setShouldUseSeparateConnection(true);
            this.getSequencingControl().setLogin(sequenceLogin);
        }
    }

    public ServerSession(Project project, ConnectionPolicy defaultConnectionPolicy) {
        this(project, defaultConnectionPolicy, null);
    }

    public ServerSession(Project project, ConnectionPolicy defaultConnectionPolicy, Login readLogin) {
        this(project, defaultConnectionPolicy, readLogin, null);
    }

    public ServerSession(Project project, ConnectionPolicy defaultConnectionPolicy, Login readLogin, Login sequenceLogin) {
        this(project, defaultConnectionPolicy, 1, 32, 32, readLogin, sequenceLogin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireClientConnection(ClientSession clientSession) throws DatabaseException, ConcurrencyException {
        if (clientSession.getConnectionPolicy().isPooled()) {
            ConnectionPool pool = this.connectionPools.get(clientSession.getConnectionPolicy().getPoolName());
            Accessor accessor = pool.acquireConnection();
            clientSession.addWriteConnection(pool.getName(), accessor);
        } else {
            if (this.maxNumberOfNonPooledConnections != -1) {
                ServerSession pool = this;
                synchronized (pool) {
                    while (this.numberOfNonPooledConnectionsUsed >= this.maxNumberOfNonPooledConnections) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException exception) {
                            throw ConcurrencyException.waitFailureOnServerSession(exception);
                        }
                    }
                    ++this.numberOfNonPooledConnectionsUsed;
                }
            }
            try {
                Accessor accessor = clientSession.getLogin().buildAccessor();
                clientSession.connect(accessor);
                clientSession.addWriteConnection(NOT_POOLED, accessor);
            }
            catch (DatabaseException dbe) {
                if (this.maxNumberOfNonPooledConnections != -1) {
                    ServerSession serverSession = this;
                    synchronized (serverSession) {
                        --this.numberOfNonPooledConnectionsUsed;
                        this.notify();
                    }
                }
                throw dbe;
            }
        }
    }

    @Override
    public ClientSession acquireClientSession() throws DatabaseException {
        return this.acquireClientSession(this.getDefaultConnectionPolicy());
    }

    public ClientSession acquireClientSession(Map properties) throws DatabaseException {
        return this.acquireClientSession(this.getDefaultConnectionPolicy(), properties);
    }

    @Override
    public ClientSession acquireClientSession(String poolName) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(poolName));
    }

    public ClientSession acquireClientSession(String poolName, Map properties) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(poolName), properties);
    }

    @Override
    public ClientSession acquireClientSession(Login login) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(login));
    }

    public ClientSession acquireClientSession(Login login, Map properties) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(login), properties);
    }

    @Override
    public ClientSession acquireClientSession(ConnectionPolicy connectionPolicy) throws DatabaseException, ValidationException {
        return this.acquireClientSession(connectionPolicy, null);
    }

    public ClientSession acquireClientSession(ConnectionPolicy connectionPolicy, Map properties) throws DatabaseException, ValidationException {
        if (!this.isConnected()) {
            throw ValidationException.loginBeforeAllocatingClientSessions();
        }
        if (!connectionPolicy.isPooled() && connectionPolicy.getLogin() == null) {
            connectionPolicy.setPoolName(this.getDefaultConnectionPolicy().getPoolName());
            connectionPolicy.setLogin(this.getDefaultConnectionPolicy().getLogin());
        }
        if (connectionPolicy.isPooled()) {
            ConnectionPool pool = this.connectionPools.get(connectionPolicy.getPoolName());
            if (pool == null) {
                throw ValidationException.poolNameDoesNotExist(connectionPolicy.getPoolName());
            }
            connectionPolicy.setLogin(pool.getLogin());
        }
        ClientSession client = null;
        if (this.getProject().hasIsolatedClasses()) {
            client = connectionPolicy.isExclusive() ? new ExclusiveIsolatedClientSession(this, connectionPolicy, properties) : new IsolatedClientSession(this, connectionPolicy, properties);
        } else {
            if (connectionPolicy.isExclusiveIsolated()) {
                throw ValidationException.clientSessionCanNotUseExclusiveConnection();
            }
            client = connectionPolicy.isExclusiveAlways() ? new ExclusiveIsolatedClientSession(this, connectionPolicy, properties) : new ClientSession(this, connectionPolicy, properties);
        }
        if (this.isFinalizersEnabled()) {
            client.registerFinalizer();
        }
        if (!connectionPolicy.isLazy()) {
            this.acquireClientConnection(client);
        }
        if (this.shouldLog(2, "connection")) {
            this.log(2, "connection", "client_acquired", String.valueOf(System.identityHashCode(client)));
        }
        return client;
    }

    @Override
    public Session acquireHistoricalSession(AsOfClause clause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork() {
        return this.acquireClientSession().acquireUnitOfWork();
    }

    @Override
    public void addConnectionPool(String poolName, Login login, int minNumberOfConnections, int maxNumberOfConnections) throws ValidationException {
        if (minNumberOfConnections > maxNumberOfConnections) {
            throw ValidationException.maxSizeLessThanMinSize();
        }
        if (this.isConnected()) {
            throw ValidationException.poolsMustBeConfiguredBeforeLogin();
        }
        ConnectionPool pool = null;
        pool = login.shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(poolName, login, this) : new ConnectionPool(poolName, login, minNumberOfConnections, maxNumberOfConnections, this);
        this.addConnectionPool(pool);
    }

    @Override
    public void addConnectionPool(ConnectionPool pool) {
        pool.setOwner(this);
        this.getConnectionPools().put(pool.getName(), pool);
    }

    public Accessor allocateReadConnection() {
        Accessor connection = this.readConnectionPool.acquireConnection();
        if (!connection.usesExternalConnectionPooling() && this.eventManager != null) {
            this.eventManager.postAcquireConnection(connection);
        }
        return connection;
    }

    @Override
    public void connect() {
        this.updateStandardConnectionPools();
        this.readConnectionPool.startUp();
        this.setAccessor(this.allocateReadConnection());
        this.releaseReadConnection(this.getAccessor());
        for (ConnectionPool pool : this.getConnectionPools().values()) {
            pool.startUp();
        }
    }

    @Override
    public void disconnect() throws DatabaseException {
        try {
            super.disconnect();
        }
        catch (DatabaseException databaseException) {}
    }

    public List<Accessor> getAccessors(Call call, AbstractRecord translationRow, DatabaseQuery query) {
        List<Accessor> accessors = null;
        if (query.getPartitioningPolicy() != null && (accessors = query.getPartitioningPolicy().getConnectionsForQuery(this, query, translationRow)) != null) {
            return accessors;
        }
        if (query.getDescriptor() != null && query.getDescriptor().getPartitioningPolicy() != null && (accessors = query.getDescriptor().getPartitioningPolicy().getConnectionsForQuery(this, query, translationRow)) != null) {
            return accessors;
        }
        if (this.partitioningPolicy != null && (accessors = this.partitioningPolicy.getConnectionsForQuery(this, query, translationRow)) != null) {
            return accessors;
        }
        accessors = new ArrayList<Accessor>(1);
        accessors.add(this.readConnectionPool.acquireConnection());
        return accessors;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        exception = null;
        result = null;
        accessorAllocated = false;
        if (query.getAccessors() == null) {
            accessors = this.getAccessors(call, translationRow, query);
            query.setAccessors(accessors);
            if (this.eventManager != null) {
                for (Accessor accessor : accessors) {
                    if (accessor.usesExternalConnectionPooling()) continue;
                    this.eventManager.postAcquireConnection(accessor);
                }
            }
            accessorAllocated = true;
        }
        try {
            try {
                result = this.basicExecuteCall(call, translationRow, query);
            }
            catch (RuntimeException caughtException) {
                exception = caughtException;
                if (call.isFinished() || exception != null) {
                    if (accessorAllocated) {
                        try {
                            this.releaseConnectionAfterCall(query);
                        }
                        catch (RuntimeException releaseException) {
                            if (exception != null) ** GOTO lbl30
                            throw releaseException;
                        }
                    }
                } else if (query.isObjectLevelReadQuery()) {
                    ((DatabaseCall)call).setHasAllocatedConnection(accessorAllocated);
                }
lbl30:
                // 6 sources

                if (exception != null) {
                    throw exception;
                }
            }
        }
        finally {
            if (call.isFinished() || exception != null) {
                if (accessorAllocated) {
                    try {
                        this.releaseConnectionAfterCall(query);
                    }
                    catch (RuntimeException releaseException) {
                        if (exception != null) ** GOTO lbl45
                        throw releaseException;
                    }
                }
            } else if (query.isObjectLevelReadQuery()) {
                ((DatabaseCall)call).setHasAllocatedConnection(accessorAllocated);
            }
lbl45:
            // 6 sources

            if (exception != null) {
                throw exception;
            }
        }
        return result;
    }

    @Override
    public void releaseConnectionAfterCall(DatabaseQuery query) {
        RuntimeException exception = null;
        for (Accessor accessor : query.getAccessors()) {
            try {
                if (!accessor.usesExternalConnectionPooling()) {
                    this.preReleaseConnection(accessor);
                }
                accessor.getPool().releaseConnection(accessor);
            }
            catch (RuntimeException ex) {
                if (exception != null) continue;
                exception = ex;
            }
        }
        query.setAccessors(null);
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public Object executeQuery(DatabaseQuery query, List argumentValues) throws DatabaseException {
        if (query == null) {
            throw QueryException.queryNotDefined();
        }
        query.checkDescriptor(this);
        ClassDescriptor descriptor = query.getDescriptor();
        AbstractRecord row = query.rowFromArguments(argumentValues, this);
        if (query.isObjectBuildingQuery() && descriptor != null && !descriptor.getCachePolicy().isSharedIsolation()) {
            ClientSession client = this.acquireClientSession();
            Object result = null;
            try {
                result = client.executeQuery(query, row);
            }
            finally {
                client.release();
            }
            return result;
        }
        return super.executeQuery(query, row);
    }

    @Override
    public ConnectionPool getConnectionPool(String poolName) {
        return this.connectionPools.get(poolName);
    }

    public Map<String, ConnectionPool> getConnectionPools() {
        return this.connectionPools;
    }

    @Override
    public ConnectionPolicy getDefaultConnectionPolicy() {
        if (this.defaultConnectionPolicy == null) {
            this.defaultConnectionPolicy = new ConnectionPolicy(DEFAULT_POOL);
        }
        return this.defaultConnectionPolicy;
    }

    @Override
    public ConnectionPool getDefaultConnectionPool() {
        return this.getConnectionPool(DEFAULT_POOL);
    }

    @Override
    public AbstractSession getExecutionSession(DatabaseQuery query) {
        if (query.isObjectLevelModifyQuery()) {
            throw QueryException.invalidQueryOnServerSession(query);
        }
        return this;
    }

    @Override
    public int getMaxNumberOfNonPooledConnections() {
        return this.maxNumberOfNonPooledConnections;
    }

    public int getNumberOfNonPooledConnectionsUsed() {
        return this.numberOfNonPooledConnectionsUsed;
    }

    @Override
    protected Login getReadLogin() {
        return this.readConnectionPool.getLogin();
    }

    @Override
    public ConnectionPool getReadConnectionPool() {
        return this.readConnectionPool;
    }

    @Override
    public boolean isConnected() {
        if (this.readConnectionPool == null) {
            return false;
        }
        return this.readConnectionPool.isConnected();
    }

    @Override
    public boolean isServerSession() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void logout() {
        try {
            super.logout();
        }
        finally {
            this.readConnectionPool.shutDown();
            poolsEnum = this.getConnectionPools().values().iterator();
            ** while (poolsEnum.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            poolsEnum.next().shutDown();
            continue;
        }
lbl10:
        // 1 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInvalidClientSession(ClientSession clientSession) throws DatabaseException {
        Iterator<Accessor> accessors = clientSession.getWriteConnections().values().iterator();
        while (accessors.hasNext()) {
            Accessor accessor = accessors.next();
            if (accessor.isValid()) continue;
            if (clientSession.getConnectionPolicy().isPooled()) {
                try {
                    accessor.getPool().releaseConnection(accessor);
                }
                catch (Exception exception) {}
            } else {
                ServerSession serverSession;
                try {
                    if (!accessor.usesExternalConnectionPooling()) {
                        clientSession.disconnect(accessor);
                    } else {
                        accessor.closeConnection();
                    }
                }
                catch (Throwable throwable) {
                    if (this.maxNumberOfNonPooledConnections != -1) {
                        serverSession = this;
                        synchronized (serverSession) {
                            --this.numberOfNonPooledConnectionsUsed;
                            this.notify();
                        }
                    }
                    throw throwable;
                }
                if (this.maxNumberOfNonPooledConnections != -1) {
                    serverSession = this;
                    synchronized (serverSession) {
                        --this.numberOfNonPooledConnectionsUsed;
                        this.notify();
                    }
                }
            }
            accessors.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseClientSession(ClientSession clientSession) throws DatabaseException {
        if (clientSession.getConnectionPolicy().isPooled()) {
            for (Accessor accessor : clientSession.getWriteConnections().values()) {
                if (!accessor.usesExternalConnectionPooling()) {
                    clientSession.preReleaseConnection(accessor);
                }
                accessor.getPool().releaseConnection(accessor);
            }
            clientSession.setWriteConnections(null);
        } else {
            for (Accessor accessor : clientSession.getWriteConnections().values()) {
                if (!accessor.usesExternalConnectionPooling()) {
                    clientSession.preReleaseConnection(accessor);
                    try {
                        clientSession.disconnect(accessor);
                    }
                    catch (DatabaseException databaseException) {}
                    continue;
                }
                accessor.closeConnection();
            }
            clientSession.setWriteConnections(null);
            if (this.maxNumberOfNonPooledConnections != -1) {
                ServerSession serverSession = this;
                synchronized (serverSession) {
                    --this.numberOfNonPooledConnectionsUsed;
                    this.notify();
                }
            }
        }
    }

    @Override
    public void releaseReadConnection(Accessor connection) {
        if (!connection.usesExternalConnectionPooling() && this.eventManager != null) {
            this.eventManager.preReleaseConnection(connection);
        }
        this.readConnectionPool.releaseConnection(connection);
    }

    public void setConnectionPools(Map<String, ConnectionPool> connectionPools) {
        this.connectionPools = connectionPools;
    }

    @Override
    public void setDefaultConnectionPolicy(ConnectionPolicy defaultConnectionPolicy) {
        this.defaultConnectionPolicy = defaultConnectionPolicy;
    }

    public void setDefaultConnectionPool() {
        this.addConnectionPool(DEFAULT_POOL, this.getDatasourceLogin(), 32, 32);
    }

    @Override
    public void setMaxNumberOfNonPooledConnections(int maxNumberOfNonPooledConnections) {
        this.maxNumberOfNonPooledConnections = maxNumberOfNonPooledConnections;
    }

    public void setNumberOfNonPooledConnectionsUsed(int numberOfNonPooledConnectionsUsed) {
        this.numberOfNonPooledConnectionsUsed = numberOfNonPooledConnectionsUsed;
    }

    @Override
    public void setReadConnectionPool(ConnectionPool readConnectionPool) {
        if (this.isConnected()) {
            throw ValidationException.cannotSetReadPoolSizeAfterLogin();
        }
        this.readConnectionPool = readConnectionPool;
        this.readConnectionPool.setOwner(this);
    }

    public void setReadConnectionPool(Login readLogin) throws ValidationException {
        if (this.isConnected()) {
            throw ValidationException.poolsMustBeConfiguredBeforeLogin();
        }
        ConnectionPool pool = null;
        pool = readLogin.shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("read", readLogin, this) : new ConnectionPool("read", readLogin, this);
        this.readConnectionPool = pool;
    }

    @Override
    public void setSynchronized(boolean synched) {
    }

    protected void updateStandardConnectionPools() {
        if (this.getDefaultConnectionPool() != null && this.getDefaultConnectionPool().isThereConflictBetweenLoginAndType()) {
            this.setDefaultConnectionPool();
        }
        if (this.readConnectionPool != null && this.readConnectionPool.isThereConflictBetweenLoginAndType()) {
            this.setReadConnectionPool(this.readConnectionPool.getLogin());
        }
    }

    @Override
    public void useExclusiveReadConnectionPool(int minNumerOfConnections, int maxNumerOfConnections) {
        this.setReadConnectionPool(new ConnectionPool("read", this.getDatasourceLogin(), minNumerOfConnections, maxNumerOfConnections, this));
    }

    @Override
    public void useExclusiveReadConnectionPool(int initialNumberOfConnections, int minNumerOfConnections, int maxNumerOfConnections) {
        this.setReadConnectionPool(new ConnectionPool("read", this.getDatasourceLogin(), initialNumberOfConnections, minNumerOfConnections, maxNumerOfConnections, this));
    }

    @Override
    public void useExternalReadConnectionPool() {
        this.setReadConnectionPool(new ExternalConnectionPool("read", this.getDatasourceLogin(), this));
    }

    @Override
    public void useReadConnectionPool(int minNumerOfConnections, int maxNumerOfConnections) {
        this.setReadConnectionPool(new ReadConnectionPool("read", this.getDatasourceLogin(), minNumerOfConnections, maxNumerOfConnections, this));
    }

    @Override
    public void useReadConnectionPool(int initialNumerOfConnections, int minNumerOfConnections, int maxNumerOfConnections) {
        this.setReadConnectionPool(new ReadConnectionPool("read", this.getDatasourceLogin(), initialNumerOfConnections, minNumerOfConnections, maxNumerOfConnections, this));
    }

    @Override
    public void validateQuery(DatabaseQuery query) {
        if (query.isObjectLevelReadQuery() && (query.getDescriptor().getCachePolicy().isIsolated() || ((ObjectLevelReadQuery)query).shouldUseExclusiveConnection())) {
            throw QueryException.isolatedQueryExecutedOnServerSession();
        }
    }

    public SequencingServer getSequencingServer() {
        return this.getSequencingHome().getSequencingServer();
    }
}

