/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.helper;

import java.math.BigDecimal;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class CheckCompareBigDecimalsTest
extends AutoVerifyTestCase {
    Exception e;
    BigDecimal bd1;
    BigDecimal bd2;
    BigDecimal bd3;
    boolean test1ResultIsTrue;
    boolean test2ResultIsTrue;
    boolean test3ResultIsTrue;
    boolean test4ResultIsTrue;

    public CheckCompareBigDecimalsTest() {
        this.setDescription("Test of Helper.compareBigDecimals(java.math.BigDecimal one, java.math.BigDecimal two) when neither of BigDecimals is positive or negative infinity.");
    }

    public void reset() {
        this.bd1 = null;
        this.bd2 = null;
        this.bd3 = null;
    }

    public void setup() {
        this.bd1 = new BigDecimal(1);
        this.bd1.setScale(1);
        this.bd2 = new BigDecimal(-2);
        this.bd2.setScale(2);
        this.bd3 = new BigDecimal(1);
        this.bd3.setScale(3);
    }

    public void test() {
        try {
            this.test1ResultIsTrue = Helper.compareBigDecimals((BigDecimal)this.bd1, (BigDecimal)this.bd2);
            this.test2ResultIsTrue = Helper.compareBigDecimals((BigDecimal)this.bd1, (BigDecimal)this.bd3);
        }
        catch (Exception e) {
            this.e = e;
            throw new TestErrorException("An exception should not have been thrown when comparing BigDecimal objects - when neither of the arguments is negative or positive infinity.");
        }
    }

    public void verify() {
        if (this.test1ResultIsTrue) {
            throw new TestErrorException("Helper.compareBigDecimals(java.math.BigDecimal one, java.math.BigDecimal two) - with two non-infinity but different argurments - returns incorrectly.");
        }
        if (!this.test2ResultIsTrue) {
            throw new TestErrorException("Helper.compareBigDecimals(java.math.BigDecimal one, java.math.BigDecimal two) - with two non-infinity but identical argurments - returns incorrectly.");
        }
        if (this.e != null) {
            throw new TestErrorException("An exception should not have been thrown when comparing BigDecimal objects - when neither of the arguments is negative or positive infinity: " + this.e.toString());
        }
    }
}

