/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class BinaryOperatorTest
extends JPQLTestCase {
    public static BinaryOperatorTest getSimpleGreaterThanTest() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Greater Than test");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.id > 12");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("id").greaterThan(12);
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimpleGreaterThanEqualTest() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Greater Than Equal test");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.id >= 12");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("id").greaterThanEqual(12);
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimpleLessThanEqualTest() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Less Than Equal test");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.id <= 1000000");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("id").lessThanEqual(1000000);
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimpleLessThanTest() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Less Than test");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.id < 1000000");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("id").lessThan(1000000);
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimplePlusTest() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Plus test");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.salary + 1000 <= 50000");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.add((Expression)builder.get("salary"), (Object)new Integer(1000)).lessThanEqual(50000);
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimplePlusTestWithBracketsBeforeComparison() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Plus test with brackets before comparison");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE (emp.salary + 1000) <= 50000");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.add((Expression)builder.get("salary"), (Object)new Integer(1000)).lessThanEqual(50000);
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimplePlusTestWithBracketsAfterComparison() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Plus test with brackets after comparison");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE 50000 > (emp.salary + 1000)");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionBuilder.fromConstant((Object)new Integer(50000), (Expression)builder).greaterThan(ExpressionMath.add((Expression)builder.get("salary"), (Object)new Integer(1000)));
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimpleMinusTest() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Minus test");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.salary - 1000 <= 50000");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.subtract((Expression)builder.get("salary"), (Object)new Integer(1000)).lessThanEqual(50000);
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimpleMinusTestWithBracketsBeforeComparison() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Minus test with Brackets Before Comparison");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE (emp.salary - 1000) <= 50000");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.subtract((Expression)builder.get("salary"), (Object)new Integer(1000)).lessThanEqual(50000);
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimpleMinusTestWithBracketsAfterComparison() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Minus test with Brackets After Comparison");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE 50000 > (emp.salary - 1000)");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionBuilder.fromConstant((Object)new Integer(50000), (Expression)builder).greaterThan(ExpressionMath.subtract((Expression)builder.get("salary"), (Object)new Integer(1000)));
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimpleMultiplyTest() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Multiply test");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.salary * 2 <= 100000");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.multiply((Expression)builder.get("salary"), (Object)new Integer(2)).lessThanEqual(100000);
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimpleMultiplyTestWithBracketsBeforeComparison() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Multiply test with brackets before comparison");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE (emp.salary * 2) <= 100000");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.multiply((Expression)builder.get("salary"), (Object)new Integer(2)).lessThanEqual(100000);
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimpleMultiplyTestWithBracketsAfterComparison() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Multiply test with brackets after comparison");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE 100000 > (emp.salary * 2)");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionBuilder.fromConstant((Object)new Integer(100000), (Expression)builder).greaterThan(ExpressionMath.multiply((Expression)builder.get("salary"), (Object)new Integer(2)));
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimpleDivideTest() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Divide test");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.salary / 2 <= 20000");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.divide((Expression)builder.get("salary"), (Object)new Integer(2)).lessThanEqual(20000);
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimpleDivideTestWithBracketsBeforeComparison() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Divide test with brackets before comparison");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE (emp.salary / 2) <= 20000");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.divide((Expression)builder.get("salary"), (Object)new Integer(2)).lessThanEqual(20000);
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static BinaryOperatorTest getSimpleDivideTestWithBracketsAfterComparison() {
        BinaryOperatorTest theTest = new BinaryOperatorTest();
        theTest.setName("Simple Divide test with brackets after comparison");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp WHERE 20000 > (emp.salary / 2)");
        theTest.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionBuilder.fromConstant((Object)new Integer(20000), (Expression)builder).greaterThan(ExpressionMath.divide((Expression)builder.get("salary"), (Object)new Integer(2)));
        theTest.setOriginalObjectExpression(whereClause);
        return theTest;
    }

    public static TestSuite getSimpleBinaryOperatorTests() {
        TestSuite theSuite = new TestSuite();
        theSuite.setName("Simple Binary Operator Test Suite");
        theSuite.addTest((Test)BinaryOperatorTest.getSimpleGreaterThanTest());
        theSuite.addTest((Test)BinaryOperatorTest.getSimpleGreaterThanEqualTest());
        theSuite.addTest((Test)BinaryOperatorTest.getSimpleLessThanEqualTest());
        theSuite.addTest((Test)BinaryOperatorTest.getSimpleLessThanTest());
        theSuite.addTest((Test)BinaryOperatorTest.getSimplePlusTest());
        theSuite.addTest((Test)BinaryOperatorTest.getSimplePlusTestWithBracketsBeforeComparison());
        theSuite.addTest((Test)BinaryOperatorTest.getSimplePlusTestWithBracketsAfterComparison());
        theSuite.addTest((Test)BinaryOperatorTest.getSimpleMinusTest());
        theSuite.addTest((Test)BinaryOperatorTest.getSimpleMinusTestWithBracketsBeforeComparison());
        theSuite.addTest((Test)BinaryOperatorTest.getSimpleMinusTestWithBracketsAfterComparison());
        theSuite.addTest((Test)BinaryOperatorTest.getSimpleMultiplyTest());
        theSuite.addTest((Test)BinaryOperatorTest.getSimpleMultiplyTestWithBracketsBeforeComparison());
        theSuite.addTest((Test)BinaryOperatorTest.getSimpleMultiplyTestWithBracketsAfterComparison());
        theSuite.addTest((Test)BinaryOperatorTest.getSimpleDivideTest());
        theSuite.addTest((Test)BinaryOperatorTest.getSimpleDivideTestWithBracketsBeforeComparison());
        theSuite.addTest((Test)BinaryOperatorTest.getSimpleDivideTestWithBracketsAfterComparison());
        return theSuite;
    }

    @Override
    public void setup() {
        ReadAllQuery raq = new ReadAllQuery();
        raq.setSelectionCriteria(this.getOriginalObjectExpression());
        raq.setReferenceClass(this.getReferenceClass());
        this.setOriginalOject(this.getSession().executeQuery((DatabaseQuery)raq));
        super.setup();
    }
}

