/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.mapping.Address;
import org.eclipse.persistence.testing.models.mapping.Computer;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.models.mapping.Employee1;
import org.eclipse.persistence.testing.models.mapping.Employee2;
import org.eclipse.persistence.testing.models.mapping.MappingSystem;
import org.eclipse.persistence.testing.models.mapping.Shipment;
import org.eclipse.persistence.testing.tests.mapping.AddObjectNonPrimaryKeyManyToManyTest;
import org.eclipse.persistence.testing.tests.mapping.AdditionalJoinExpressionTest;
import org.eclipse.persistence.testing.tests.mapping.BidirectionalUOWInsertAndDeleteTest;
import org.eclipse.persistence.testing.tests.mapping.BidirectionalUOWInsertTest;
import org.eclipse.persistence.testing.tests.mapping.ConstraintOrderTest;
import org.eclipse.persistence.testing.tests.mapping.DirectCollectionMappingDeleteNullValueTest;
import org.eclipse.persistence.testing.tests.mapping.LoopingJoinedAttributeTest;
import org.eclipse.persistence.testing.tests.mapping.MTMPrivateOwnedWithValueholderDeleteObjectTest;
import org.eclipse.persistence.testing.tests.mapping.MultipleTableDeleteObjectTest;
import org.eclipse.persistence.testing.tests.mapping.MultipleTableInsertObjectTest;
import org.eclipse.persistence.testing.tests.mapping.MultipleTableReadAllTest;
import org.eclipse.persistence.testing.tests.mapping.MultipleTableReadObjectTest;
import org.eclipse.persistence.testing.tests.mapping.MultipleTableWriteObjectTest;
import org.eclipse.persistence.testing.tests.mapping.ObjectTypeMappingBooleanToCharTest;
import org.eclipse.persistence.testing.tests.mapping.ObjectTypeMappingDefaultNullValues;
import org.eclipse.persistence.testing.tests.mapping.OneToOnePKTest;
import org.eclipse.persistence.testing.tests.mapping.PrivateMMTest;
import org.eclipse.persistence.testing.tests.mapping.Public1MTest;
import org.eclipse.persistence.testing.tests.mapping.SameNamePKTest;
import org.eclipse.persistence.testing.tests.mapping.SelectionCriteriaInOneToManyTest;
import org.eclipse.persistence.testing.tests.mapping.SelectionCriteriaInOneToOneTest;
import org.eclipse.persistence.testing.tests.mapping.SelectionCriteriaInTargetOneToOneTest;
import org.eclipse.persistence.testing.tests.mapping.TwoLevelJoinedAttributeTest;
import org.eclipse.persistence.testing.tests.mapping.TwoParametersTransformationMappingTest;
import org.eclipse.persistence.testing.tests.mapping.UnitOfWorkCommitResumeTest;
import org.eclipse.persistence.testing.tests.mapping.UnitOfWorkTest;
import org.eclipse.persistence.testing.tests.mapping.conversion.AttributeNamePrefixTest;
import org.eclipse.persistence.testing.tests.mapping.conversion.AttributeNameTokenizerTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class MappingTestModel
extends TestModel {
    public MappingTestModel() {
        this.setDescription("This model tests reading/writing/deleting of the complex mapping model.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new MappingSystem());
    }

    public void addTests() {
        this.addTest((Test)MappingTestModel.getReadObjectTestSuite());
        this.addTest((Test)MappingTestModel.getReadAllTestSuite());
        this.addTest((Test)MappingTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)MappingTestModel.getInsertObjectTestSuite());
        this.addTest((Test)MappingTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)MappingTestModel.getUnitOfWorkTestSuite());
        this.addTest((Test)MappingTestModel.getPublic1MTestSuite());
        this.addTest((Test)MappingTestModel.getPrivateMMTestSuite());
        this.addTest((Test)MappingTestModel.getTransformationMappingTestSuite());
        this.addTest((Test)MappingTestModel.getUnitOfWorkCommitResumeTestSuite());
        this.addTest((Test)MappingTestModel.getBidirectionalUnitOfWorkTestSuite());
        this.addTest((Test)MappingTestModel.getAdditionalJoinTest());
        this.addTest((Test)MappingTestModel.getBuildSelectionCriteriaTestSuite());
        this.addTest((Test)MappingTestModel.getSameNameMappingTestSuite());
        this.addTest((Test)MappingTestModel.getConvertAttributeNameTestSuite());
    }

    public static TestSuite getAdditionalJoinTest() {
        TestSuite suite = new TestSuite();
        suite.setName("AdditionalJoinTestSuite");
        suite.setDescription("This suite tests the addition of an additionalJoinExpression.");
        suite.addTest((Test)new AdditionalJoinExpressionTest());
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new MultipleTableReadObjectTest(manager.getObject(Employee1.class, "example1"), "amendEmployee1WithJoinWithInsert"));
        suite.addTest((Test)new MultipleTableReadObjectTest(manager.getObject(Employee1.class, "example1"), "amendEmployee1WithFKInfo"));
        suite.addTest((Test)new MultipleTableReadObjectTest(manager.getObject(Employee1.class, "example1"), "amendEmployee1WithJoinOnly"));
        suite.addTest((Test)new MultipleTableInsertObjectTest(manager.getObject(Employee1.class, "example2"), "amendEmployee1WithJoinWithInsert"));
        suite.addTest((Test)new MultipleTableInsertObjectTest(manager.getObject(Employee1.class, "example2"), "amendEmployee1WithFKInfo"));
        suite.addTest((Test)new MultipleTableReadAllTest(Employee1.class, 2, "amendEmployee1WithJoinWithInsert"));
        suite.addTest((Test)new MultipleTableReadAllTest(Employee1.class, 2, "amendEmployee1WithJoinOnly"));
        suite.addTest((Test)new MultipleTableReadAllTest(Employee1.class, 2, "amendEmployee1WithFKInfo"));
        suite.addTest((Test)new MultipleTableDeleteObjectTest(manager.getObject(Employee1.class, "example3"), "amendEmployee1WithFKInfo"));
        suite.addTest((Test)new MultipleTableWriteObjectTest(manager.getObject(Employee1.class, "example3"), "amendEmployee1WithFKInfo"));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Employee2.class, "example1")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Employee2.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Employee2.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Employee2.class, "example1")));
        suite.addTest((Test)new InsertObjectTest(manager.getObject(Employee2.class, "example2")));
        return suite;
    }

    public static TestSuite getBidirectionalUnitOfWorkTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BidirectionalUnitOfWorkTestSuite");
        suite.setDescription("This suite tests bidirection in a unit of work.");
        suite.addTest((Test)new BidirectionalUOWInsertTest());
        suite.addTest((Test)new BidirectionalUOWInsertAndDeleteTest());
        return suite;
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("MappingDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the mapping model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Employee.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Employee.class, "example2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Employee.class, "example3")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Computer.class, "example2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Shipment.class, "example2")));
        suite.addTest((Test)new MTMPrivateOwnedWithValueholderDeleteObjectTest());
        suite.addTest((Test)new DirectCollectionMappingDeleteNullValueTest());
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("MappingInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the mapping model.");
        suite.addTest((Test)new InsertObjectTest((Object)Employee.example7()));
        suite.addTest((Test)new InsertObjectTest((Object)Employee.example8()));
        suite.addTest((Test)new InsertObjectTest((Object)Employee.example9()));
        suite.addTest((Test)new InsertObjectTest((Object)Shipment.example1()));
        suite.addTest((Test)new ObjectTypeMappingDefaultNullValues());
        suite.addTest((Test)new MTMPrivateOwnedWithValueholderDeleteObjectTest());
        return suite;
    }

    public static TestSuite getPrivateMMTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("MappingPrivateMMTestSuite");
        suite.setDescription("This suite tests deleting an object, and verifies that private parts are deleted as well.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new PrivateMMTest(manager.getObject(Employee.class, "example1")));
        suite.addTest((Test)new PrivateMMTest(manager.getObject(Employee.class, "example2")));
        suite.addTest((Test)new PrivateMMTest(manager.getObject(Employee.class, "example3")));
        return suite;
    }

    public static TestSuite getPublic1MTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("MappingPublic1MTestSuite");
        suite.setDescription("This suite tests deleting an object, and verifies that public parts are not deleted as well.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new Public1MTest(manager.getObject(Employee.class, "example1")));
        suite.addTest((Test)new Public1MTest(manager.getObject(Employee.class, "example2")));
        suite.addTest((Test)new Public1MTest(manager.getObject(Employee.class, "example3")));
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("MappingReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the mapping model.");
        suite.addTest((Test)new ReadAllTest(Employee.class, 6));
        suite.addTest((Test)new ReadAllTest(Shipment.class, 8));
        suite.addTest((Test)new ReadAllTest(Computer.class, 6));
        suite.addTest((Test)new ObjectTypeMappingBooleanToCharTest());
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("MappingReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the mapping model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Employee.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Employee.class, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Employee.class, "example3")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Shipment.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Computer.class, "example2")));
        suite.addTest((Test)new TwoLevelJoinedAttributeTest());
        suite.addTest((Test)new LoopingJoinedAttributeTest());
        suite.addTest((Test)new OneToOnePKTest());
        return suite;
    }

    public static TestSuite getSameNameMappingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("SameNamePrimaryKeyTestSuite");
        suite.setDescription("This suite test working with objects that have two related objects with attributes with the same name..");
        suite.addTest((Test)new SameNamePKTest());
        return suite;
    }

    public static TestSuite getTransformationMappingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("MappingTransformationTestSuite");
        suite.setDescription("This suite tests the reading of objects where the transformation mapping uses two parameters in the accessor method");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new TwoParametersTransformationMappingTest(manager.getObject(Address.class, "example1")));
        suite.addTest((Test)new TwoParametersTransformationMappingTest(manager.getObject(Address.class, "example2")));
        return suite;
    }

    public static TestSuite getUnitOfWorkCommitResumeTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("UnitOfWorkCommitResumeTestSuite");
        suite.setDescription("This suite tests the unit of work commitResume feature within the mapping model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new UnitOfWorkCommitResumeTest(manager.getObject(Employee.class, "example2")));
        return suite;
    }

    public static TestSuite getUnitOfWorkTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("UnitOfWorkTestSuite");
        suite.setDescription("This suite tests the unit of work feature within the mapping model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new UnitOfWorkTest(manager.getObject(Employee.class, "example2")));
        suite.addTest((Test)new ConstraintOrderTest());
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("MappingUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the mapping model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Employee.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Employee.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Employee.class, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Employee.class, "example3")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Shipment.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Shipment.class, "example1")));
        suite.addTest((Test)new AddObjectNonPrimaryKeyManyToManyTest());
        return suite;
    }

    public static TestSuite getBuildSelectionCriteriaTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BuildSelectionCriteriaTestSuite");
        suite.setDescription("This suite tests buildSelectionCriteria in one-to-one and one-to-many mapping.");
        suite.addTest((Test)new SelectionCriteriaInOneToOneTest());
        suite.addTest((Test)new SelectionCriteriaInOneToManyTest());
        suite.addTest((Test)new SelectionCriteriaInTargetOneToOneTest());
        return suite;
    }

    public static TestSuite getConvertAttributeNameTestSuite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(AttributeNamePrefixTest.class);
        suite.addTestSuite(AttributeNameTokenizerTest.class);
        return suite;
    }
}

