/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.writechanges;

import java.math.BigDecimal;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class WriteChanges_Commit_NonTrivial_TestCase
extends AutoVerifyTestCase {
    public BigDecimal id = null;

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employee = new Employee();
        employee = (Employee)uow.registerObject((Object)employee);
        employee.setFirstName("Stephen");
        employee.setLastName("McRitchie");
        uow.writeChanges();
        if (employee.getId().intValue() == 0) {
            throw new TestErrorException("Sequence numbers for new objects not available after write changes.");
        }
        this.id = employee.getId();
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        Expression expression = new ExpressionBuilder().get("id").equal((Object)this.id);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class, expression);
        Employee employee = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        if (employee == null || !employee.getFirstName().equals("Stephen")) {
            throw new TestErrorException("The employee was not written properly.  Found only: " + employee);
        }
    }

    public void reset() {
        if (this.id == null) {
            return;
        }
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Expression expression = new ExpressionBuilder().get("id").equal((Object)this.id);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class, expression);
        Employee employee = (Employee)uow.executeQuery((DatabaseQuery)query);
        uow.deleteObject((Object)employee);
        uow.commit();
    }

    protected void resetVerify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        Expression expression = new ExpressionBuilder().get("id").equal((Object)this.id);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class, expression);
        Employee employee = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        this.id = null;
        if (employee != null) {
            throw new TestErrorException("Employee not removed after the test.");
        }
    }
}

