/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class NullValueTest
extends AutoVerifyTestCase {
    Map saveDefaultNullValues;
    Map saveDefaultDefaultNullValues;
    Employee employee;

    public NullValueTest() {
        this.setDescription("Verify that the appropriate values are put in the object when nulls are encountered on the database");
    }

    protected void setup() {
        this.saveDefaultDefaultNullValues = ConversionManager.getDefaultManager().getDefaultNullValues();
        this.saveDefaultNullValues = this.getSession().getLogin().getPlatform().getConversionManager().getDefaultNullValues();
        this.getSession().getLogin().getPlatform().getConversionManager().setDefaultNullValues(new Hashtable());
        this.getSession().getLogin().setDefaultNullValue(String.class, (Object)"null");
        this.getSession().getLogin().setDefaultNullValue(Integer.TYPE, (Object)new Integer(-1));
        for (DatabaseMapping mapping : this.getSession().getDescriptor(Address.class).getMappings()) {
            if (!mapping.isDirectToFieldMapping()) continue;
            mapping.preInitialize(this.getAbstractSession());
        }
        this.getAbstractSession().beginTransaction();
        this.employee = new Employee();
        this.employee.setFirstName("Fred");
        this.employee.setLastName("Flintstone");
        this.employee.setSalary(22);
        this.employee.setGender("Male");
        Address address = new Address();
        address.setCity(null);
        this.employee.setAddress(address);
        this.getAbstractSession().writeObject((Object)this.employee);
        this.getSession().executeNonSelectingCall((Call)new SQLCall("update SALARY set SALARY = null where EMP_ID = " + this.employee.getId()));
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().getLogin().getPlatform().getConversionManager().setDefaultNullValues(this.saveDefaultNullValues);
        ConversionManager.getDefaultManager().setDefaultNullValues(this.saveDefaultDefaultNullValues);
    }

    public void test() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.employee = (Employee)this.getSession().readObject((Object)this.employee);
    }

    protected void verify() {
        if (!this.employee.getAddress().getCity().equals("null")) {
            throw new TestErrorException("Null value not converted correctly for string.");
        }
        if (this.employee.getSalary() != -1) {
            throw new TestErrorException("Null value not converted correctly for int.");
        }
    }
}

