/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.math.BigDecimal;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class CountReportQueryTest
extends ReportQueryTestCase {
    int expectedCount;

    public CountReportQueryTest(ReportQuery reportQuery, int expectedCount) {
        this.reportQuery = reportQuery;
        this.expectedCount = expectedCount;
        this.setDescription("COUNT aggregate function");
    }

    @Override
    protected void buildExpectedResults() {
        Object[] result = new Object[]{new BigDecimal(this.expectedCount)};
        this.addResult(result, null);
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.reportQuery = (ReportQuery)this.reportQuery.clone();
    }

    @Override
    protected void verify() {
        BigDecimal result;
        if (this.results.size() != this.expectedResults.size()) {
            throw new TestErrorException("ReportQuery test failed: The result size are different");
        }
        BigDecimal expected = (BigDecimal)((ReportQueryResult)this.expectedResults.firstElement()).getByIndex(0);
        if (!Helper.compareBigDecimals((BigDecimal)expected, (BigDecimal)(result = (BigDecimal)ConversionManager.getDefaultManager().convertObject(((ReportQueryResult)this.results.firstElement()).getByIndex(0), BigDecimal.class)))) {
            throw new TestErrorException("ReportQuery test failed: The results did not match (" + expected + ", " + result + ")");
        }
    }
}

