/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.readonly;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.readonly.Country;

public class InsertReadOnlyClassTestCase
extends AutoVerifyTestCase {
    public UnitOfWork uow;
    Country aCountry;

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        this.beginTransaction();
        this.uow = this.getSession().acquireUnitOfWork();
        this.uow.addReadOnlyClass(Country.class);
    }

    protected void test() {
        this.aCountry = new Country();
        this.aCountry.setName("Utopia");
        this.uow.registerObject((Object)this.aCountry);
        this.uow.commit();
    }

    protected void verify() {
        ExpressionBuilder xBuilder = new ExpressionBuilder();
        Expression exp = xBuilder.get("name").equal((Object)this.aCountry.name);
        Country dbCountry = (Country)this.getSession().readObject(Country.class, exp);
        if (dbCountry != null) {
            throw new TestErrorException("The Country object was inserted! It should not have been since it is read-only.");
        }
    }
}

