/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.math.BigDecimal;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.GolfClub;
import org.eclipse.persistence.testing.models.aggregate.GolfClubShaft;
import org.eclipse.persistence.testing.models.aggregate.Manufacturer;

public class JoinInAggregateAndOwnerTest
extends TestCase {
    protected int oldJoinFetch;
    protected BigDecimal clubId = null;
    protected boolean initialWriteFailed = false;
    protected boolean joinFailed = false;

    public JoinInAggregateAndOwnerTest() {
        this.setDescription("Test joining on an attribute that exists both on an aggregate and its parent.");
    }

    public void setup() {
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(GolfClub.class);
        OneToOneMapping mapping = (OneToOneMapping)descriptor.getMappingForAttributeName("manufacturer");
        this.oldJoinFetch = mapping.getJoinFetch();
        mapping.useInnerJoinFetch();
        descriptor.reInitializeJoinedAttributes();
        this.beginTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Manufacturer taylorMade = new Manufacturer();
        taylorMade.setName("Taylor Made");
        GolfClubShaft shaft = new GolfClubShaft();
        shaft.setManufacturer(taylorMade);
        shaft.setStiffnessRating("R90");
        GolfClub club = new GolfClub();
        club.setManufacturer(taylorMade);
        club.setShaft(shaft);
        uow.registerObject((Object)club);
        uow.commit();
        this.clubId = club.getId();
    }

    public void test() {
        ExpressionBuilder clubs;
        Expression exp;
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        GolfClub club = (GolfClub)uow.readObject(GolfClub.class, exp = (clubs = new ExpressionBuilder()).get("id").equal((Object)this.clubId));
        if (club.getManufacturer().getName() != club.getShaft().getManufacturer().getName()) {
            this.initialWriteFailed = true;
        }
        Manufacturer manufacturer = new Manufacturer();
        manufacturer.setName("True Temper");
        club.getShaft().setManufacturer(manufacturer);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        club = (GolfClub)this.getSession().readObject(GolfClub.class, exp);
        if (club.getManufacturer().getName() == club.getShaft().getManufacturer().getName()) {
            this.joinFailed = true;
        }
    }

    public void verify() {
        if (this.initialWriteFailed) {
            throw new TestErrorException("Aggregate attribute should be equal to parent attribute and it is not.");
        }
        if (this.joinFailed) {
            throw new TestErrorException("Aggregate attribute should be not equal to parent attribute and it is.");
        }
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(GolfClub.class);
        OneToOneMapping mapping = (OneToOneMapping)descriptor.getMappingForAttributeName("manufacturer");
        mapping.setJoinFetch(this.oldJoinFetch);
        descriptor.reInitializeJoinedAttributes();
    }
}

