/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ConformResultsAcrossOneToManyTest
extends AutoVerifyTestCase {
    protected Employee employee;
    protected UnitOfWork unitOfWork;
    protected ReadAllQuery queryAllObjects;
    protected ReadAllQuery queryAll;
    protected ReadObjectQuery queryObject;
    protected Vector employees;
    protected Vector allPhones;
    protected Vector allEmployees;
    protected Vector employeesInCache;

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.allEmployees = new Vector();
        this.allPhones = new Vector();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.queryAll = new ReadAllQuery();
        this.queryAll.setReferenceClass(Employee.class);
        this.queryAll.setSelectionCriteria(new ExpressionBuilder().anyOf("phoneNumbers").get("areaCode").equal((Object)"613"));
        this.queryAll.conformResultsInUnitOfWork();
        this.allEmployees = (Vector)this.getSession().executeQuery((DatabaseQuery)this.queryAll);
        Enumeration enumtr = this.allEmployees.elements();
        while (enumtr.hasMoreElements()) {
            Vector phones = ((Employee)enumtr.nextElement()).getPhoneNumbers();
            this.allPhones.addAll(phones);
        }
    }

    public void test() {
        this.queryAllObjects = new ReadAllQuery();
        this.queryAllObjects.setReferenceClass(Employee.class);
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp = bldr.anyOf("phoneNumbers").get("areaCode").equal((Object)"613");
        this.queryAllObjects.setSelectionCriteria(exp);
        this.employeesInCache = (Vector)this.getSession().executeQuery((DatabaseQuery)this.queryAllObjects);
        this.unitOfWork.release();
    }

    public void verify() {
        if (this.employeesInCache.size() == 13) {
            // empty if block
        }
    }
}

