/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.converters;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import org.eclipse.persistence.platform.database.converters.StructConverter;

public class JGeometryConverter
implements StructConverter {
    private static final String JGEOMETRY_DB_TYPE = "MDSYS.SDO_GEOMETRY";
    private final Class JGEOMETRY_CLASS;
    private final MethodHandle loadJSMethod;
    private final MethodHandle storeJSMethod;

    public JGeometryConverter() {
        try {
            this.JGEOMETRY_CLASS = Class.forName("oracle.spatial.geometry.JGeometry");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            this.loadJSMethod = lookup.unreflect(this.JGEOMETRY_CLASS.getMethod("loadJS", Struct.class));
            this.storeJSMethod = lookup.unreflect(this.JGEOMETRY_CLASS.getMethod("storeJS", this.JGEOMETRY_CLASS, Connection.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getStructName() {
        return JGEOMETRY_DB_TYPE;
    }

    @Override
    public Class getJavaType() {
        return this.JGEOMETRY_CLASS;
    }

    @Override
    public Object convertToObject(Struct struct) throws SQLException {
        if (struct == null) {
            return null;
        }
        try {
            return this.loadJSMethod.invokeWithArguments(struct);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable);
        }
    }

    @Override
    public Struct convertToStruct(Object geometry, Connection connection) throws SQLException {
        if (geometry == null) {
            return null;
        }
        try {
            return (Struct)this.storeJSMethod.invokeWithArguments(this.JGEOMETRY_CLASS.cast(geometry), connection);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable);
        }
    }
}

