/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadAllMaxRowsFirstResultVsRownumFilteringTest
extends PerformanceComparisonTestCase {
    int maxrows;

    public ReadAllMaxRowsFirstResultVsRownumFilteringTest() {
        this.setDescription("This test compares the performance of Oracle pagination vs non pagination.");
        this.addReadAllRownumFilteringTest();
        this.addReadAllMaxRowsFirstResultTest();
    }

    public void setup() throws Throwable {
        super.setup();
        int size = this.getSession().readAllObjects(Employee.class).size();
        this.maxrows = size / 2;
    }

    public void test() throws Exception {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void addReadAllRownumFilteringTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.setMaxRows(ReadAllMaxRowsFirstResultVsRownumFilteringTest.this.maxrows);
                query.setFirstResult(ReadAllMaxRowsFirstResultVsRownumFilteringTest.this.maxrows - 1);
                this.getSession().executeQuery((DatabaseQuery)query);
            }
        };
        test.setName("ReadAllRownumFilteringTest");
        test.setAllowableDecrease(300.0);
        this.addTest((TestCase)test);
    }

    public void addReadAllMaxRowsFirstResultTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.setMaxRows(ReadAllMaxRowsFirstResultVsRownumFilteringTest.this.maxrows);
                query.setFirstResult(ReadAllMaxRowsFirstResultVsRownumFilteringTest.this.maxrows - 1);
                this.getSession().executeQuery((DatabaseQuery)query);
            }

            public void startTest() {
                ((OraclePlatform)this.getSession().getPlatform()).setShouldUseRownumFiltering(false);
            }

            public void endTest() {
                ((OraclePlatform)this.getSession().getPlatform()).setShouldUseRownumFiltering(true);
            }
        };
        test.setName("ReadAllMaxRowsFirstResultTest");
        test.setAllowableDecrease(50.0);
        this.addTest((TestCase)test);
    }
}

