/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import java.util.List;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadAllvsCursorTest
extends PerformanceComparisonTestCase {
    public ReadAllvsCursorTest() {
        this.setDescription("This test compares the performance of read all vs cursored read all.");
        this.addReadAllCursoredStreamTest();
        this.addReadAllScrollableCursorTest();
    }

    public void test() throws Exception {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        List results = (List)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void addReadAllCursoredStreamTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.useCursoredStream();
                Cursor cursor = (Cursor)this.getSession().executeQuery((DatabaseQuery)query);
                cursor.close();
            }
        };
        test.setName("ReadAllCursoredStreamTest");
        test.setAllowableDecrease(100.0);
        this.addTest((TestCase)test);
    }

    public void addReadAllScrollableCursorTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.useScrollableCursor();
                Cursor cursor = (Cursor)this.getSession().executeQuery((DatabaseQuery)query);
                cursor.close();
            }
        };
        test.setName("ReadAllScrollableCursorTest");
        test.setAllowableDecrease(50.0);
        this.addTest((TestCase)test);
    }
}

