/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.collections;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.collections.Diner;
import org.eclipse.persistence.testing.models.collections.Location;
import org.eclipse.persistence.testing.models.collections.Menu;
import org.eclipse.persistence.testing.models.collections.MenuItem;
import org.eclipse.persistence.testing.models.collections.Person;
import org.eclipse.persistence.testing.models.collections.Restaurant;
import org.eclipse.persistence.testing.models.collections.Waiter;

public class CollectionsProject
extends Project {
    public CollectionsProject() {
        this.applyPROJECT();
        this.applyLOGIN();
        this.buildLocationDescriptor();
        this.buildMenuDescriptor();
        this.buildMenuItemDescriptor();
        this.buildPersonDescriptor();
        this.buildDinerDescriptor();
        this.buildWaiterDescriptor();
        this.buildRestaurantDescriptor();
    }

    protected void applyLOGIN() {
        DatabaseLogin login = new DatabaseLogin();
        this.setLogin(login);
    }

    protected void applyPROJECT() {
        this.setName("Collections");
    }

    protected void buildDinerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Diner.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("COL_PERS");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("COL_PERS.ID");
        descriptor.getInheritancePolicy().setParentClass(Person.class);
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildLocationDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Location.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("COL_LOCA");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("COL_LOCA.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("LOCA_ID");
        descriptor.setSequenceNumberFieldName("ID");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("COL_LOCA.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("area");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getArea");
        directtofieldmapping1.setSetMethodName("setArea");
        directtofieldmapping1.setFieldName("COL_LOCA.AREA");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("city");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getCity");
        directtofieldmapping2.setSetMethodName("setCity");
        directtofieldmapping2.setFieldName("COL_LOCA.CITY");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildMenuDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Menu.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("COL_MENU");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("COL_MENU.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("MENU_ID");
        descriptor.setSequenceNumberFieldName("ID");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("COL_MENU.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("type");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getType");
        directtofieldmapping1.setSetMethodName("setType");
        directtofieldmapping1.setFieldName("COL_MENU.TYPE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        OneToManyMapping onetomanymapping = new OneToManyMapping();
        onetomanymapping.setAttributeName("items");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(true);
        onetomanymapping.setGetMethodName("getItemsHolder");
        onetomanymapping.setSetMethodName("setItemsHolder");
        onetomanymapping.setReferenceClass(MenuItem.class);
        onetomanymapping.setIsPrivateOwned(true);
        onetomanymapping.addTargetForeignKeyFieldName("COL_M_IT.MENU_ID", "COL_MENU.ID");
        onetomanymapping.useCollectionClass(LinkedList.class);
        descriptor.addMapping((DatabaseMapping)onetomanymapping);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("owner");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(true);
        onetoonemapping.setGetMethodName("getOwnerHolder");
        onetoonemapping.setSetMethodName("setOwnerHolder");
        onetoonemapping.setReferenceClass(Restaurant.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("COL_MENU.REST_ID", "COL_REST.ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildMenuItemDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(MenuItem.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("COL_M_IT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("COL_M_IT.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("MENU_ITEM_SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setGetMethodName("getId");
        directtofieldmapping1.setSetMethodName("setId");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("COL_M_IT.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("name");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getName");
        directtofieldmapping2.setSetMethodName("setName");
        directtofieldmapping2.setFieldName("COL_M_IT.NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        DirectToFieldMapping directtofieldmapping3 = new DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("price");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setGetMethodName("getPrice");
        directtofieldmapping3.setSetMethodName("setPrice");
        directtofieldmapping3.setFieldName("COL_M_IT.PRICE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping3);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("menu");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(true);
        onetoonemapping.setGetMethodName("getMenuHolder");
        onetoonemapping.setSetMethodName("setMenuHolder");
        onetoonemapping.setReferenceClass(Menu.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("COL_M_IT.MENU_ID", "COL_MENU.ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildPersonDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Person.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("COL_PERS");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("COL_PERS.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("PERSON_SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("CLASS");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().addClassIndicator(Diner.class, (Object)"D");
        descriptor.getInheritancePolicy().addClassIndicator(Waiter.class, (Object)"W");
        descriptor.getInheritancePolicy().addClassIndicator(Person.class, (Object)"P");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("firstName");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getFirstName");
        directtofieldmapping.setSetMethodName("setFirstName");
        directtofieldmapping.setFieldName("COL_PERS.F_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getId");
        directtofieldmapping1.setSetMethodName("setId");
        directtofieldmapping1.setFieldName("COL_PERS.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("lastName");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getLastName");
        directtofieldmapping2.setSetMethodName("setLastName");
        directtofieldmapping2.setFieldName("COL_PERS.L_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildRestaurantDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Restaurant.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("COL_REST");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("COL_REST.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberName("REST_ID");
        descriptor.setSequenceNumberFieldName("ID");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getId");
        directtofieldmapping.setSetMethodName("setId");
        directtofieldmapping.setFieldName("COL_REST.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("name");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getName");
        directtofieldmapping1.setSetMethodName("setName");
        directtofieldmapping1.setFieldName("COL_REST.NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        OneToManyMapping onetomanymapping = new OneToManyMapping();
        onetomanymapping.setAttributeName("menus");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(true);
        onetomanymapping.setGetMethodName("getMenusHolder");
        onetomanymapping.setSetMethodName("setMenusHolder");
        onetomanymapping.setReferenceClass(Menu.class);
        onetomanymapping.setIsPrivateOwned(true);
        onetomanymapping.addTargetForeignKeyFieldName("COL_MENU.REST_ID", "COL_REST.ID");
        onetomanymapping.useMapClass(Hashtable.class, "getKey");
        descriptor.addMapping((DatabaseMapping)onetomanymapping);
        OneToManyMapping onetomanymapping1 = new OneToManyMapping();
        onetomanymapping1.setAttributeName("waiters");
        onetomanymapping1.setIsReadOnly(false);
        onetomanymapping1.setUsesIndirection(false);
        onetomanymapping1.setGetMethodName("getWaiters");
        onetomanymapping1.setSetMethodName("setWaiters");
        onetomanymapping1.setReferenceClass(Waiter.class);
        onetomanymapping1.setIsPrivateOwned(true);
        onetomanymapping1.addTargetForeignKeyFieldName("COL_PERS.W_RST_ID", "COL_REST.ID");
        onetomanymapping1.useCollectionClass(ArrayList.class);
        descriptor.addMapping((DatabaseMapping)onetomanymapping1);
        ManyToManyMapping manytomanymapping = new ManyToManyMapping();
        manytomanymapping.setAttributeName("preferredCustomers");
        manytomanymapping.setIsReadOnly(false);
        manytomanymapping.setUsesIndirection(false);
        manytomanymapping.setGetMethodName("getPreferredCustomers");
        manytomanymapping.setSetMethodName("setPreferredCustomers");
        manytomanymapping.setReferenceClass(Diner.class);
        manytomanymapping.setIsPrivateOwned(false);
        manytomanymapping.setRelationTableName("COL_DI_R");
        manytomanymapping.addTargetRelationKeyFieldName("COL_DI_R.DINER_ID", "COL_PERS.ID");
        manytomanymapping.addSourceRelationKeyFieldName("COL_DI_R.REST_ID", "COL_REST.ID");
        manytomanymapping.useMapClass(Hashtable.class, "getLastName");
        descriptor.addMapping((DatabaseMapping)manytomanymapping);
        ManyToManyMapping manytomanymapping1 = new ManyToManyMapping();
        manytomanymapping1.setAttributeName("locations");
        manytomanymapping1.setIsReadOnly(false);
        manytomanymapping1.setUsesIndirection(false);
        manytomanymapping1.setGetMethodName("getLocations");
        manytomanymapping1.setSetMethodName("setLocations");
        manytomanymapping1.setReferenceClass(Location.class);
        manytomanymapping1.setIsPrivateOwned(false);
        manytomanymapping1.setRelationTableName("COL_R_LO");
        manytomanymapping1.addTargetRelationKeyFieldName("COL_R_LO.LOCA_ID", "COL_LOCA.ID");
        manytomanymapping1.addSourceRelationKeyFieldName("COL_R_LO.REST_ID", "COL_REST.ID");
        manytomanymapping1.useCollectionClass(ArrayList.class);
        descriptor.addMapping((DatabaseMapping)manytomanymapping1);
        ManyToManyMapping manytomanymapping2 = new ManyToManyMapping();
        manytomanymapping2.setAttributeName("locations2");
        manytomanymapping2.setIsReadOnly(false);
        manytomanymapping2.setUsesIndirection(false);
        manytomanymapping2.setGetMethodName("getLocations2");
        manytomanymapping2.setSetMethodName("setLocations2");
        manytomanymapping2.setReferenceClass(Location.class);
        manytomanymapping2.setIsPrivateOwned(false);
        manytomanymapping2.setRelationTableName("COL_R_LO2");
        manytomanymapping2.addTargetRelationKeyFieldName("COL_R_LO2.LOCA_ID", "COL_LOCA.ID");
        manytomanymapping2.addSourceRelationKeyFieldName("COL_R_LO2.REST_ID", "COL_REST.ID");
        manytomanymapping2.useSortedSetClass(TreeSet.class, Restaurant.getLocationComparator());
        descriptor.addMapping((DatabaseMapping)manytomanymapping2);
        DirectCollectionMapping directcollectionmapping = new DirectCollectionMapping();
        directcollectionmapping.setAttributeName("slogans");
        directcollectionmapping.setUsesIndirection(true);
        directcollectionmapping.setGetMethodName("getSlogansHolder");
        directcollectionmapping.setSetMethodName("setSlogansHolder");
        directcollectionmapping.setDirectFieldName("COL_SLOG.SLOGAN");
        directcollectionmapping.setReferenceTableName("COL_SLOG");
        directcollectionmapping.addReferenceKeyFieldName("COL_SLOG.REST_ID", "COL_REST.ID");
        directcollectionmapping.useCollectionClass(ArrayList.class);
        descriptor.addMapping((DatabaseMapping)directcollectionmapping);
        DirectCollectionMapping servicesMapping = new DirectCollectionMapping();
        servicesMapping.setAttributeName("services");
        servicesMapping.setUsesIndirection(true);
        servicesMapping.setDirectFieldName("COL_SERVICES.SERVICE");
        servicesMapping.setReferenceTableName("COL_SERVICES");
        servicesMapping.addReferenceKeyFieldName("COL_SERVICES.REST_ID", "COL_REST.ID");
        servicesMapping.useCollectionClass(ArrayList.class);
        ObjectTypeConverter servicesConverter = new ObjectTypeConverter();
        servicesConverter.addConversionValue((Object)"AC", (Object)"Air Conditioning");
        servicesConverter.addConversionValue((Object)"RESV", (Object)"Reservations Required");
        servicesConverter.addConversionValue((Object)"DRSCD", (Object)"Formal Attire");
        servicesMapping.setValueConverter((Converter)servicesConverter);
        descriptor.addMapping((DatabaseMapping)servicesMapping);
        DirectMapMapping licensesMapping = new DirectMapMapping();
        licensesMapping.setAttributeName("licenses");
        licensesMapping.setDirectKeyFieldName("COL_LICENSE.LICENSE");
        licensesMapping.setDirectFieldName("COL_LICENSE.STATUS");
        licensesMapping.setReferenceTableName("COL_LICENSE");
        licensesMapping.addReferenceKeyFieldName("COL_LICENSE.REST_ID", "COL_REST.ID");
        licensesMapping.useTransparentMap();
        ObjectTypeConverter licensesKeyConverter = new ObjectTypeConverter();
        licensesKeyConverter.addConversionValue((Object)"AL", (Object)"Alcohol License");
        licensesKeyConverter.addConversionValue((Object)"FD", (Object)"Food License");
        licensesKeyConverter.addConversionValue((Object)"SM", (Object)"Smoking License");
        licensesKeyConverter.addConversionValue((Object)"SL", (Object)"Site Licence");
        licensesMapping.setKeyConverter((Converter)licensesKeyConverter);
        TypeConversionConverter licensesValueConverter = new TypeConversionConverter();
        licensesValueConverter.setObjectClass(Boolean.class);
        licensesValueConverter.setDataClass(Integer.class);
        licensesMapping.setValueConverter((Converter)licensesValueConverter);
        descriptor.addMapping((DatabaseMapping)licensesMapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildWaiterDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Waiter.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("COL_PERS");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("COL_PERS.ID");
        descriptor.getInheritancePolicy().setParentClass(Person.class);
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("specialty");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getSpecialty");
        directtofieldmapping.setSetMethodName("setSpecialty");
        directtofieldmapping.setFieldName("COL_PERS.SPECIALT");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("employer");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(true);
        onetoonemapping.setGetMethodName("getEmployerHolder");
        onetoonemapping.setSetMethodName("setEmployerHolder");
        onetoonemapping.setReferenceClass(Restaurant.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("COL_PERS.W_RST_ID", "COL_REST.ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }
}

