/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import java.util.Enumeration;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class CacheExpiryValueholderTest
extends CacheExpiryTest {
    protected Employee readEmployee = null;

    public CacheExpiryValueholderTest() {
        this.setDescription("Test cache expiry across a Valueholder");
    }

    public void test() {
        ExpressionBuilder address = new ExpressionBuilder();
        Expression streetExp = address.get("street").equal((Object)"1 Habs Place");
        Address add = (Address)this.getSession().readObject(Address.class, streetExp);
        CacheKey key = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getCacheKeyForObject((Object)add);
        ((Address)key.getObject()).setStreet("Ave. Sherbrooke");
        this.getSession().getIdentityMapAccessor().invalidateObject((Object)add);
        Enumeration numbers = this.getSession().readAllObjects(PhoneNumber.class).elements();
        while (numbers.hasMoreElements()) {
            PhoneNumber number = (PhoneNumber)numbers.nextElement();
            number.setAreaCode("000");
            this.getSession().getIdentityMapAccessor().invalidateObject((Object)number);
        }
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression addressExp = employee.get("address").get("street").equal((Object)"1 Habs Place");
        this.readEmployee = (Employee)this.getSession().readObject(Employee.class, addressExp);
    }

    public void verify() {
        if (!this.readEmployee.getAddress().getStreet().equals("1 Habs Place")) {
            throw new TestErrorException("Invalidation is not working correctly for valueholders.");
        }
        Enumeration numbers = this.readEmployee.getPhoneNumbers().elements();
        while (numbers.hasMoreElements()) {
            if (!((PhoneNumber)numbers.nextElement()).getAreaCode().equals("000")) continue;
            throw new TestErrorException("Invalidation is not working correctly for valueholders.");
        }
    }
}

