/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.interfaces.Actor;
import org.eclipse.persistence.testing.models.interfaces.Documentary;

public class OneToManyVariableBackBatchReadingTest
extends AutoVerifyTestCase {
    public List result;

    public OneToManyVariableBackBatchReadingTest() {
        this.setDescription("Tests batch reading with a 1-m with a variable 1-1 back.");
    }

    public void test() {
        Vector actors = this.getSession().readAllObjects(Actor.class);
        Iterator iterator = actors.iterator();
        while (iterator.hasNext()) {
            ((Actor)iterator.next()).program.getName();
        }
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Documentary.class);
        query.refreshIdentityMapResult();
        query.addBatchReadAttribute("actors");
        this.result = (List)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        Documentary documentary = (Documentary)this.result.get(0);
        this.strongAssert(documentary.actors.size() > 0, "Test failed. Batched objects were not read.");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

