/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.isolatedsession;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedChild;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedParent;

public class IsolatedSessionRelationConformingTest
extends TestCase {
    public IsolatedSessionRelationConformingTest() {
        this.setDescription("IsolatedSessionRelationConformingTest");
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        IsolatedParent exampleParent = IsolatedParent.buildIsolatedParentExample1();
        IsolatedParent result = (IsolatedParent)uow.executeQuery("findParentBySerial", IsolatedParent.class, (Object)exampleParent.getSerial());
        IsolatedSessionRelationConformingTest.assertNotNull((String)"Parent should not be null", (Object)result);
        IsolatedSessionRelationConformingTest.assertNotNull((String)"Parent should not have a null collection", result.getChildren());
        IsolatedSessionRelationConformingTest.assertEquals((String)"Parent should be the same id", (String)exampleParent.getId(), (String)result.getId());
        IsolatedSessionRelationConformingTest.assertEquals((String)"Parent should be the same serial", (String)exampleParent.getSerial(), (String)result.getSerial());
        IsolatedSessionRelationConformingTest.assertSame((String)"Parent should not have a zero length collection", (Object)exampleParent.getChildren().size(), (Object)result.getChildren().size());
        IsolatedChild child = result.getChildren().get(0);
        IsolatedChild exampleChild = exampleParent.getChildren().get(0);
        IsolatedSessionRelationConformingTest.assertNotNull((String)"Only child should not be null", (Object)child);
        IsolatedSessionRelationConformingTest.assertEquals((String)"Only child should have the same id", (String)exampleChild.getId(), (String)child.getId());
        IsolatedSessionRelationConformingTest.assertNotNull((String)"Only child should have a valid parent", (Object)child.getParent());
        IsolatedSessionRelationConformingTest.assertEquals((String)"Only child should reference the found parent", (Object)result, (Object)child.getParent());
    }
}

