/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote.suncorba;

import java.util.Properties;
import junit.framework.Test;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.corba.sun.CORBAConnection;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;
import org.eclipse.persistence.testing.tests.remote.TransporterGenerator;
import org.eclipse.persistence.testing.tests.remote.suncorba.CORBAConnectionExceptionsTest;
import org.eclipse.persistence.testing.tests.remote.suncorba.CORBAServerManager;
import org.eclipse.persistence.testing.tests.remote.suncorba.CORBAServerManagerHelper;
import org.eclipse.persistence.testing.tests.remote.suncorba.CORBAServerRunner;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public class SunCORBARemoteModel
extends RemoteModel {
    public CORBAConnection createConnection() {
        System.out.println("The following environment properties must be set to run this test.");
        System.out.println("-Djava.naming.factory.initial=com.sun.jndi.cosnaming.CNCtxFactory -Djava.naming.provider.url=iiop://localhost:900");
        System.out.println("The follwing corba naming server must also be started on the computer.");
        System.out.println("<java_home>/bin/tnameserv.exe");
        CORBAServerManager manager = null;
        try {
            ORB orb = ORB.init((String[])new String[0], (Properties)new Properties());
            Object objRef = orb.resolve_initial_references("NameService");
            NamingContext ncRef = NamingContextHelper.narrow((Object)objRef);
            NameComponent nc = new NameComponent("CORBAServer", "");
            NameComponent[] path = new NameComponent[]{nc};
            manager = CORBAServerManagerHelper.narrow(ncRef.resolve(path));
        }
        catch (Exception exception) {
            throw new TestErrorException("Corba not configured correctly, see system.out.", (Throwable)exception);
        }
        return new CORBAConnection(manager.createRemoteSessionController());
    }

    @Override
    public void setup() {
        RemoteModel.originalSession = this.getSession();
        new CORBAServerRunner(this.buildServerSession()).start();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CORBAConnection connection = this.createConnection();
        Session remoteSession = connection.createRemoteSession();
        remoteSession.setLog(RemoteModel.originalSession.getLog());
        remoteSession.setLogLevel(RemoteModel.originalSession.getLogLevel());
        this.getExecutor().setSession(remoteSession);
    }

    @Override
    public void addTests() {
        super.addTests();
        this.addTest((Test)SunCORBARemoteModel.getExceptionsTestSuite());
    }

    public static TestSuite getExceptionsTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ExceptionsTestSuite");
        suite.setDescription("Verifies whether the right exceptions are thrown");
        suite.addTest((Test)new CORBAConnectionExceptionsTest(TransporterGenerator.SET_EXCEPTION_INTO_TRANSPORTER));
        return suite;
    }
}

