/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.cobol;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.eis.cobol.CobolRedefinedFieldValue;
import org.eclipse.persistence.internal.eis.cobol.CobolRow;
import org.eclipse.persistence.internal.eis.cobol.FieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.RecordMetaData;
import org.eclipse.persistence.internal.eis.cobol.helper.ByteConverter;
import org.eclipse.persistence.internal.eis.cobol.helper.Helper;
import org.eclipse.persistence.internal.helper.DatabaseField;

public class ElementaryFieldMetaData
implements FieldMetaData {
    protected RecordMetaData myRecord;
    protected String myName;
    protected int mySize;
    protected int myOffset;
    protected int myType;
    protected boolean isRedefine;
    protected int decimalPosition;
    protected FieldMetaData myFieldRedefined;
    protected int myArraySize;
    protected String myDependentFieldName;
    protected boolean isSigned;

    public ElementaryFieldMetaData() {
        this.initialize();
    }

    public ElementaryFieldMetaData(String fieldName, String recordName) {
        this.initialize(fieldName, recordName);
    }

    public ElementaryFieldMetaData(String fieldName, RecordMetaData record) {
        this.initialize(fieldName, record);
    }

    protected void initialize() {
        this.myRecord = new RecordMetaData();
        this.isRedefine = false;
        this.decimalPosition = -1;
        this.myArraySize = -1;
        this.isSigned = false;
        this.myDependentFieldName = "";
    }

    protected void initialize(String fieldName, String recordName) {
        this.myName = fieldName;
        this.myRecord = new RecordMetaData(recordName);
        this.isRedefine = false;
        this.decimalPosition = -1;
        this.myArraySize = -1;
        this.isSigned = false;
        this.myDependentFieldName = "";
    }

    protected void initialize(String fieldName, RecordMetaData record) {
        this.myName = fieldName;
        this.myRecord = record;
        this.isRedefine = false;
        this.decimalPosition = -1;
        this.myArraySize = -1;
        this.isSigned = false;
        this.myDependentFieldName = "";
    }

    @Override
    public FieldMetaData deepCopy() {
        ElementaryFieldMetaData fieldCopy = new ElementaryFieldMetaData(this.myName, this.myRecord.getName());
        fieldCopy.setIsFieldRedefine(this.isRedefine);
        fieldCopy.setDecimalPosition(this.decimalPosition);
        fieldCopy.setArraySize(this.myArraySize);
        fieldCopy.setSize(this.mySize);
        fieldCopy.setOffset(this.myOffset);
        fieldCopy.setType(this.myType);
        if (this.isFieldRedefine()) {
            fieldCopy.setFieldRedefined(this.myFieldRedefined.deepCopy());
        }
        fieldCopy.setDependentFieldName(this.myDependentFieldName);
        fieldCopy.setIsSigned(this.isSigned);
        return fieldCopy;
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    @Override
    public void setIsSigned(boolean signed) {
        this.isSigned = signed;
    }

    @Override
    public boolean hasDecimal() {
        return this.decimalPosition != -1;
    }

    @Override
    public int getDecimalPosition() {
        return this.decimalPosition;
    }

    @Override
    public void setDecimalPosition(int newPosition) {
        this.decimalPosition = newPosition;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void setName(String newName) {
        this.myName = newName;
    }

    @Override
    public RecordMetaData getRecord() {
        return this.myRecord;
    }

    @Override
    public void setRecord(RecordMetaData newRecord) {
        this.myRecord = newRecord;
    }

    @Override
    public int getSize() {
        return this.mySize;
    }

    @Override
    public void setSize(int size) {
        this.mySize = size;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    public Vector getCompositeFields() {
        return new Vector();
    }

    @Override
    public int getOffset() {
        return this.myOffset;
    }

    @Override
    public void setOffset(int offset) {
        this.myOffset = offset;
    }

    @Override
    public int getType() {
        return this.myType;
    }

    @Override
    public void setType(int type) {
        this.myType = type;
    }

    @Override
    public boolean isFieldRedefine() {
        return this.isRedefine;
    }

    @Override
    public void setIsFieldRedefine(boolean status) {
        this.isRedefine = status;
    }

    @Override
    public void setFieldRedefined(FieldMetaData field) {
        this.myFieldRedefined = field;
        this.isRedefine = field != null;
    }

    @Override
    public FieldMetaData getFieldRedefined() {
        return this.myFieldRedefined;
    }

    @Override
    public boolean isArray() {
        return this.myArraySize > 0;
    }

    @Override
    public int getArraySize() {
        return this.myArraySize;
    }

    @Override
    public void setArraySize(int newSize) {
        this.myArraySize = newSize;
    }

    @Override
    public boolean dependsOn() {
        return !this.myDependentFieldName.isEmpty();
    }

    @Override
    public String getDependentFieldName() {
        return this.myDependentFieldName;
    }

    @Override
    public void setDependentFieldName(String fieldName) {
        this.myDependentFieldName = fieldName;
    }

    @Override
    public Object extractValueFromArray(byte[] recordData) {
        Object value;
        if (this.isArray()) {
            int offset = this.getOffset();
            ArrayList<String> fieldValue = new ArrayList<String>(this.getArraySize());
            int i = this.getArraySize();
            while (i > 0) {
                FieldMetaData fieldCopy = this.deepCopy();
                fieldCopy.setOffset(offset);
                ByteConverter converter = new ByteConverter(fieldCopy, recordData);
                fieldValue.add(converter.getStringValue());
                offset += this.mySize;
                --i;
            }
            value = fieldValue;
        } else {
            ByteConverter converter = new ByteConverter(this, recordData);
            value = converter.getStringValue();
        }
        return value;
    }

    protected void adjustArraySize(CobolRow row) {
        Integer intValue = Helper.integerFromString(row.get(this.getDependentFieldName()).toString());
        if (intValue != null) {
            this.setArraySize(intValue);
        }
    }

    @Override
    public void writeOnRow(CobolRow row, byte[] recordData) {
        DatabaseField field = new DatabaseField(this.getName(), this.getRecord().getName());
        if (this.isArray() && this.dependsOn()) {
            this.adjustArraySize(row);
        }
        Object value = !this.isFieldRedefine() ? this.extractValueFromArray(recordData) : new CobolRedefinedFieldValue(this, recordData);
        row.add(field, value);
    }

    @Override
    public void writeOnArray(CobolRow row, byte[] recordData) {
        Object value = row.get(this.getName());
        if (this.isArray()) {
            if (this.dependsOn()) {
                this.adjustArraySize(row);
            }
            int offset = this.getOffset();
            Iterator elements = ((List)value).iterator();
            int i = this.getArraySize();
            while (i > 0) {
                FieldMetaData fieldCopy = this.deepCopy();
                fieldCopy.setOffset(offset);
                ByteConverter converter = new ByteConverter(fieldCopy, recordData);
                String elementValue = (String)elements.next();
                converter.setBytesToValue(elementValue);
                offset += this.mySize;
                --i;
            }
        } else {
            ByteConverter converter = new ByteConverter(this, recordData);
            converter.setBytesToValue((String)value);
        }
    }
}

