/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.criteria;

import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.tests.jpa.criteria.JUnitCriteriaSimpleTestSuiteBase;

public class JUnitCriteriaSimpleTestSuite
extends JUnitCriteriaSimpleTestSuiteBase<String> {
    @Override
    protected void setWrapper() {
        this.wrapper = new Wrapper();
    }

    @Override
    protected void populateAttributes() {
        this.attributes = new HashMap();
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Employee_id, "id");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Employee_firstName, "firstName");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Employee_lastName, "lastName");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Employee_salary, "salary");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Employee_normalHours, "normalHours");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Employee_phoneNumbers, "phoneNumbers");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Employee_managedEmployees, "managedEmployees");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Employee_projects, "projects");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Employee_address, "address");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Employee_status, "status");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Employee_hugeProject, "hugeProject");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.PhoneNumber_number, "number");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.PhoneNumber_areaCode, "areaCode");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.PhoneNumber_owner, "owner");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Address_street, "street");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Address_postalCode, "postalCode");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Address_city, "city");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.LargeProject_budget, "budget");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.BeerConsumer_blueBeersToConsume, "blueBeersToConsume");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.BlueLight_discount, "discount");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.Person_car, "car");
        this.attributes.put(JUnitCriteriaSimpleTestSuiteBase.Attributes.SportsCar_maxSpeed, "maxSpeed");
    }

    public JUnitCriteriaSimpleTestSuite() {
    }

    public JUnitCriteriaSimpleTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = (TestSuite)JUnitCriteriaSimpleTestSuiteBase.suite(JUnitCriteriaSimpleTestSuite.class);
        suite.setName("JUnitCriteriaSimpleTestSuite");
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("testParameterEqualsParameter"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("testOneEqualsOne"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("testTupleTupleValidation"));
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testParameterEqualsParameter() throws Exception {
        DatabasePlatform databasePlatform = JUnitTestCase.getServerSession().getPlatform();
        if (databasePlatform.isSymfoware()) {
            JUnitCriteriaSimpleTestSuite.getServerSession().logMessage("Test testParameterEqualsParameter skipped for this platform, Symfoware doesn't allow dynamic parameters on both sides of the equals operator at the same time. (bug 304897)");
            return;
        }
        if (databasePlatform.isMaxDB()) {
            JUnitCriteriaSimpleTestSuite.getServerSession().logMessage("Test testParameterEqualsParameter skipped for this platform, MaxDB doesn't allow dynamic parameters on both sides of the equals operator at the same time. (bug 326962)");
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            TypedQuery query = em.createQuery(qb.createQuery(Employee.class));
            List emps = query.getResultList();
            JUnitCriteriaSimpleTestSuite.assertNotNull((Object)emps);
            int numRead = emps.size();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            cq.where((Expression)qb.equal((Expression)qb.parameter(Integer.class, "arg1"), (Expression)qb.parameter(Integer.class, "arg2")));
            query = em.createQuery(cq);
            query.setParameter("arg1", (Object)1);
            query.setParameter("arg2", (Object)1);
            emps = query.getResultList();
            JUnitCriteriaSimpleTestSuite.assertNotNull((Object)emps);
            JUnitCriteriaSimpleTestSuite.assertEquals((int)numRead, (int)emps.size());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneEqualsOne() throws Exception {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            TypedQuery query = em.createQuery(qb.createQuery(Employee.class));
            List emps = query.getResultList();
            JUnitCriteriaSimpleTestSuite.assertNotNull((Object)emps);
            int numRead = emps.size();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            cq.where((Expression)qb.equal(qb.literal((Object)1), (Object)1));
            emps = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuite.assertNotNull((Object)emps);
            JUnitCriteriaSimpleTestSuite.assertEquals((int)numRead, (int)emps.size());
            ExpressionBuilder builder = new ExpressionBuilder();
            query = ((JpaEntityManager)em.getDelegate()).createQuery(builder.value(1).equal(builder.value(1)), Employee.class);
            emps = query.getResultList();
            JUnitCriteriaSimpleTestSuite.assertNotNull((Object)emps);
            JUnitCriteriaSimpleTestSuite.assertEquals((int)numRead, (int)emps.size());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testTupleTupleValidation() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery criteria = qb.createTupleQuery();
        Root emp = criteria.from(Employee.class);
        Path unusedTupleElement = emp.get("normalHours");
        Path lastName = emp.get("lastName");
        criteria.multiselect(new Selection[]{lastName, emp.get("firstName")});
        TypedQuery query = em.createQuery(criteria);
        List list = query.getResultList();
        Tuple row = (Tuple)list.get(0);
        row.get((TupleElement)lastName);
        try {
            Object result = row.get((TupleElement)unusedTupleElement);
            JUnitCriteriaSimpleTestSuite.fail((String)("IllegalArgumentException expected using an invalid value. Result returned:" + result));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuite.assertEquals(IllegalArgumentException.class, iae.getClass());
        }
        this.closeEntityManager(em);
    }

    private final class Wrapper
    implements JUnitCriteriaSimpleTestSuiteBase.CriteriaQueryWrapper {
        private Wrapper() {
        }

        @Override
        public <X, Y> Root<X> from(CriteriaQuery<Y> query, Class<X> entityClass) {
            return query.from(entityClass);
        }

        @Override
        public <X, Y> Fetch<X, Y> fetch(Root<X> root, JUnitCriteriaSimpleTestSuiteBase.Attributes attributeKey, JoinType joinType) {
            return root.fetch((String)JUnitCriteriaSimpleTestSuite.this.attributes.get((Object)attributeKey), JoinType.LEFT);
        }

        public <X, Y> Path<Y> get(Path<X> path, JUnitCriteriaSimpleTestSuiteBase.Attributes attributeKey) {
            return path.get((String)JUnitCriteriaSimpleTestSuite.this.attributes.get((Object)attributeKey));
        }

        @Override
        public <X, Y> Join<X, Y> join(Root<X> root, JUnitCriteriaSimpleTestSuiteBase.Attributes attributeKey) {
            return root.join((String)JUnitCriteriaSimpleTestSuite.this.attributes.get((Object)attributeKey));
        }

        @Override
        public <X, Y> Join<X, Y> join(Root<X> root, JUnitCriteriaSimpleTestSuiteBase.Attributes attributeKey, JoinType joinType) {
            return root.join((String)JUnitCriteriaSimpleTestSuite.this.attributes.get((Object)attributeKey), joinType);
        }
    }
}

