/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fetchgroups;

import java.util.Collection;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.queries.EntityFetchGroup;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.junit.Assert;

public class FetchGroupAssert {
    public static boolean isValid(FetchGroup fetchGroup, EntityManagerFactory emf, Class<?> entityClass) {
        Assert.assertNotNull((Object)fetchGroup);
        ServerSession session = ((JpaEntityManager)emf.createEntityManager()).getServerSession();
        ClassDescriptor descriptor = session.getDescriptor(entityClass);
        try {
            for (Map.Entry entry : fetchGroup.getItems().entrySet()) {
                AttributeItem item = (AttributeItem)entry.getValue();
                DatabaseMapping mapping = descriptor.getMappingForAttributeName(item.getAttributeName());
                if (mapping.isForeignReferenceMapping()) {
                    if (item.getGroup() == null || FetchGroupAssert.isValid((FetchGroup)item.getGroup(), emf, ((ForeignReferenceMapping)mapping).getReferenceClass())) continue;
                    return false;
                }
                return false;
            }
        }
        catch (QueryException qe) {
            return false;
        }
        return true;
    }

    public static void assertFetchedAttribute(EntityManagerFactory emf, Object entity, String ... attribute) {
        Assert.assertNotNull((String)"EntityManagerFactory is null", (Object)emf);
        Assert.assertNotNull((String)"Entity is null", (Object)entity);
        ServerSession session = ((JpaEntityManager)emf.createEntityManager()).getServerSession();
        Assert.assertNotNull((String)("No Server session found for: " + emf), (Object)session);
        ClassDescriptor desc = session.getClassDescriptor(entity);
        Assert.assertNotNull((String)("No descriptor found for: " + entity), (Object)desc);
        Object value = entity;
        if (attribute.length > 1) {
            DatabaseMapping mapping;
            String attrName = attribute[1];
            if (desc.hasFetchGroupManager()) {
                Assert.assertTrue((String)("Attribute: '" + attrName + "' not fetched on: " + value), (boolean)desc.getFetchGroupManager().isAttributeFetched(value, attrName));
            }
            if ((value = (mapping = desc.getMappingForAttributeName(attrName)).getAttributeValueFromObject(value)) instanceof IndirectContainer) {
                value = ((IndirectContainer)value).getValueHolder();
            }
            if (value instanceof ValueHolderInterface) {
                ValueHolderInterface vhi = (ValueHolderInterface)value;
                Assert.assertTrue((String)("ValueHolder for: '" + attrName + "' not instantiated"), (boolean)vhi.isInstantiated());
                value = vhi.getValue();
            }
            String[] tail = new String[attribute.length - 1];
            System.arraycopy(attribute, 1, tail, 0, attribute.length - 1);
            if (value instanceof Collection) {
                for (Object obj : (Collection)value) {
                    FetchGroupAssert.assertFetchedAttribute(emf, value, tail);
                }
            } else {
                FetchGroupAssert.assertFetchedAttribute(emf, value, tail);
            }
        } else if (desc.hasFetchGroupManager()) {
            Assert.assertTrue((boolean)desc.getFetchGroupManager().isAttributeFetched(value, attribute[0]));
        }
    }

    public static void assertNotFetchedAttribute(EntityManagerFactory emf, Object entity, String ... attribute) {
        Assert.assertNotNull((String)"EntityManagerFactory is null", (Object)emf);
        Assert.assertNotNull((String)"Entity is null", (Object)entity);
        ServerSession session = ((JpaEntityManager)emf.createEntityManager()).getServerSession();
        Assert.assertNotNull((String)("No Server session found for: " + emf), (Object)session);
        ClassDescriptor desc = session.getClassDescriptor(entity);
        Assert.assertNotNull((String)("No descriptor found for: " + entity), (Object)desc);
        Object value = entity;
        for (int index = 0; index < attribute.length - 1; ++index) {
            DatabaseMapping mapping;
            String attrName = attribute[index];
            if (desc.hasFetchGroupManager()) {
                Assert.assertTrue((String)("Attribute: '" + attrName + "' not fetched on: " + value), (boolean)desc.getFetchGroupManager().isAttributeFetched(value, attrName));
            }
            if ((value = (mapping = desc.getMappingForAttributeName(attrName)).getAttributeValueFromObject(value)) instanceof IndirectContainer) {
                value = ((IndirectContainer)value).getValueHolder();
            }
            if (!(value instanceof ValueHolderInterface)) continue;
            ValueHolderInterface vhi = (ValueHolderInterface)value;
            Assert.assertTrue((String)("ValueHolder for: '" + attrName + "' not instantiated"), (boolean)vhi.isInstantiated());
            value = vhi.getValue();
        }
    }

    public static void assertFetched(EntityManagerFactory emf, Object entity, FetchGroup fetchGroup) {
        Assert.assertNotNull((String)"Null entity", (Object)entity);
        Assert.assertNotNull((String)"No FetchGroup provided", (Object)fetchGroup);
        if (!(entity instanceof FetchGroupTracker)) {
            System.out.println();
        }
        Assert.assertTrue((String)("Entity does not implement FetchGroupTracker: " + entity), (boolean)(entity instanceof FetchGroupTracker));
        FetchGroupTracker tracker = (FetchGroupTracker)entity;
        Assert.assertNotNull((String)"FetchGroup on entity is null", (Object)tracker._persistence_getFetchGroup());
        FetchGroup groupToCompare = fetchGroup;
        if (!fetchGroup.isEntityFetchGroup()) {
            groupToCompare = new EntityFetchGroup(fetchGroup);
        }
        Assert.assertTrue((String)"FetchGroup on entity does not equal provided", (boolean)tracker._persistence_getFetchGroup().equals((Object)groupToCompare));
        ServerSession session = ((JpaEntityManager)emf.createEntityManager()).getServerSession();
        Assert.assertNotNull((Object)session);
        ClassDescriptor descriptor = session.getClassDescriptor(entity);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertTrue((String)"", (boolean)descriptor.getJavaClass().isAssignableFrom(entity.getClass()));
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            if (descriptor.getObjectBuilder().getPrimaryKeyMappings().contains(mapping)) {
                Assert.assertTrue((String)("PrimaryKey mapping not fetched: " + entity), (boolean)tracker._persistence_isAttributeFetched(mapping.getAttributeName()));
                continue;
            }
            if (descriptor.usesOptimisticLocking() && descriptor.getOptimisticLockingPolicy() instanceof VersionLockingPolicy && ((VersionLockingPolicy)descriptor.getOptimisticLockingPolicy()).getVersionMapping() == mapping) {
                Assert.assertTrue((String)("Optimistic version mapping not fetched: " + entity), (boolean)tracker._persistence_isAttributeFetched(mapping.getAttributeName()));
                continue;
            }
            if (tracker._persistence_getFetchGroup().containsAttribute(mapping.getAttributeName())) {
                Assert.assertTrue((boolean)tracker._persistence_isAttributeFetched(mapping.getAttributeName()));
                continue;
            }
            Assert.assertFalse((boolean)tracker._persistence_isAttributeFetched(mapping.getAttributeName()));
        }
    }

    public static void assertDefaultFetched(EntityManagerFactory emf, Object entity) {
        Assert.assertNotNull((String)"Null entity", (Object)entity);
        ClassDescriptor descriptor = ((JpaEntityManager)emf.createEntityManager()).getServerSession().getClassDescriptor(entity);
        Assert.assertNotNull((String)("No descriptor found for: " + entity), (Object)descriptor);
        Assert.assertTrue((String)("No FetchGroupManager on: " + descriptor), (boolean)descriptor.hasFetchGroupManager());
        FetchGroup defaultFG = descriptor.getFetchGroupManager().getDefaultFetchGroup();
        Assert.assertNotNull((String)("No default FetchGroup on: " + descriptor), (Object)defaultFG);
        FetchGroupAssert.assertFetched(emf, entity, defaultFG);
    }

    public static void assertFetched(EntityManagerFactory emf, Object entity, String fetchGroupName) {
        Assert.assertNotNull((String)"Null entity", (Object)entity);
        ClassDescriptor descriptor = ((JpaEntityManager)emf.createEntityManager()).getServerSession().getClassDescriptor(entity);
        Assert.assertNotNull((String)("No descriptor found for: " + entity), (Object)descriptor);
        Assert.assertTrue((String)("No FetchGroupManager on: " + descriptor), (boolean)descriptor.hasFetchGroupManager());
        FetchGroup fg = descriptor.getFetchGroupManager().getFetchGroup(fetchGroupName);
        Assert.assertNotNull((String)("No FetchGroup named: " + fetchGroupName), (Object)fg);
        FetchGroupAssert.assertFetched(emf, entity, fg);
    }

    public static void assertNoFetchGroup(EntityManagerFactory emf, Object entity) {
        if (entity instanceof FetchGroupTracker) {
            FetchGroupTracker tracker = (FetchGroupTracker)entity;
            Assert.assertNull((String)("Entity: " + entity + " has: " + tracker._persistence_getFetchGroup()), (Object)tracker._persistence_getFetchGroup());
        }
    }

    public static void assertConfig(EntityManagerFactory emf, String entityName, FetchGroup defaultFetchGroup) {
        FetchGroupAssert.assertConfig(emf, entityName, defaultFetchGroup, 0);
    }

    public static void assertConfig(EntityManagerFactory emf, String entityName, FetchGroup defaultFetchGroup, int numNamedFetchGroups) {
        ClassDescriptor descriptor = ((JpaEntityManager)emf.createEntityManager()).getServerSession().getClassDescriptorForAlias(entityName);
        Assert.assertNotNull((String)("Not descriptor found for: " + entityName), (Object)descriptor);
        FetchGroupAssert.assertConfig(descriptor, defaultFetchGroup, numNamedFetchGroups);
    }

    public static void assertConfig(ClassDescriptor descriptor, FetchGroup defaultFetchGroup, int numNamedFetchGroups) {
        String entityName = descriptor.getAlias();
        Assert.assertTrue((String)("FetchGroupTracker not implemented by: " + entityName), (boolean)FetchGroupTracker.class.isAssignableFrom(descriptor.getJavaClass()));
        if (defaultFetchGroup == null) {
            Assert.assertNull((String)("Default FetchGroup not null: " + entityName), (Object)descriptor.getFetchGroupManager().getDefaultFetchGroup());
        } else if (defaultFetchGroup != descriptor.getFetchGroupManager().getDefaultFetchGroup()) {
            Assert.fail((String)"Default FetchGroup does not match");
        }
        if (numNamedFetchGroups != descriptor.getFetchGroupManager().getFetchGroups().size()) {
            Assert.fail((String)("Incorrect number of Named FetchGroups: " + entityName));
        }
    }

    public static void assertConfig(ClassDescriptor descriptor, FetchGroup defaultFetchGroup) {
        FetchGroupAssert.assertConfig(descriptor, defaultFetchGroup, 0);
    }
}

