/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.interfaces.Actor;
import org.eclipse.persistence.testing.models.interfaces.ProgramInt;

public class QueryAccrossV11ProxyIndirectionTest
extends AutoVerifyTestCase {
    protected Exception caughtException;
    protected ClassDescriptor descriptor;
    protected IndirectionPolicy indirectionPolicy = null;

    public QueryAccrossV11ProxyIndirectionTest() {
        this.setDescription("Test that VariableOneToOneMapping mapping with ProxyIndirection  works correctly");
    }

    public ClassDescriptor getDescriptorV11ProxyIndirection() {
        return this.descriptor;
    }

    public void setDescriptorV11ProxyIndirection(Class cls, String attributeName, Class proxyIndirectClass) {
        ClassDescriptor descriptorToReturn = null;
        descriptorToReturn = this.getSession().getClassDescriptor(cls);
        ObjectReferenceMapping mappingForAttribute = (ObjectReferenceMapping)descriptorToReturn.getMappingForAttributeName(attributeName);
        this.indirectionPolicy = mappingForAttribute.getIndirectionPolicy();
        mappingForAttribute.useProxyIndirection(proxyIndirectClass);
        this.descriptor = descriptorToReturn;
    }

    public void resetDescriptorV11ProxyIndirection(String attributeName) {
        ObjectReferenceMapping mappingForAttribute = (ObjectReferenceMapping)this.descriptor.getMappingForAttributeName(attributeName);
        mappingForAttribute.setIndirectionPolicy(this.indirectionPolicy);
    }

    public void setup() {
        this.setDescriptorV11ProxyIndirection(Actor.class, "program", ProgramInt.class);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        try {
            Vector actors = this.getSession().readAllObjects(Actor.class);
            for (int x = 0; x < actors.size(); ++x) {
                Actor actor = (Actor)actors.elementAt(x);
                String string = actor.program.getName();
            }
        }
        catch (NullPointerException e) {
            this.caughtException = e;
        }
    }

    public void reset() {
        this.resetDescriptorV11ProxyIndirection("program");
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void verify() {
        if (this.caughtException != null) {
            throw new TestErrorException("Test that VariableOneToOneMapping mapping with ProxyIndirection works correctly.\nThis exception thrown while testing test case.\n----- QueryAccrossV11ProxyIndirectionTest() -----\n" + this.caughtException.getMessage());
        }
    }
}

