/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.security;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.JCEEncryptor;
import org.junit.Assert;
import org.junit.Test;

public class SecurableBackwardsCompatibilityTest {
    @Test
    public void testStringDecryption_DES_ECB() throws Exception {
        String plainTextString = "welcome123_des_ecb";
        String testString = this.encryptString_DES_ECB(plainTextString);
        Assert.assertFalse((String)"Strings should not match.", (boolean)plainTextString.equals(testString));
        JCEEncryptor securable = new JCEEncryptor();
        String decryptedString = securable.decryptPassword(testString);
        Assert.assertEquals((String)"Strings should match.", (Object)plainTextString, (Object)decryptedString);
    }

    @Test
    public void testStringDecryption_AES_GCM() throws Exception {
        String plainTextString = "welcome123_aes_gcm";
        JCEEncryptor securable = new JCEEncryptor();
        String testString = securable.encryptPassword(plainTextString);
        Assert.assertFalse((String)"Strings should not match.", (boolean)plainTextString.equals(testString));
        String decryptedString = securable.decryptPassword(testString);
        Assert.assertEquals((String)"Strings should match.", (Object)plainTextString, (Object)decryptedString);
    }

    @Test
    public void testStringDecryption_AES_CBC() throws Exception {
        String plainTextString = "welcome123_aes_cbc";
        String testString = this.encryptString_AES_CBC(plainTextString);
        Assert.assertFalse((String)"Strings should not match.", (boolean)plainTextString.equals(testString));
        JCEEncryptor securable = new JCEEncryptor();
        String decryptedString = securable.decryptPassword(testString);
        Assert.assertEquals((String)"Strings should match.", (Object)plainTextString, (Object)decryptedString);
    }

    @Test
    public void testStringDecryption_AES_ECB() throws Exception {
        String plainTextString = "welcome123_aes_ecb";
        String testString = this.encryptString_AES_ECB(plainTextString);
        Assert.assertFalse((String)"Strings should not match.", (boolean)plainTextString.equals(testString));
        JCEEncryptor securable = new JCEEncryptor();
        String decryptedString = securable.decryptPassword(testString);
        Assert.assertEquals((String)"Strings should match.", (Object)plainTextString, (Object)decryptedString);
    }

    @Test
    public void testStringDecryption_AES_ECB_withSessionName() throws Exception {
        String plainTextString = "welcome123_aes_ecb";
        String testString = this.encryptString_AES_ECB(plainTextString);
        Assert.assertFalse((String)"Strings should not match.", (boolean)plainTextString.equals(testString));
        JCEEncryptor jceEncryptor = new JCEEncryptor();
        jceEncryptor.setSessionName("/file:/testdir/_test-jpa-pu");
        String decryptedString = jceEncryptor.decryptPassword(testString);
        Assert.assertEquals((String)"Strings should match.", (Object)plainTextString, (Object)decryptedString);
    }

    @Test
    public void testStringDecryption_PlainText() throws Exception {
        String plainTextString = "welcome123_plaintext";
        JCEEncryptor securable = new JCEEncryptor();
        String decryptedString = securable.decryptPassword(plainTextString);
        Assert.assertEquals((String)"Passwords should match.", (Object)plainTextString, (Object)decryptedString);
    }

    @Test
    public void testEmptyStringParameterDecryption() throws Exception {
        JCEEncryptor securable = new JCEEncryptor();
        String returnValue = securable.decryptPassword("");
        Assert.assertEquals((String)"Empty string \"\" should be returned when decrypting a \"\" (empty string) value", (Object)"", (Object)returnValue);
    }

    @Test
    public void testNullParameterDecryption() throws Exception {
        JCEEncryptor securable = new JCEEncryptor();
        String returnValue = securable.decryptPassword(null);
        Assert.assertNull((String)"Null should be returned when decrypting a null value", (Object)returnValue);
    }

    @Test
    public void testNullParameterEncryption() throws Exception {
        ValidationException expectedException = null;
        try {
            JCEEncryptor securable = new JCEEncryptor();
            securable.encryptPassword(null);
        }
        catch (ValidationException ve) {
            expectedException = ve;
        }
        Assert.assertNotNull((String)"A ValidationException should be thrown when encrypting a null value", (Object)((Object)expectedException));
    }

    private String encryptString_DES_ECB(String aString) throws Exception {
        byte[] bytes = Helper.buildBytesFromHexString((String)"E60B80C7AEC78038");
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(1, SecretKeyFactory.getInstance("DES").generateSecret(new DESKeySpec(bytes)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CipherOutputStream cos = new CipherOutputStream(baos, cipher);
        ObjectOutputStream oos = new ObjectOutputStream(cos);
        oos.writeObject(aString);
        oos.flush();
        oos.close();
        return Helper.buildHexStringFromBytes((byte[])baos.toByteArray());
    }

    private String encryptString_AES_CBC(String aString) throws Exception {
        byte[] bytes = Helper.buildBytesFromHexString((String)"2DB7354A48F1CA7B48ACA247540FC923");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec iv = SecurableBackwardsCompatibilityTest.getIvSpec();
        cipher.init(1, (Key)new SecretKeySpec(bytes, "AES"), iv);
        return Helper.buildHexStringFromBytes((byte[])cipher.doFinal(aString.getBytes("UTF-8")));
    }

    private String encryptString_AES_ECB(String aString) throws Exception {
        byte[] bytes = Helper.buildBytesFromHexString((String)"3E7CFEF156E712906E1F603B59463C67");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, new SecretKeySpec(bytes, "AES"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CipherOutputStream cos = new CipherOutputStream(baos, cipher);
        ObjectOutputStream oos = new ObjectOutputStream(cos);
        oos.writeObject(aString);
        oos.flush();
        oos.close();
        return Helper.buildHexStringFromBytes((byte[])baos.toByteArray());
    }

    private static IvParameterSpec getIvSpec() {
        byte[] b = new byte[]{-26, 124, -99, 32, -37, -58, -93, 100, 126, -55, -21, 48, -86, 97, 12, 113};
        return new IvParameterSpec(b);
    }
}

