/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class MergeCloneWithReferencesWithNullTest
extends AutoVerifyTestCase {
    public MergeCloneWithReferencesWithNullTest() {
        this.setDescription("This test verifies that mergeCloneWithReferences will not throw an exception when encountering a null within a collection.");
    }

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.getAbstractSession().rollbackTransaction();
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    public void setup() {
        if (this.getSession() instanceof RemoteSession) {
            throw new TestWarningException("This test cannot be run through the remote.");
        }
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        try {
            Employee empObject = (Employee)this.getSession().readObject(Employee.class);
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            empObject.getPhoneNumbers().add(null);
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            uow.readObject((Object)empObject);
            uow.mergeCloneWithReferences((Object)empObject);
            uow.release();
        }
        catch (NullPointerException exception) {
            throw new TestErrorException("Test Failed.  NullPointer was thrown");
        }
    }
}

