/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced.fetchgroup;

import java.lang.reflect.Field;
import java.util.HashMap;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.fetchgroup.AdvancedFetchGroupTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.fetchgroup.ChestProtector;
import org.eclipse.persistence.testing.models.jpa.advanced.fetchgroup.GoalieGear;
import org.eclipse.persistence.testing.models.jpa.advanced.fetchgroup.Helmet;
import org.eclipse.persistence.testing.models.jpa.advanced.fetchgroup.HockeyGear;
import org.eclipse.persistence.testing.models.jpa.advanced.fetchgroup.Pads;
import org.eclipse.persistence.testing.models.jpa.advanced.fetchgroup.Shelf;

public class AdvancedFetchGroupJunitTest
extends JUnitTestCase {
    private static Integer padsId;
    private static Integer chestProtectorId;

    public AdvancedFetchGroupJunitTest() {
    }

    public AdvancedFetchGroupJunitTest(String name) {
        super(name);
    }

    public void setUp() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("AdvancedFetchGroupJunitTest");
        suite.addTest((Test)new AdvancedFetchGroupJunitTest("testSetup"));
        suite.addTest((Test)new AdvancedFetchGroupJunitTest("testVerifyFetchGroups"));
        suite.addTest((Test)new AdvancedFetchGroupJunitTest("testCreateHockeyGear"));
        suite.addTest((Test)new AdvancedFetchGroupJunitTest("testFetchGroupOnPads"));
        suite.addTest((Test)new AdvancedFetchGroupJunitTest("testFetchGroupOnChestProtector"));
        suite.addTest((Test)new AdvancedFetchGroupJunitTest("testFetchGroupOnPadsFromInheritanceParent"));
        suite.addTest((Test)new AdvancedFetchGroupJunitTest("testFetchGroupMergeMapAttribute"));
        suite.addTest((Test)new AdvancedFetchGroupJunitTest("testFetchGroupForCachedReference"));
        return suite;
    }

    public void testSetup() {
        new AdvancedFetchGroupTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testVerifyFetchGroups() {
        if (this.isWeavingEnabled()) {
            ClassDescriptor hockeyGearDescriptor = AdvancedFetchGroupJunitTest.getServerSession().getDescriptor(HockeyGear.class);
            FetchGroupManager hockeyGearFetchGroupManager = hockeyGearDescriptor.getFetchGroupManager();
            AdvancedFetchGroupJunitTest.assertTrue((String)"Wrong number of fetch groups for HockeyGear", (hockeyGearFetchGroupManager.getFetchGroups().size() == 1 ? 1 : 0) != 0);
            AdvancedFetchGroupJunitTest.assertNotNull((String)"The 'MSRP' fetch group was not found for HockeyGear", (Object)hockeyGearFetchGroupManager.getFetchGroup("MSRP"));
            ClassDescriptor padsDescriptor = AdvancedFetchGroupJunitTest.getServerSession().getDescriptor(Pads.class);
            FetchGroupManager padsFetchGroupManager = padsDescriptor.getFetchGroupManager();
            AdvancedFetchGroupJunitTest.assertTrue((String)"Wrong number of fetch groups for Pads", (padsFetchGroupManager.getFetchGroups().size() == 3 ? 1 : 0) != 0);
            AdvancedFetchGroupJunitTest.assertNotNull((String)"The 'HeightAndWidth' fetch group was not found for Pads", (Object)padsFetchGroupManager.getFetchGroup("HeightAndWidth"));
            AdvancedFetchGroupJunitTest.assertNotNull((String)"The 'Weight' fetch group was not found for Pads", (Object)padsFetchGroupManager.getFetchGroup("Weight"));
            AdvancedFetchGroupJunitTest.assertNotNull((String)"The 'AgeGroup' fetch group was not found for Pads", (Object)padsFetchGroupManager.getFetchGroup("AgeGroup"));
            ClassDescriptor chestProtectorDescriptor = AdvancedFetchGroupJunitTest.getServerSession().getDescriptor(ChestProtector.class);
            FetchGroupManager chestProtectorFetchGroupManager = chestProtectorDescriptor.getFetchGroupManager();
            AdvancedFetchGroupJunitTest.assertTrue((String)"Wrong number of fetch groups for ChestProtector", (chestProtectorFetchGroupManager.getFetchGroups().size() == 1 ? 1 : 0) != 0);
            AdvancedFetchGroupJunitTest.assertNotNull((String)"The 'AgeGroup' fetch group was not found for ChestProtector", (Object)chestProtectorFetchGroupManager.getFetchGroup("AgeGroup"));
        }
    }

    public void testCreateHockeyGear() {
        if (this.isWeavingEnabled()) {
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            try {
                Pads pads = new Pads();
                pads.setAgeGroup(GoalieGear.AgeGroup.SENIOR);
                pads.setDescription("Louisville TPS");
                pads.setHeight(Double.valueOf(35.5));
                pads.setMsrp(Double.valueOf(999.99));
                pads.setWeight(Double.valueOf(4.9));
                pads.setWidth(Double.valueOf(11.0));
                em.persist((Object)pads);
                ChestProtector chestProtector = new ChestProtector();
                chestProtector.setAgeGroup(GoalieGear.AgeGroup.INTERMEDIATE);
                chestProtector.setDescription("RBK Premier");
                chestProtector.setMsrp(Double.valueOf(599.99));
                chestProtector.setSize("Large");
                em.persist((Object)chestProtector);
                this.commitTransaction(em);
                padsId = pads.getSerialNumber();
                chestProtectorId = chestProtector.getSerialNumber();
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFetchGroupOnPads() {
        if (this.isWeavingEnabled()) {
            EntityManager em = this.createEntityManager();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eclipselink.fetch-group.name", "HeightAndWidth");
            Class<Pads> PadsClass = Pads.class;
            Pads pads = (Pads)em.find(PadsClass, (Object)padsId, properties);
            try {
                this.verifyFetchedField(PadsClass.getDeclaredField("height"), pads, 35.5);
                this.verifyFetchedField(PadsClass.getDeclaredField("width"), pads, 11.0);
                this.verifyNonFetchedField(PadsClass.getDeclaredField("weight"), pads);
                this.verifyNonFetchedField(PadsClass.getField("ageGroup"), pads);
                this.verifyNonFetchedField(PadsClass.getField("description"), pads);
                this.verifyNonFetchedField(PadsClass.getField("msrp"), pads);
            }
            catch (Exception e) {
                AdvancedFetchGroupJunitTest.fail((String)("Error verifying field content: " + e.getMessage()));
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFetchGroupOnChestProtector() {
        if (this.isWeavingEnabled()) {
            EntityManager em = this.createEntityManager();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eclipselink.fetch-group.name", "AgeGroup");
            Class<ChestProtector> chestProtectorClass = ChestProtector.class;
            ChestProtector chestProtector = (ChestProtector)em.find(chestProtectorClass, (Object)chestProtectorId, properties);
            try {
                this.verifyFetchedField(chestProtectorClass.getField("ageGroup"), chestProtector, GoalieGear.AgeGroup.INTERMEDIATE);
                this.verifyNonFetchedField(chestProtectorClass.getField("description"), chestProtector);
                this.verifyNonFetchedField(chestProtectorClass.getField("msrp"), chestProtector);
                this.verifyNonFetchedField(chestProtectorClass.getDeclaredField("size"), chestProtector);
            }
            catch (Exception e) {
                AdvancedFetchGroupJunitTest.fail((String)("Error verifying field content: " + e.getMessage()));
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFetchGroupOnPadsFromInheritanceParent() {
        if (this.isWeavingEnabled()) {
            EntityManager em = this.createEntityManager();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eclipselink.fetch-group.name", "MSRP");
            Class<Pads> PadsClass = Pads.class;
            Pads pads = (Pads)em.find(PadsClass, (Object)padsId, properties);
            try {
                this.verifyFetchedField(PadsClass.getField("msrp"), pads, 999.99);
                this.verifyNonFetchedField(PadsClass.getDeclaredField("height"), pads);
                this.verifyNonFetchedField(PadsClass.getDeclaredField("width"), pads);
                this.verifyNonFetchedField(PadsClass.getDeclaredField("weight"), pads);
                this.verifyNonFetchedField(PadsClass.getField("ageGroup"), pads);
                this.verifyNonFetchedField(PadsClass.getField("description"), pads);
            }
            catch (Exception e) {
                AdvancedFetchGroupJunitTest.fail((String)("Error verifying field content: " + e.getMessage()));
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFetchGroupMergeMapAttribute() {
        if (!this.isWeavingEnabled()) {
            return;
        }
        int helmetId = 1;
        Helmet helmet = null;
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.createNativeQuery("DELETE FROM JPA_HELMET_PROPERTIES WHERE HELMET_ID=" + helmetId).executeUpdate();
            em.createNativeQuery("DELETE FROM JPA_HELMET WHERE ID=" + helmetId).executeUpdate();
            em.createNativeQuery("INSERT INTO JPA_HELMET (ID, COLOR) VALUES (" + helmetId + ", 'red')").executeUpdate();
            this.commitTransaction(em);
        }
        catch (Exception e) {
            AdvancedFetchGroupJunitTest.fail((String)("Error creating test data: " + e.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            helmet = (Helmet)em.find(Helmet.class, (Object)helmetId);
            AdvancedFetchGroupJunitTest.assertNotNull((String)("Found Helmet entity with id: " + helmetId + " should be non-null"), (Object)helmet);
            em.clear();
            helmet.getColor();
            helmet.addProperty("random", "This parrot is deceased");
            Helmet helmetMerged = (Helmet)em.merge((Object)helmet);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            AdvancedFetchGroupJunitTest.fail((String)("Error merging an Entity with a Map attribute: " + e.getMessage()));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.beginTransaction(em);
            helmet = (Helmet)em.find(Helmet.class, (Object)helmetId);
            if (helmet != null) {
                em.remove((Object)helmet);
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFetchGroupForCachedReference() {
        if (this.isWeavingEnabled()) {
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            Shelf original = new Shelf();
            original.setId(Long.valueOf(1L));
            original.setName("original");
            em.persist((Object)original);
            Shelf modified = new Shelf();
            modified.setId(Long.valueOf(2L));
            modified.setName("modified");
            em.persist((Object)modified);
            Helmet helmet = new Helmet();
            helmet.setId(3);
            helmet.setShelf(original);
            em.persist((Object)helmet);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            ((UnitOfWorkImpl)em.unwrap(UnitOfWorkImpl.class)).beginEarlyTransaction();
            helmet = (Helmet)em.find(Helmet.class, (Object)helmet.getId());
            modified = (Shelf)em.getReference(Shelf.class, (Object)modified.getId());
            helmet.setShelf(modified);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            try {
                em = this.createEntityManager();
                this.beginTransaction(em);
                ((UnitOfWorkImpl)em.unwrap(UnitOfWorkImpl.class)).beginEarlyTransaction();
                modified = (Shelf)em.find(Shelf.class, (Object)modified.getId());
                if (modified.getName() == null) {
                    AdvancedFetchGroupJunitTest.fail((String)"find returned entity with missing attribute");
                }
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.beginTransaction(em);
                helmet = (Helmet)em.find(Helmet.class, (Object)helmet.getId());
                em.remove((Object)helmet);
                modified = (Shelf)em.find(Shelf.class, (Object)modified.getId());
                em.remove((Object)modified);
                original = (Shelf)em.find(Shelf.class, (Object)original.getId());
                em.remove((Object)original);
                this.commitTransaction(em);
                this.closeEntityManager(em);
            }
        }
    }

    protected void verifyFetchedField(Field field, Object obj, Object value) {
        try {
            field.setAccessible(true);
            AdvancedFetchGroupJunitTest.assertTrue((String)("The field [" + field.getName() + "] was not fetched"), (boolean)field.get(obj).equals(value));
        }
        catch (IllegalAccessException e) {
            AdvancedFetchGroupJunitTest.fail((String)("Error verifying field content: " + e.getMessage()));
        }
    }

    protected void verifyNonFetchedField(Field field, Object obj) {
        try {
            field.setAccessible(true);
            AdvancedFetchGroupJunitTest.assertTrue((String)("The field [" + field.getName() + "] was fetched"), (field.get(obj) == null ? 1 : 0) != 0);
        }
        catch (IllegalAccessException e) {
            AdvancedFetchGroupJunitTest.fail((String)("Error verifying field content: " + e.getMessage()));
        }
    }
}

