/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.CompositePKTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.Cubicle;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.Scientist;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsExamples;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsTableManager;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;
import org.junit.Assert;

public class JUnitJPQLComplexAggregateTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;

    public JUnitJPQLComplexAggregateTestSuite() {
    }

    public JUnitJPQLComplexAggregateTestSuite(String name) {
        super(name);
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitJPQLComplexAggregateTestSuite");
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("testSetup"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexSelectAggregateTest"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexAVGTest"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexAVGOrderTest"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexCountDistinctWithGroupByAndHavingTest"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexCountDistinctWithGroupByTest"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexCountDistinctWithGroupByTest2"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexHavingWithAggregate"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexCountTest"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexCountWithGroupByTest"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexDistinctCountTest"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexMaxTest"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexMinTest"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexSumTest"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexCountDistinctOnBaseQueryClass"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexCountOnJoinedVariableSimplePK"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexCountOnJoinedVariableCompositePK"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexCountOnJoinedVariableOverManyToManySelfRefRelationship"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexCountOnJoinedVariableOverManyToManySelfRefRelationshipPortable"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("complexCountOnJoinedCompositePK"));
        suite.addTest((Test)new JUnitJPQLComplexAggregateTestSuite("testMultipleCoalesce"));
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        new CompositePKTableCreator().replaceTables((DatabaseSession)session);
        RelationshipsExamples relationshipExamples = new RelationshipsExamples();
        new RelationshipsTableManager().replaceTables((DatabaseSession)session);
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
        relationshipExamples.buildExamples((Session)session);
    }

    public void complexAVGTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpressionBuilder expbldr = new ExpressionBuilder();
        ReportQuery rq = new ReportQuery(Employee.class, expbldr);
        Expression exp = expbldr.get("lastName").equal((Object)"Smith");
        rq.setReferenceClass(Employee.class);
        rq.setSelectionCriteria(exp);
        rq.returnSingleAttribute();
        rq.dontRetrievePrimaryKeys();
        rq.useDistinct();
        rq.addAverage("salary", Double.class);
        String ejbqlString = "SELECT AVG(DISTINCT emp.salary) FROM Employee emp WHERE emp.lastName = \"Smith\"";
        Vector expectedResultVector = (Vector)JUnitJPQLComplexAggregateTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
        Double expectedResult = (Double)expectedResultVector.get(0);
        this.clearCache();
        Double result = (Double)em.createQuery(ejbqlString).getSingleResult();
        Assert.assertEquals((String)"Complex AVG test failed", (Object)expectedResult, (Object)result);
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexAVGOrderTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpressionBuilder expbldr = new ExpressionBuilder();
        ReportQuery rq = new ReportQuery(Employee.class, expbldr);
        Expression exp = expbldr.get("lastName").equal((Object)"Smith");
        rq.setReferenceClass(Employee.class);
        rq.setSelectionCriteria(exp);
        rq.dontRetrievePrimaryKeys();
        if (JUnitJPQLComplexAggregateTestSuite.getServerSession().getPlatform().isSymfoware() || JUnitJPQLComplexAggregateTestSuite.getServerSession().getPlatform().isDerby()) {
            JUnitJPQLComplexAggregateTestSuite.warning((String)("Distinct on aggregate function not supported by " + JUnitJPQLComplexAggregateTestSuite.getServerSession().getPlatform()));
        } else {
            rq.useDistinct();
        }
        Expression avgSal = expbldr.get("salary").average();
        rq.addAttribute("salary", avgSal);
        rq.addOrdering(avgSal);
        Expression gender = expbldr.get("gender");
        rq.addAttribute("gender", gender);
        rq.addGrouping(gender);
        String ejbqlString = "SELECT emp.gender, AVG(DISTINCT emp.salary) sal FROM Employee emp WHERE emp.lastName = \"Smith\" group by emp.gender order by sal";
        if (JUnitJPQLComplexAggregateTestSuite.getServerSession().getPlatform().isSymfoware() || JUnitJPQLComplexAggregateTestSuite.getServerSession().getPlatform().isDerby()) {
            ejbqlString = "SELECT emp.gender, AVG(emp.salary) sal FROM Employee emp WHERE emp.lastName = \"Smith\" group by emp.gender order by sal";
        }
        Vector expectedResultVector = (Vector)JUnitJPQLComplexAggregateTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
        this.clearCache();
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"complexAVGOrderTest test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResultVector));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexCountDistinctWithGroupByAndHavingTest() {
        String havingFilterString = "Toronto";
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpressionBuilder expbldr = new ExpressionBuilder(Address.class);
        ReportQuery rq = new ReportQuery(Address.class, expbldr);
        Expression exp = expbldr.anyOf("employees");
        Expression exp2 = expbldr.get("city");
        rq.addAttribute("city", exp2);
        rq.addCount("COUNT", exp.distinct(), Long.class);
        rq.addGrouping(exp2);
        rq.setHavingExpression(exp2.equal((Object)havingFilterString));
        Vector expectedResult = (Vector)JUnitJPQLComplexAggregateTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
        String ejbqlString3 = "SELECT a.city, COUNT( DISTINCT e ) FROM Address a JOIN a.employees e GROUP BY a.city HAVING a.city =?1";
        Query q = em.createQuery(ejbqlString3);
        q.setParameter(1, (Object)havingFilterString);
        List result = q.getResultList();
        Assert.assertTrue((String)"Complex COUNT test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexCountDistinctWithGroupByTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpressionBuilder expbldr = new ExpressionBuilder(Address.class);
        ReportQuery rq = new ReportQuery(Address.class, expbldr);
        Expression exp = expbldr.anyOf("employees");
        Expression exp2 = expbldr.get("city");
        rq.addAttribute("city", exp2);
        rq.addCount("COUNT", exp.distinct(), Long.class);
        rq.addGrouping(exp2);
        Vector expectedResult = (Vector)JUnitJPQLComplexAggregateTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
        String ejbqlString3 = "SELECT a.city, COUNT( DISTINCT e ) FROM Address a JOIN a.employees e GROUP BY a.city";
        Query q = em.createQuery(ejbqlString3);
        List result = q.getResultList();
        Assert.assertTrue((String)"Complex COUNT(Distinct) with Group By test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexCountDistinctWithGroupByTest2() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpressionBuilder expbldr = new ExpressionBuilder(Address.class);
        ReportQuery rq = new ReportQuery(Address.class, expbldr);
        Expression exp = expbldr.anyOf("employees");
        Expression exp2 = expbldr.get("city");
        rq.addAttribute("city", exp2);
        rq.addCount("COUNT1", exp, Long.class);
        rq.addCount("COUNT2", exp.get("lastName").distinct(), Long.class);
        rq.addGrouping(exp2);
        Vector expectedResult = (Vector)JUnitJPQLComplexAggregateTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
        String ejbqlString3 = "SELECT a.city, COUNT( e ), COUNT( DISTINCT e.lastName ) FROM Address a JOIN a.employees e GROUP BY a.city";
        Query q = em.createQuery(ejbqlString3);
        List result = q.getResultList();
        Assert.assertTrue((String)"Complex COUNT(Distinct) with Group By test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexHavingWithAggregate() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpressionBuilder employeeBuilder = new ExpressionBuilder(Employee.class);
        ReportQuery rq = new ReportQuery(Employee.class, employeeBuilder);
        Expression projects = employeeBuilder.anyOf("projects");
        Expression pid = projects.get("id");
        Expression count = pid.count();
        rq.addAttribute("id", pid);
        rq.addAttribute("COUNT", count, Long.class);
        rq.addGrouping(pid);
        rq.setHavingExpression(count.greaterThan(1));
        rq.setShouldReturnWithoutReportQueryResult(true);
        Vector expectedResult = (Vector)JUnitJPQLComplexAggregateTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
        String jpql = "SELECT p.id, COUNT(p.id) FROM Employee e JOIN e.projects p GROUP BY p.id HAVING COUNT(p.id)>1";
        List result = em.createQuery(jpql).getResultList();
        Assert.assertTrue((String)"Complex HAVING with aggregate function failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        employeeBuilder = new ExpressionBuilder(Employee.class);
        rq = new ReportQuery(Employee.class, employeeBuilder);
        projects = employeeBuilder.anyOf("projects");
        count = projects.count();
        rq.addAttribute("projects", projects);
        rq.addAttribute("COUNT", count, Long.class);
        rq.addGrouping(projects);
        rq.setHavingExpression(count.greaterThan(1));
        rq.setShouldReturnWithoutReportQueryResult(true);
        expectedResult = (Vector)JUnitJPQLComplexAggregateTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
        jpql = "SELECT p, COUNT(p) FROM Employee e JOIN e.projects p GROUP BY p HAVING COUNT(p)>1";
        result = em.createQuery(jpql).getResultList();
        Assert.assertTrue((String)"Complex HAVING with aggregate function failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complexCountTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            ExpressionBuilder expbldr = new ExpressionBuilder();
            ReportQuery rq = new ReportQuery(Employee.class, expbldr);
            Expression exp = expbldr.get("lastName").equal((Object)"Smith");
            rq.setReferenceClass(Employee.class);
            rq.setSelectionCriteria(exp);
            rq.returnSingleAttribute();
            rq.dontRetrievePrimaryKeys();
            rq.addCount("COUNT", (Expression)expbldr, Long.class);
            Vector expectedResultVector = (Vector)JUnitJPQLComplexAggregateTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
            Long expectedResult = (Long)expectedResultVector.get(0);
            String ejbqlString = "SELECT COUNT(emp) FROM Employee emp WHERE emp.lastName = \"Smith\"";
            Long result = (Long)em.createQuery(ejbqlString).getSingleResult();
            Assert.assertEquals((String)"Complex COUNT test failed", (Object)expectedResult, (Object)result);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void complexCountWithGroupByTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpressionBuilder expbldr = new ExpressionBuilder(Address.class);
        ReportQuery rq = new ReportQuery(Address.class, expbldr);
        Expression exp = expbldr.anyOf("employees");
        Expression exp2 = expbldr.get("city");
        rq.addAttribute("city", exp2);
        rq.addCount("COUNT", exp.distinct(), Long.class);
        rq.addGrouping(exp2);
        Vector expectedResult = (Vector)JUnitJPQLComplexAggregateTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
        String ejbqlString3 = "SELECT a.city, COUNT( DISTINCT e ) FROM Address a JOIN a.employees e GROUP BY a.city";
        Query q = em.createQuery(ejbqlString3);
        List result = q.getResultList();
        Assert.assertTrue((String)"Complex COUNT with Group By test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexDistinctCountTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpressionBuilder expbldr = new ExpressionBuilder();
        ReportQuery rq = new ReportQuery(Employee.class, expbldr);
        Expression exp = expbldr.get("lastName").equal((Object)"Smith");
        rq.setReferenceClass(Employee.class);
        rq.setSelectionCriteria(exp);
        rq.useDistinct();
        rq.returnSingleAttribute();
        rq.dontRetrievePrimaryKeys();
        rq.addCount("COUNT", expbldr.get("lastName").distinct(), Long.class);
        Vector expectedResultVector = (Vector)JUnitJPQLComplexAggregateTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
        Long expectedResult = (Long)expectedResultVector.get(0);
        String ejbqlString = "SELECT COUNT(DISTINCT emp.lastName) FROM Employee emp WHERE emp.lastName = \"Smith\"";
        Long result = (Long)em.createQuery(ejbqlString).getSingleResult();
        Assert.assertEquals((String)"Complex DISTINCT COUNT test failed", (Object)expectedResult, (Object)result);
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexMaxTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpressionBuilder expbldr = new ExpressionBuilder();
        ReportQuery rq = new ReportQuery(Employee.class, expbldr);
        rq.setReferenceClass(Employee.class);
        rq.returnSingleAttribute();
        rq.dontRetrievePrimaryKeys();
        rq.addAttribute("salary", expbldr.get("salary").distinct().maximum(), Integer.class);
        Vector expectedResultVector = (Vector)JUnitJPQLComplexAggregateTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
        Number expectedResult = (Number)expectedResultVector.get(0);
        String ejbqlString = "SELECT MAX(DISTINCT emp.salary) FROM Employee emp";
        Number result = (Number)em.createQuery(ejbqlString).getSingleResult();
        Assert.assertEquals((String)"Type returned was not expected", Integer.class, result.getClass());
        Assert.assertEquals((String)"Complex MAX test failed", (Object)expectedResult, (Object)result);
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexMinTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpressionBuilder expbldr = new ExpressionBuilder();
        ReportQuery rq = new ReportQuery(Employee.class, expbldr);
        rq.setReferenceClass(Employee.class);
        rq.returnSingleAttribute();
        rq.dontRetrievePrimaryKeys();
        rq.addAttribute("salary", expbldr.get("salary").distinct().minimum(), Integer.class);
        Vector expectedResultVector = (Vector)JUnitJPQLComplexAggregateTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
        Number expectedResult = (Number)expectedResultVector.get(0);
        String ejbqlString = "SELECT MIN(DISTINCT emp.salary) FROM Employee emp";
        Number result = (Number)em.createQuery(ejbqlString).getSingleResult();
        Assert.assertEquals((String)"Type returned was not expected", Integer.class, result.getClass());
        Assert.assertEquals((String)"Complex MIN test failed", (Object)expectedResult, (Object)result);
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexSumTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpressionBuilder expbldr = new ExpressionBuilder();
        ReportQuery rq = new ReportQuery(Employee.class, expbldr);
        rq.setReferenceClass(Employee.class);
        rq.returnSingleAttribute();
        rq.dontRetrievePrimaryKeys();
        rq.addAttribute("salary", expbldr.get("salary").distinct().sum(), Long.class);
        Vector expectedResultVector = (Vector)JUnitJPQLComplexAggregateTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
        Long expectedResult = (Long)expectedResultVector.get(0);
        String ejbqlString = "SELECT SUM(DISTINCT emp.salary) FROM Employee emp";
        Long result = (Long)em.createQuery(ejbqlString).getSingleResult();
        Assert.assertEquals((String)"Complex SUMtest failed", (Object)expectedResult, (Object)result);
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexCountDistinctOnBaseQueryClass() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Long expectedResult = JUnitJPQLComplexAggregateTestSuite.getServerSession().readAllObjects(Employee.class).size();
        String jpql = "SELECT COUNT(DISTINCT e) FROM Employee e";
        Query q = em.createQuery(jpql);
        Long result = (Long)q.getSingleResult();
        Assert.assertEquals((String)"Complex COUNT DISTINCT on base query class ", (Object)expectedResult, (Object)result);
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexCountOnJoinedVariableSimplePK() {
        EntityManager em = this.createEntityManager();
        List<Long> expectedResult = Arrays.asList(1L, 0L, 0L, 1L);
        Collections.sort(expectedResult);
        String jpql = "SELECT COUNT(o) FROM Customer c LEFT JOIN c.orders o GROUP BY c.name";
        Query q = em.createQuery(jpql);
        List result = q.getResultList();
        Collections.sort(result);
        Assert.assertEquals((String)"Complex COUNT on joined variable simple PK", expectedResult, (Object)result);
        jpql = "SELECT COUNT(DISTINCT o) FROM Customer c LEFT JOIN c.orders o GROUP BY c.name";
        q = em.createQuery(jpql);
        result = q.getResultList();
        Collections.sort(result);
        Assert.assertEquals((String)"Complex COUNT DISTINCT on joined variable simple PK", expectedResult, (Object)result);
    }

    public void complexCountOnJoinedVariableCompositePK() {
        EntityManager em = this.createEntityManager();
        List<Long> expectedResult = Arrays.asList(2L, 5L, 3L);
        Collections.sort(expectedResult);
        String jpql = "SELECT COUNT(p) FROM Employee e LEFT JOIN e.phoneNumbers p WHERE e.lastName LIKE 'S%' GROUP BY e.lastName";
        Query q = em.createQuery(jpql);
        List result = q.getResultList();
        Collections.sort(result);
        Assert.assertEquals((String)"Complex COUNT on outer joined variable composite PK", expectedResult, (Object)result);
        jpql = "SELECT COUNT(DISTINCT p) FROM Employee e JOIN e.phoneNumbers p WHERE e.lastName LIKE 'S%' GROUP BY e.lastName";
        q = em.createQuery(jpql);
        result = q.getResultList();
        Collections.sort(result);
        Assert.assertEquals((String)"Complex DISTINCT COUNT on inner joined variable composite PK", expectedResult, (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complexCountOnJoinedCompositePK() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Scientist s = new Scientist();
            s.setFirstName("John");
            s.setLastName("Doe");
            Cubicle c = new Cubicle();
            c.setCode("G");
            c.setScientist(s);
            s.setCubicle(c);
            em.persist((Object)c);
            em.persist((Object)s);
            em.flush();
            List<Long> expectedResult = Arrays.asList(1L);
            Collections.sort(expectedResult);
            String jpql = "SELECT COUNT(DISTINCT p) FROM Scientist e JOIN e.cubicle p WHERE e.lastName LIKE 'D%'";
            Query q = em.createQuery(jpql);
            List result = q.getResultList();
            Collections.sort(result);
            Assert.assertEquals((String)"Complex COUNT on joined variable composite PK", expectedResult, (Object)result);
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    public void complexCountOnJoinedVariableOverManyToManySelfRefRelationshipPortable() {
        EntityManager em = this.createEntityManager();
        List expectedResult = Arrays.asList({0L, "Jane Smith"}, {1L, "John Smith"}, {0L, "Karen McDonald"}, {0L, "Robert Sampson"});
        String jpql = "SELECT COUNT(cc), c.name FROM Customer c LEFT JOIN c.CCustomers cc GROUP BY c.name order by c.name";
        Query q = em.createQuery(jpql);
        List result = q.getResultList();
        String description = "Complex COUNT on joined variable over ManyToMany self refrenceing relationship";
        Assert.assertEquals((String)"Complex COUNT on joined variable over ManyToMany self refrenceing relationship size mismatch", (long)expectedResult.size(), (long)result.size());
        for (int i = 0; i < result.size(); ++i) {
            Object[] expected = (Object[])expectedResult.get(i);
            Object[] actual = (Object[])result.get(i);
            Assert.assertEquals((Object)expected[0], (Object)actual[0]);
            Assert.assertEquals((Object)expected[1], (Object)actual[1]);
        }
    }

    public void complexCountOnJoinedVariableOverManyToManySelfRefRelationship() {
        if (JUnitJPQLComplexAggregateTestSuite.getServerSession().getPlatform().isMaxDB()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        List<Long> expectedResult = Arrays.asList(0L, 1L, 0L, 0L);
        String jpql = "SELECT COUNT(cc) FROM Customer c LEFT JOIN c.CCustomers cc GROUP BY c.name order by c.name";
        Query q = em.createQuery(jpql);
        List result = q.getResultList();
        Assert.assertEquals((String)"Complex COUNT on joined variable over ManyToMany self refrenceing relationship failed", expectedResult, (Object)result);
    }

    public void complexSelectAggregateTest() {
        EntityManager em = this.createEntityManager();
        Expression exp = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        Employee employee = (Employee)JUnitJPQLComplexAggregateTestSuite.getServerSession().readObject(Employee.class, exp);
        EmploymentPeriod expectedResult = employee.getPeriod();
        String jpql = "SELECT e.period from Employee e where e.firstName = 'Bob'";
        Query q = em.createQuery(jpql);
        EmploymentPeriod result = (EmploymentPeriod)q.getSingleResult();
        Assert.assertEquals((String)"complexSelectAggregateTest failed - start dates don't match", (Object)expectedResult.getStartDate(), (Object)result.getStartDate());
        Assert.assertEquals((String)"complexSelectAggregateTest failed - end dates don't match", (Object)expectedResult.getEndDate(), (Object)result.getEndDate());
    }

    public void testMultipleCoalesce() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT SUM(COALESCE(e.roomNumber, 20)), SUM(COALESCE(e.salary, 10000)) FROM Employee e");
        List result = query.getResultList();
        Assert.assertNotNull((String)"testMultipleCoalesce Test Failed - Unable to fetch employee data", (Object)result);
        Assert.assertFalse((String)"testMultipleCoalesce Test Failed - Unable to fetch employee data", (boolean)result.isEmpty());
        Object[] aggregateResult = (Object[])result.get(0);
        Assert.assertFalse((String)"testMultipleCoalesce Test Failed ", (boolean)aggregateResult[0].equals(aggregateResult[1]));
        this.closeEntityManager(em);
    }
}

