/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.sql.Time;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;

public class DeepNestedUnitOfWorkTest
extends WriteObjectTest {
    public Object[] unitOfWorkWorkingCopy = new Object[5];
    public UnitOfWork[] unitOfWork = new UnitOfWork[5];

    public DeepNestedUnitOfWorkTest() {
    }

    public DeepNestedUnitOfWorkTest(Object originalObject) {
        super(originalObject);
    }

    protected void changeFirstLevelUnitOfWorkWorkingCopy() {
        Employee employee = (Employee)this.unitOfWorkWorkingCopy[0];
        employee.setNormalHours(new Time[2]);
        employee.setStartTime(Helper.timeFromHourMinuteSecond((int)1, (int)1, (int)1));
        employee.setEndTime(Helper.timeFromHourMinuteSecond((int)1, (int)1, (int)1));
        employee.setPeriod(new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1901, (int)1, (int)1), Helper.dateFromYearMonthDate((int)1902, (int)2, (int)2)));
    }

    protected void changeSecondLevelUnitOfWorkWorkingCopy() {
        Employee employee = (Employee)this.unitOfWorkWorkingCopy[1];
        employee.setPhoneNumbers(new Vector());
        employee.addPhoneNumber(new PhoneNumber("home", "613", "2263374"));
        employee.addPhoneNumber(new PhoneNumber("office", "416", "8224599"));
        employee.setProjects(new Vector());
        employee.addProject((Project)this.unitOfWork[1].readObject(SmallProject.class));
        employee.addProject((Project)this.unitOfWork[1].readObject(LargeProject.class));
    }

    protected void changeThirdLevelUnitOfWorkWorkingCopy() {
        Employee employee = (Employee)this.unitOfWorkWorkingCopy[2];
        employee.setResponsibilitiesList(new Vector());
        employee.addResponsibility("make coffee");
        employee.addResponsibility("buy donuts");
        employee.setAddress(new EmployeePopulator().addressExample10());
        employee.setManager((Employee)this.unitOfWork[2].readObject(Employee.class, new ExpressionBuilder().get("id").notEqual((Object)employee.getId())));
    }

    protected void setup() {
        super.setup();
        this.unitOfWork[0] = this.getSession().acquireUnitOfWork();
        this.unitOfWorkWorkingCopy[0] = this.unitOfWork[0].registerObject(this.objectToBeWritten);
        this.changeFirstLevelUnitOfWorkWorkingCopy();
        if (!((AbstractSession)this.getSession()).compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.unitOfWork[1] = this.unitOfWork[0].acquireUnitOfWork();
        this.unitOfWorkWorkingCopy[1] = this.unitOfWork[1].registerObject(this.unitOfWorkWorkingCopy[0]);
        this.changeSecondLevelUnitOfWorkWorkingCopy();
        if (!((AbstractSession)this.getSession()).compareObjectsDontMatch(this.unitOfWorkWorkingCopy[0], this.unitOfWorkWorkingCopy[1])) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.unitOfWork[2] = this.unitOfWork[1].acquireUnitOfWork();
        this.unitOfWorkWorkingCopy[2] = this.unitOfWork[2].registerObject(this.unitOfWorkWorkingCopy[1]);
        this.changeThirdLevelUnitOfWorkWorkingCopy();
        if (!((AbstractSession)this.getSession()).compareObjectsDontMatch(this.unitOfWorkWorkingCopy[1], this.unitOfWorkWorkingCopy[2])) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
    }

    protected void test() {
        this.unitOfWork[2].commit();
        if (!((AbstractSession)this.getSession()).compareObjects(this.unitOfWorkWorkingCopy[1], this.unitOfWorkWorkingCopy[2])) {
            throw new TestErrorException("The object in the nested unit of work has not been commited properly to its parent");
        }
        this.unitOfWork[1].commit();
        if (!((AbstractSession)this.getSession()).compareObjects(this.unitOfWorkWorkingCopy[0], this.unitOfWorkWorkingCopy[1])) {
            throw new TestErrorException("The object in the nested unit of work has not been commited properly to its parent");
        }
        this.unitOfWork[0].commit();
    }
}

