/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public abstract class ObjectLevelReadQueryTest
extends TestCase {
    private static final String FAIL_NPE = "NullPointerException thrown in checkForCustomQuery(AbstractSession, AbstractRecord)";
    protected SessionLog log;
    protected Session session;
    protected final Class entity = Employee.class;
    protected final SQLCall call = new SQLCall("SELECT t0.EMP_ID FROM EMPLOYEE t0");

    public ObjectLevelReadQueryTest() {
    }

    public ObjectLevelReadQueryTest(String name) {
        this.setName(name);
    }

    public void setup() {
        this.session = this.getSession();
        this.log = this.session.getSessionLog();
    }

    public void reset() {
        this.session = null;
        this.log = null;
    }

    public abstract void test() throws Throwable;

    protected Method getCheckForCustomQueryMethod(Class c) {
        Method method;
        try {
            method = c.getDeclaredMethod("checkForCustomQuery", AbstractSession.class, AbstractRecord.class);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            this.log.logThrowable(6, (Throwable)e);
            method = null;
        }
        return method;
    }

    protected DatabaseQuery callCheckForCustomQueryMethod(Object instance, Method method) throws Throwable {
        DatabaseQuery databaseQuery;
        try {
            databaseQuery = (DatabaseQuery)method.invoke(instance, this.session, null);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof NullPointerException) {
                this.log.log(6, FAIL_NPE);
                e.printStackTrace();
                ObjectLevelReadQueryTest.fail((String)FAIL_NPE);
            }
            this.log.logThrowable(6, (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            this.log.logThrowable(6, e);
            e.printStackTrace();
            throw e;
        }
        return databaseQuery;
    }

    public static final class CustomQueryRaceConditionsInReadObjectQueryTest
    extends ObjectLevelReadQueryTest {
        public CustomQueryRaceConditionsInReadObjectQueryTest() {
        }

        public CustomQueryRaceConditionsInReadObjectQueryTest(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void test() throws Throwable {
            this.log.log(5, "Running checkCustomQueryRaceConditionsInReadObjectQuery test.");
            Method checkForCustomQuery = this.getCheckForCustomQueryMethod(ObjectLevelReadQuery.class);
            ReadObjectQuery query = new ReadObjectQuery(this.entity, (Call)this.call);
            Object mutex = new Object();
            ValueChanger changer = new ValueChanger((ObjectLevelReadQuery)query, mutex, this.log);
            CustomQueryRaceConditionsInReadObjectQueryTest.assertTrue((String)"Initialization of isCustomQueryUsed property value changer failed.", (boolean)changer.isOk());
            try {
                Object object = mutex;
                synchronized (object) {
                    changer.start();
                    mutex.wait();
                }
            }
            catch (InterruptedException e) {
                this.log.logThrowable(6, (Throwable)e);
            }
            query.setReferenceClass(this.entity);
            query.setDescriptor(this.session.getDescriptor(this.entity));
            for (int i = 0; i < 100; ++i) {
                this.callCheckForCustomQueryMethod(query, checkForCustomQuery);
            }
            changer.finish();
            try {
                changer.join();
            }
            catch (InterruptedException e) {
                this.log.logThrowable(6, (Throwable)e);
            }
        }
    }

    public static final class CustomQueryRaceConditionsInReadAllQueryTest
    extends ObjectLevelReadQueryTest {
        public CustomQueryRaceConditionsInReadAllQueryTest() {
        }

        public CustomQueryRaceConditionsInReadAllQueryTest(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void test() throws Throwable {
            this.log.log(5, "Running checkCustomQueryRaceConditionsInReadAllQuery test.");
            Method checkForCustomQuery = this.getCheckForCustomQueryMethod(ObjectLevelReadQuery.class);
            ReadAllQuery query = new ReadAllQuery(this.entity, (Call)this.call);
            Object mutex = new Object();
            ValueChanger changer = new ValueChanger((ObjectLevelReadQuery)query, mutex, this.log);
            CustomQueryRaceConditionsInReadAllQueryTest.assertTrue((String)"Initialization of isCustomQueryUsed property value changer failed.", (boolean)changer.isOk());
            try {
                Object object = mutex;
                synchronized (object) {
                    changer.start();
                    mutex.wait();
                }
            }
            catch (InterruptedException e) {
                this.log.logThrowable(6, (Throwable)e);
            }
            query.setReferenceClass(this.entity);
            query.setDescriptor(this.session.getDescriptor(this.entity));
            for (int i = 0; i < 100; ++i) {
                this.callCheckForCustomQueryMethod(query, checkForCustomQuery);
            }
            changer.finish();
            try {
                changer.join();
            }
            catch (InterruptedException e) {
                this.log.logThrowable(6, (Throwable)e);
            }
        }
    }

    private static final class ValueChanger
    extends Thread {
        private final SessionLog log;
        private final ObjectLevelReadQuery query;
        private final Object mutex;
        private final Field isCustomQueryUsed;
        private boolean execute;

        private ValueChanger(ObjectLevelReadQuery objectLevelReadQuery, Object syncMutex, SessionLog sessionLog) {
            Field isCustomQueryUsedLocal;
            this.log = sessionLog;
            this.query = objectLevelReadQuery;
            this.mutex = syncMutex;
            this.execute = false;
            try {
                isCustomQueryUsedLocal = DatabaseQuery.class.getDeclaredField("isCustomQueryUsed");
            }
            catch (NoSuchFieldException | SecurityException e) {
                this.log.logThrowable(6, (Throwable)e);
                isCustomQueryUsedLocal = null;
            }
            if (isCustomQueryUsedLocal != null) {
                try {
                    isCustomQueryUsedLocal.setAccessible(true);
                }
                catch (SecurityException e) {
                    this.log.logThrowable(6, (Throwable)e);
                    isCustomQueryUsedLocal = null;
                }
            }
            this.isCustomQueryUsed = isCustomQueryUsedLocal;
        }

        private boolean isOk() {
            return this.isCustomQueryUsed != null;
        }

        @Override
        public void start() {
            this.execute = true;
            super.start();
        }

        public void finish() {
            this.execute = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.mutex;
            synchronized (object) {
                this.mutex.notify();
            }
            while (this.execute) {
                try {
                    this.isCustomQueryUsed.set(this.query, Boolean.TRUE);
                    this.isCustomQueryUsed.set(this.query, null);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    this.log.logThrowable(6, (Throwable)e);
                    this.execute = false;
                }
            }
        }
    }
}

