/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.security;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.tests.security.DatabaseLoginWithNoEncryptorTest;
import org.eclipse.persistence.testing.tests.security.SecurityOnFindMethodTest;
import org.eclipse.persistence.testing.tests.security.SecurityOnInitializingAttributeMethodTest;
import org.eclipse.persistence.testing.tests.security.SecurityWhileConvertingToMethodTest;
import org.eclipse.persistence.testing.tests.security.SecurityWhileInitializingAttributesInInstanceVariableAccessorTest;
import org.eclipse.persistence.testing.tests.security.SecurityWhileInitializingAttributesInMethodAccessorTest;
import org.eclipse.persistence.testing.tests.security.SecurityWhileInitializingClassExtractionMethodTest;
import org.eclipse.persistence.testing.tests.security.SecurityWhileInitializingCopyPolicyTest;
import org.eclipse.persistence.testing.tests.security.SecurityWhileInitializingInstantiationPolicyTest;

public class SecurityTestModel
extends TestModel {
    public SecurityTestModel() {
        this.setDescription("This model tests the security features of TopLink.");
    }

    public void addRequiredSystems() {
    }

    public void addTests() {
        this.addTest((Test)SecurityTestModel.getValidationSecurityTestSuite());
        this.addTest((Test)new DatabaseLoginWithNoEncryptorTest());
    }

    public static TestSuite getValidationSecurityTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Validation Security Tests");
        suite.setDescription("This suite includes Validation tests on security (Tests originally in validation model)");
        suite.addTest((Test)new SecurityWhileInitializingInstantiationPolicyTest());
        suite.addTest((Test)new SecurityOnFindMethodTest());
        suite.addTest((Test)new SecurityOnInitializingAttributeMethodTest(SecurityOnInitializingAttributeMethodTest.AttributeMethodOneArg.class));
        suite.addTest((Test)new SecurityOnInitializingAttributeMethodTest(SecurityOnInitializingAttributeMethodTest.AttributeMethodAbstractSession.class));
        suite.addTest((Test)new SecurityOnInitializingAttributeMethodTest(SecurityOnInitializingAttributeMethodTest.AttributeMethodSession.class));
        suite.addTest((Test)new SecurityWhileConvertingToMethodTest(SecurityWhileConvertingToMethodTest.ConvertMethodNoArg.class));
        suite.addTest((Test)new SecurityWhileConvertingToMethodTest(SecurityWhileConvertingToMethodTest.ConvertMethodSession.class));
        suite.addTest((Test)new SecurityWhileConvertingToMethodTest(SecurityWhileConvertingToMethodTest.ConvertMethodAbstractSession.class));
        suite.addTest((Test)new SecurityWhileInitializingAttributesInInstanceVariableAccessorTest());
        suite.addTest((Test)new SecurityWhileInitializingAttributesInMethodAccessorTest());
        suite.addTest((Test)new SecurityWhileInitializingClassExtractionMethodTest(SecurityWhileInitializingClassExtractionMethodTest.ExtractionAbstractRecord.class));
        suite.addTest((Test)new SecurityWhileInitializingClassExtractionMethodTest(SecurityWhileInitializingClassExtractionMethodTest.ExtractionRecord.class));
        suite.addTest((Test)new SecurityWhileInitializingCopyPolicyTest(SecurityWhileInitializingCopyPolicyTest.Policy.class));
        suite.addTest((Test)new SecurityWhileInitializingCopyPolicyTest(SecurityWhileInitializingCopyPolicyTest.WorkingPolicy.class));
        return suite;
    }

    public static junit.framework.TestSuite suite() {
        return new SecurityTestModel();
    }
}

