/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.advanced;

import java.sql.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ConstructorReportItem;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.tests.jpa.fieldaccess.advanced.DataHolder;

public class ReportQueryConstructorExpressionTestSuite
extends JUnitTestCase {
    protected boolean m_reset = false;

    public ReportQueryConstructorExpressionTestSuite() {
    }

    public ReportQueryConstructorExpressionTestSuite(String name) {
        super(name);
    }

    public void setUp() {
        this.m_reset = true;
        super.setUp();
        ReportQueryConstructorExpressionTestSuite.clearCache((String)"fieldaccess");
    }

    public void tearDown() {
        if (this.m_reset) {
            this.m_reset = false;
        }
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("ReportQueryConstructorExpressionTestSuite (fieldaccess)");
        suite.addTest((Test)new ReportQueryConstructorExpressionTestSuite("testSetup"));
        suite.addTest((Test)new ReportQueryConstructorExpressionTestSuite("testSimpleConstructorExpression"));
        suite.addTest((Test)new ReportQueryConstructorExpressionTestSuite("testSimpleConstructorExpressionWithNamedQuery"));
        suite.addTest((Test)new ReportQueryConstructorExpressionTestSuite("testMultipleTypeConstructorExpression"));
        suite.addTest((Test)new ReportQueryConstructorExpressionTestSuite("testNonExistantConstructorConstructorExpression"));
        suite.addTest((Test)new ReportQueryConstructorExpressionTestSuite("testPrimitiveConstructorExpression"));
        suite.addTest((Test)new ReportQueryConstructorExpressionTestSuite("testConstructorEJBQLWithInheritance"));
        suite.addTest((Test)new ReportQueryConstructorExpressionTestSuite("testConstructorExpressionWithOtherAttributes"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"fieldaccess"));
        EmployeePopulator employeePopulator = new EmployeePopulator();
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)JUnitTestCase.getServerSession((String)"fieldaccess"));
        ReportQueryConstructorExpressionTestSuite.clearCache((String)"fieldaccess");
    }

    public void testSimpleConstructorExpression() {
        ExpressionBuilder employees = new ExpressionBuilder();
        ReportQuery query = new ReportQuery(Employee.class, employees);
        query.addAttribute("firstName");
        query.addAttribute("lastName");
        List reportResults = (List)ReportQueryConstructorExpressionTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
        employees = new ExpressionBuilder();
        query = new ReportQuery(Employee.class, employees);
        Class[] argTypes = new Class[]{String.class, String.class};
        query.beginAddingConstructorArguments(Employee.class, argTypes);
        query.addAttribute("firstName");
        query.addAttribute("lastName");
        query.endAddingToConstructorItem();
        Vector results = (Vector)ReportQueryConstructorExpressionTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
        Iterator i = results.iterator();
        Iterator report = reportResults.iterator();
        while (i.hasNext()) {
            Employee emp = (Employee)((ReportQueryResult)i.next()).get(Employee.class.getName());
            ReportQueryResult result = (ReportQueryResult)report.next();
            if (emp.getFirstName() != null) {
                ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Null first name", (result.get("firstName") != null ? 1 : 0) != 0);
                ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Wrong first name", (boolean)emp.getFirstName().equals(result.get("firstName")));
            }
            if (emp.getLastName() == null) continue;
            ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Null last name", (result.get("lastName") != null ? 1 : 0) != 0);
            ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Wrong last name", (boolean)emp.getLastName().equals(result.get("lastName")));
        }
        ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Different result sizes", (!report.hasNext() ? 1 : 0) != 0);
    }

    public void testSimpleConstructorExpressionWithNamedQuery() {
        ExpressionBuilder employees = new ExpressionBuilder();
        ReportQuery query = new ReportQuery(Employee.class, employees);
        query.addAttribute("firstName");
        query.addAttribute("lastName");
        EntityManager em = ReportQueryConstructorExpressionTestSuite.createEntityManager((String)"fieldaccess");
        Vector reportResults = (Vector)ReportQueryConstructorExpressionTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
        Vector results = (Vector)em.createNamedQuery("constuctFieldAccessEmployees").getResultList();
        Iterator i = results.iterator();
        Iterator report = reportResults.iterator();
        while (i.hasNext()) {
            Employee emp = (Employee)i.next();
            ReportQueryResult result = (ReportQueryResult)report.next();
            if (emp.getFirstName() != null) {
                ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Null first name", (result.get("firstName") != null ? 1 : 0) != 0);
                ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Wrong first name", (boolean)emp.getFirstName().equals(result.get("firstName")));
            }
            if (emp.getLastName() == null) continue;
            ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Null last name", (result.get("lastName") != null ? 1 : 0) != 0);
            ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Wrong last name", (boolean)emp.getLastName().equals(result.get("lastName")));
        }
        ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Different result sizes", (!report.hasNext() ? 1 : 0) != 0);
    }

    public void testMultipleTypeConstructorExpression() {
        ExpressionBuilder employees = new ExpressionBuilder();
        ReportQuery query = new ReportQuery(Employee.class, employees);
        query.addAttribute("firstName");
        query.addItem("endDate", employees.get("period").get("endDate"));
        query.addAttribute("id");
        List reportResults = (List)ReportQueryConstructorExpressionTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
        query = new ReportQuery(Employee.class, employees);
        Class[] argTypes = new Class[]{String.class, Date.class, Integer.class};
        query.beginAddingConstructorArguments(DataHolder.class, argTypes);
        query.addAttribute("firstName");
        query.addItem("endDate", employees.get("period").get("endDate"));
        query.addAttribute("id");
        query.endAddingToConstructorItem();
        Vector results = (Vector)ReportQueryConstructorExpressionTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
        Iterator i = results.iterator();
        Iterator report = reportResults.iterator();
        while (i.hasNext()) {
            DataHolder holder = (DataHolder)((ReportQueryResult)i.next()).get(DataHolder.class.getName());
            ReportQueryResult result = (ReportQueryResult)report.next();
            if (holder.getString() != null || result.get("firstName") != null) {
                ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Wrong first name", (boolean)holder.getString().equals(result.get("firstName")));
            }
            if (holder.getDate() != null || result.get("endDate") != null) {
                ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Wrong date", (boolean)holder.getDate().equals(result.get("endDate")));
            }
            if (holder.getInteger() == null && result.get("id") == null) continue;
            ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Wrong integer", (boolean)holder.getInteger().equals(result.get("id")));
        }
        ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Different result sizes", (!report.hasNext() ? 1 : 0) != 0);
    }

    public void testNonExistantConstructorConstructorExpression() {
        ExpressionBuilder employees = new ExpressionBuilder();
        ReportQuery query = new ReportQuery(Employee.class, employees);
        Class[] argTypes = new Class[]{String.class, Date.class, Integer.class};
        query.beginAddingConstructorArguments(Employee.class, argTypes);
        query.addAttribute("firstName");
        query.addItem("endDate", employees.get("period").get("endDate"));
        query.addAttribute("id");
        query.endAddingToConstructorItem();
        QueryException exception = null;
        try {
            ReportQueryConstructorExpressionTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
        }
        catch (QueryException ex) {
            exception = ex;
        }
        ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Exception not throw. ", (exception != null ? 1 : 0) != 0);
    }

    public void testPrimitiveConstructorExpression() {
        ExpressionBuilder employees = new ExpressionBuilder();
        ReportQuery query = new ReportQuery(Employee.class, employees);
        query.addAttribute("salary");
        List reportResults = (List)ReportQueryConstructorExpressionTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
        query = new ReportQuery(Employee.class, employees);
        Class[] argTypes = new Class[]{Integer.TYPE};
        query.beginAddingConstructorArguments(DataHolder.class, argTypes);
        query.addAttribute("salary");
        query.endAddingToConstructorItem();
        Vector results = (Vector)ReportQueryConstructorExpressionTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
        Iterator i = results.iterator();
        Iterator report = reportResults.iterator();
        while (i.hasNext()) {
            DataHolder holder = (DataHolder)((ReportQueryResult)i.next()).get(DataHolder.class.getName());
            ReportQueryResult result = (ReportQueryResult)report.next();
            ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Incorrect salary ", (((Integer)result.get("salary")).intValue() == holder.getPrimitiveInt() ? 1 : 0) != 0);
        }
        ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Different result sizes", (!report.hasNext() ? 1 : 0) != 0);
    }

    public void testConstructorEJBQLWithInheritance() {
        Exception exception = null;
        try {
            ReportQueryConstructorExpressionTestSuite.createEntityManager((String)"fieldaccess").createNamedQuery("constructFieldAccessLProject").getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
            exception = e;
        }
        ReportQueryConstructorExpressionTestSuite.assertNull((String)"Exception was caught", (Object)exception);
    }

    public void testConstructorExpressionWithOtherAttributes() {
        ExpressionBuilder employees = new ExpressionBuilder();
        ReportQuery query = new ReportQuery(Employee.class, employees);
        query.addAttribute("firstName");
        query.addAttribute("lastName");
        List reportResults = (List)ReportQueryConstructorExpressionTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
        ConstructorReportItem citem = new ConstructorReportItem("Employee");
        citem.setResultType(Employee.class);
        citem.addAttribute(employees.get("firstName"));
        citem.addAttribute(employees.get("lastName"));
        query.addConstructorReportItem(citem);
        Vector results = (Vector)ReportQueryConstructorExpressionTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
        Iterator i = results.iterator();
        Iterator report = reportResults.iterator();
        while (i.hasNext()) {
            ReportQueryResult result1 = (ReportQueryResult)i.next();
            Employee emp = (Employee)result1.get("Employee");
            ReportQueryResult result2 = (ReportQueryResult)report.next();
            if (emp.getFirstName() != null) {
                ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Null first name in constructor query", (result1.get("firstName") != null ? 1 : 0) != 0);
                ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Null first name", (result2.get("firstName") != null ? 1 : 0) != 0);
                ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Wrong first name", (boolean)emp.getFirstName().equals(result2.get("firstName")));
            }
            if (emp.getLastName() == null) continue;
            ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Null last name in constructor query", (result1.get("lastName") != null ? 1 : 0) != 0);
            ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Null last name", (result2.get("lastName") != null ? 1 : 0) != 0);
            ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Wrong last name", (boolean)emp.getLastName().equals(result2.get("lastName")));
        }
        ReportQueryConstructorExpressionTestSuite.assertTrue((String)"Different result sizes", (!report.hasNext() ? 1 : 0) != 0);
    }
}

