/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.store.pop3;

import org.apache.geronimo.javamail.store.pop3.POP3Command;
import org.apache.geronimo.javamail.store.pop3.POP3Constants;

public final class POP3CommandFactory
implements POP3Constants {
    public static POP3Command getCOMMAND_USER(final String user) {
        return new POP3Command(){

            public String getCommand() {
                return "USER " + user + "\r\n";
            }

            public boolean isMultiLineResponse() {
                return false;
            }
        };
    }

    public static POP3Command getCOMMAND_PASS(final String passwd) {
        return new POP3Command(){

            public String getCommand() {
                return "PASS " + passwd + "\r\n";
            }

            public boolean isMultiLineResponse() {
                return false;
            }
        };
    }

    public static POP3Command getCOMMAND_QUIT() {
        return new POP3Command(){

            public String getCommand() {
                return "QUIT\r\n";
            }

            public boolean isMultiLineResponse() {
                return false;
            }
        };
    }

    public static POP3Command getCOMMAND_NOOP() {
        return new POP3Command(){

            public String getCommand() {
                return "NOOP\r\n";
            }

            public boolean isMultiLineResponse() {
                return false;
            }
        };
    }

    public static POP3Command getCOMMAND_STAT() {
        return new POP3Command(){

            public String getCommand() {
                return "STAT\r\n";
            }

            public boolean isMultiLineResponse() {
                return false;
            }
        };
    }

    public static POP3Command getCOMMAND_LIST() {
        return POP3CommandFactory.getCOMMAND_LIST(-1);
    }

    public static POP3Command getCOMMAND_LIST(final int msgNo) {
        return new POP3Command(){

            public String getCommand() {
                if (msgNo > 0) {
                    return "LIST " + msgNo + "\r\n";
                }
                return "LIST\r\n";
            }

            public boolean isMultiLineResponse() {
                return msgNo < 0;
            }
        };
    }

    public static POP3Command getCOMMAND_RETR(final int msgNo) {
        return new POP3Command(){

            public String getCommand() {
                return "RETR " + msgNo + "\r\n";
            }

            public boolean isMultiLineResponse() {
                return true;
            }
        };
    }

    public static POP3Command getCOMMAND_DELE(final int msgNo) {
        return new POP3Command(){

            public String getCommand() {
                return "DELE " + msgNo + "\r\n";
            }

            public boolean isMultiLineResponse() {
                return false;
            }
        };
    }

    public static POP3Command getCOMMAND_REST(final int msgNo) {
        return new POP3Command(){

            public String getCommand() {
                return "REST " + msgNo + "\r\n";
            }

            public boolean isMultiLineResponse() {
                return false;
            }
        };
    }

    public static POP3Command getCOMMAND_TOP(final int msgNo, final int numLines) {
        return new POP3Command(){

            public String getCommand() {
                return "TOP " + msgNo + " " + numLines + "\r\n";
            }

            public boolean isMultiLineResponse() {
                return true;
            }
        };
    }

    public static POP3Command getCOMMAND_UIDL() {
        return POP3CommandFactory.getCOMMAND_UIDL(-1);
    }

    public static POP3Command getCOMMAND_UIDL(final int msgNo) {
        return new POP3Command(){

            public String getCommand() {
                if (msgNo > 0) {
                    return "UIDL " + msgNo + "\r\n";
                }
                return "UIDL\r\n";
            }

            public boolean isMultiLineResponse() {
                return true;
            }
        };
    }

    public static POP3Command getCOMMAND_CAPA() {
        return new POP3Command(){

            public String getCommand() {
                return "CAPA\r\n";
            }

            public boolean isMultiLineResponse() {
                return true;
            }
        };
    }

    public static POP3Command getCOMMAND_AUTH(final String protocol) {
        return new POP3Command(){

            public String getCommand() {
                return "AUTH " + protocol + "\r\n";
            }

            public boolean isMultiLineResponse() {
                return false;
            }
        };
    }

    public static POP3Command getCOMMAND_AUTH(final String protocol, final String initialResponse) {
        return new POP3Command(){

            public String getCommand() {
                return "AUTH " + protocol + " " + initialResponse + "\r\n";
            }

            public boolean isMultiLineResponse() {
                return false;
            }
        };
    }

    public static POP3Command getCOMMAND_ChallengeReply(final String command) {
        return new POP3Command(){

            public String getCommand() {
                return command + "\r\n";
            }

            public boolean isMultiLineResponse() {
                return false;
            }
        };
    }
}

