/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ReadAllNoDistinctTest
extends ReadAllTest {
    public ReadAllNoDistinctTest() {
        super(Employee.class, 0);
        this.setName("ReadAllWithNoDistinctTest");
    }

    protected boolean areDuplicatesReturned() {
        Hashtable<Employee, Employee> employees = new Hashtable<Employee, Employee>();
        Enumeration enumtr = ((Vector)this.objectsFromDatabase).elements();
        while (enumtr.hasMoreElements()) {
            Employee employee = (Employee)enumtr.nextElement();
            if (employees.get(employee) != null) {
                return true;
            }
            employees.put(employee, employee);
        }
        return false;
    }

    protected void setup() {
        super.setup();
        this.getQuery().dontUseDistinct();
        this.getQuery().setSelectionCriteria(new ExpressionBuilder().anyOf("phoneNumbers").get("number").notEqual((Object)"Empty"));
    }

    protected void verify() {
        if (!this.areDuplicatesReturned()) {
            throw new TestException("The DISTINCT was not removed from the SQL");
        }
    }
}

