/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.testing.framework.TestCollection;
import org.eclipse.persistence.testing.framework.TestExecutor;
import org.eclipse.persistence.testing.framework.TestResultsSummary;

public class TestSuite
extends TestCollection {
    public TestSuite() {
        this.isSRG = false;
        this.addTests();
    }

    public TestSuite(Class theClass, String name) {
        super(theClass, name);
    }

    public TestSuite(Class theClass) {
        super(theClass);
    }

    public TestSuite(boolean isSRG) {
        this.isSRG = isSRG;
        if (isSRG) {
            this.addSRGTests();
        } else {
            this.addTests();
        }
    }

    @Override
    public void addTests() {
    }

    @Override
    public void execute(TestExecutor executor) throws Throwable {
        this.setSummary(new TestResultsSummary(this));
        this.setExecutor(executor);
        this.computeNestedLevel();
        this.setupEntity();
        this.setFinishedTests(new Vector());
        if (this.getNestedCounter() < 1) {
            System.out.println();
            System.out.println("Running " + this.getSummary().getName());
        }
        long startTime = System.nanoTime();
        Enumeration tests = this.getTests().elements();
        while (tests.hasMoreElements()) {
            Test test = (Test)tests.nextElement();
            if (TestExecutor.getDefaultJUnitTestResult() != null && TestExecutor.getDefaultJUnitTestResult().shouldStop()) break;
            executor.execute(test);
            this.getFinishedTests().addElement(test);
        }
        long endTime = System.nanoTime();
        this.getSummary().setTotalTime(endTime - startTime);
        this.setFinishedTests((Vector)this.getTests().clone());
        if (this.getNestedCounter() < 1) {
            this.computeResultSummary();
            System.out.printf("Tests run: %d, Failures: %d, Errors: %d, Skipped: %d, Time elapsed: %.3f sec", this.getSummary().getPassed(), this.getSummary().getErrors() + this.getSummary().getSetupFailures(), this.getSummary().getFatalErrors(), this.getSummary().getWarnings() + this.getSummary().getProblems() + this.getSummary().getSetupWarnings(), (double)this.getSummary().getTotalTime() / 1.0E9);
            System.out.println();
        }
        this.reset();
    }

    @Override
    protected void logFootNote(Writer log) {
        try {
            log.write(Helper.cr() + this.getIndentationString() + "RESULTS OF TEST SUITE: " + this.getName() + Helper.cr());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void logRegressionHeadNote(Writer log) {
        try {
            log.write(Helper.cr() + this.getIndentationString() + "TEST SUITE NAME: " + this.getName() + Helper.cr());
            log.write(this.getIndentationString() + "SUITE DESCRIPTION: " + this.getDescription() + Helper.cr());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void logHeadNote(Writer log) {
        try {
            log.write(Helper.cr() + Helper.cr() + this.getIndentationString() + "VERSION: " + DatabaseLogin.getVersion());
            log.write(Helper.cr() + this.getIndentationString() + "TEST SUITE NAME: " + this.getName() + Helper.cr());
            log.write(this.getIndentationString() + "SUITE DESCRIPTION: " + this.getDescription() + Helper.cr());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reset() {
    }

    @Override
    public void resetEntity() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void setup() {
    }

    @Override
    public void setupEntity() throws Throwable {
        try {
            this.setup();
        }
        catch (Throwable exception) {
            this.getSummary().setSetupException(exception);
            throw exception;
        }
    }
}

