/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.customer.AddressType1;
import org.eclipse.persistence.testing.models.jpa.advanced.customer.AddressType2;
import org.eclipse.persistence.testing.models.jpa.advanced.customer.CustomerAddress;
import org.eclipse.persistence.testing.models.jpa.advanced.customer.RegisteredCustomer;

public class AbstractEntityWithColumnDiscriminatorTest
extends JUnitTestCase {
    private static final String CUSTOMER_NAME = "JONES";
    private static final String CUSTOMER_ADDR_BILLING = "STREET1";
    private static final String CUSTOMER_ADDR_DELIVERY = "STREET2";
    private static final String PU_NAME = "customer-pu";

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new AbstractEntityWithColumnDiscriminatorTest("testSetup"));
        AbstractEntityWithColumnDiscriminatorTest.addTests(suite);
        suite.addTest((Test)new AbstractEntityWithColumnDiscriminatorTest("testCleanup"));
        return suite;
    }

    public static Test addTests(TestSuite suite) {
        suite.setName("NamedQueryJUnitTest");
        suite.addTest((Test)new AbstractEntityWithColumnDiscriminatorTest("testJpqlNoFetch"));
        suite.addTest((Test)new AbstractEntityWithColumnDiscriminatorTest("testJpqlFetch"));
        suite.addTest((Test)new AbstractEntityWithColumnDiscriminatorTest("testCriteriaNoFetch"));
        suite.addTest((Test)new AbstractEntityWithColumnDiscriminatorTest("testCriteriaFetch"));
        return suite;
    }

    private static void createCustomer(EntityManager em) {
        em.getTransaction().begin();
        try {
            RegisteredCustomer cus = new RegisteredCustomer(CUSTOMER_NAME, (CustomerAddress)new AddressType1(CUSTOMER_ADDR_BILLING), (CustomerAddress)new AddressType2(CUSTOMER_ADDR_DELIVERY));
            em.persist((Object)cus);
            em.getTransaction().commit();
        }
        catch (Throwable e) {
            em.getTransaction().rollback();
            throw e;
        }
    }

    private static void deleteAllCustomers(EntityManager em) {
        List customers = em.createNamedQuery("RegisteredCustomer.selecAll", RegisteredCustomer.class).getResultList();
        em.getTransaction().begin();
        try {
            for (RegisteredCustomer cus : customers) {
                em.remove((Object)cus);
            }
            em.getTransaction().commit();
        }
        catch (Throwable e) {
            em.getTransaction().rollback();
            throw e;
        }
    }

    private static void assertCustomer(RegisteredCustomer customer) {
        AbstractEntityWithColumnDiscriminatorTest.assertEquals((String)CUSTOMER_NAME, (String)customer.getName());
        AbstractEntityWithColumnDiscriminatorTest.assertTrue((boolean)(customer.getBillingAddress() instanceof AddressType1));
        AbstractEntityWithColumnDiscriminatorTest.assertEquals((String)CUSTOMER_ADDR_BILLING, (String)((AddressType1)customer.getBillingAddress()).getStreet());
        AbstractEntityWithColumnDiscriminatorTest.assertTrue((boolean)(customer.getDeliveryAddress() instanceof AddressType2));
        AbstractEntityWithColumnDiscriminatorTest.assertEquals((String)CUSTOMER_ADDR_DELIVERY, (String)((AddressType2)customer.getDeliveryAddress()).getStreet());
    }

    public AbstractEntityWithColumnDiscriminatorTest() {
        this.setPuName(PU_NAME);
    }

    public AbstractEntityWithColumnDiscriminatorTest(String name) {
        super(name);
        this.setPuName(PU_NAME);
    }

    public void testSetup() {
        AbstractEntityWithColumnDiscriminatorTest.clearCache((String)PU_NAME);
        try (EntityManager em = AbstractEntityWithColumnDiscriminatorTest.createEntityManager((String)PU_NAME);){
            AbstractEntityWithColumnDiscriminatorTest.createCustomer(em);
        }
    }

    public void testCleanup() {
        try (EntityManager em = AbstractEntityWithColumnDiscriminatorTest.createEntityManager((String)PU_NAME);){
            AbstractEntityWithColumnDiscriminatorTest.deleteAllCustomers(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJpqlNoFetch() {
        try (EntityManager em = AbstractEntityWithColumnDiscriminatorTest.createEntityManager((String)PU_NAME);){
            TypedQuery query = em.createNamedQuery("RegisteredCustomer.selecByName", RegisteredCustomer.class).setParameter("name", (Object)CUSTOMER_NAME);
            RegisteredCustomer customer = (RegisteredCustomer)query.getSingleResult();
            AbstractEntityWithColumnDiscriminatorTest.assertCustomer(customer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJpqlFetch() {
        try (EntityManager em = AbstractEntityWithColumnDiscriminatorTest.createEntityManager((String)PU_NAME);){
            TypedQuery query = em.createNamedQuery("RegisteredCustomer.selecByNameFetch", RegisteredCustomer.class).setParameter("name", (Object)CUSTOMER_NAME);
            RegisteredCustomer customer = (RegisteredCustomer)query.getSingleResult();
            AbstractEntityWithColumnDiscriminatorTest.assertCustomer(customer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCriteriaNoFetch() {
        try (EntityManager em = AbstractEntityWithColumnDiscriminatorTest.createEntityManager((String)PU_NAME);){
            CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(RegisteredCustomer.class);
            Root from = criteriaQuery.from(RegisteredCustomer.class);
            criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)from.get("name"), (Object)CUSTOMER_NAME));
            criteriaQuery.distinct(true);
            TypedQuery query = em.createQuery(criteriaQuery);
            RegisteredCustomer customer = (RegisteredCustomer)query.getSingleResult();
            AbstractEntityWithColumnDiscriminatorTest.assertCustomer(customer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCriteriaFetch() {
        try (EntityManager em = AbstractEntityWithColumnDiscriminatorTest.createEntityManager((String)PU_NAME);){
            CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(RegisteredCustomer.class);
            Root from = criteriaQuery.from(RegisteredCustomer.class);
            from.fetch("billingAddress", JoinType.LEFT);
            from.fetch("deliveryAddress", JoinType.LEFT);
            criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)from.get("name"), (Object)CUSTOMER_NAME));
            criteriaQuery.distinct(true);
            TypedQuery query = em.createQuery(criteriaQuery);
            RegisteredCustomer customer = (RegisteredCustomer)query.getSingleResult();
            AbstractEntityWithColumnDiscriminatorTest.assertCustomer(customer);
        }
    }
}

