/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.insurance.HealthClaim;
import org.eclipse.persistence.testing.models.insurance.HealthPolicy;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;

public class ZeroPrimaryKeyExistenceCheckTest
extends TransactionalTestCase {
    protected boolean previousIsZeroValidPrimaryKeyValue;
    protected boolean isZeroValidPrimaryKeyValue;
    protected List objectsToBeWritten;
    protected QuerySQLTracker sqlTracker;

    public ZeroPrimaryKeyExistenceCheckTest(boolean isZeroValidPrimaryKey) {
        this.isZeroValidPrimaryKeyValue = isZeroValidPrimaryKey;
        this.setDescription("Test for checking 0 is valid primary key");
    }

    public void setup() {
        super.setup();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.previousIsZeroValidPrimaryKeyValue = Helper.isZeroValidPrimaryKey;
        Helper.isZeroValidPrimaryKey = this.isZeroValidPrimaryKeyValue;
        this.sqlTracker = new QuerySQLTracker(this.getSession());
    }

    public void test() {
        PolicyHolder holder = new PolicyHolder();
        holder.setFirstName("David");
        holder.setLastName("Minkoff");
        holder.setMale();
        holder.setSsn(0L);
        holder.setBirthDate(Helper.dateFromString((String)"1979/03/25"));
        holder.setOccupation("Electrician");
        HealthPolicy healthPolicy = new HealthPolicy();
        healthPolicy.setPolicyNumber(0L);
        healthPolicy.setDescription("Not bad body");
        healthPolicy.setCoverageRate(1.5f);
        healthPolicy.setMaxCoverage(50000.0f);
        HealthClaim healthClaim1 = new HealthClaim();
        healthClaim1.setId(0L);
        healthClaim1.setDisease("Flu");
        healthClaim1.setAmount(1000.0f);
        healthPolicy.addClaim(healthClaim1);
        holder.addPolicy(healthPolicy);
        this.objectsToBeWritten = new ArrayList();
        this.objectsToBeWritten.add(holder);
        this.objectsToBeWritten.add(healthPolicy);
        this.objectsToBeWritten.add(healthClaim1);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)holder);
        uow.commit();
    }

    public void verify() {
        int actualNumberOfSQLStatements;
        int expectedNumberOfStatements = 0;
        expectedNumberOfStatements = this.isZeroValidPrimaryKeyValue ? this.objectsToBeWritten.size() + 2 : this.objectsToBeWritten.size();
        if (expectedNumberOfStatements != (actualNumberOfSQLStatements = this.sqlTracker.getSqlStatements().size())) {
            throw new TestErrorException("Expected " + expectedNumberOfStatements + " SQL statements - got " + actualNumberOfSQLStatements);
        }
    }

    public void reset() {
        super.reset();
        Helper.isZeroValidPrimaryKey = this.previousIsZeroValidPrimaryKeyValue;
        this.sqlTracker.remove();
        if (this.objectsToBeWritten != null) {
            this.objectsToBeWritten.clear();
        }
    }

    public String toString() {
        return super.toString() + " (isZeroValidPrimaryKey: " + this.isZeroValidPrimaryKeyValue + ")";
    }
}

