/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class Scenario5_1b
extends ReportQueryTestCase {
    public Scenario5_1b() {
        this.setDescription("1:1 Join Custom SQL");
    }

    @Override
    protected void buildExpectedResults() {
        Vector employees = this.getSession().readAllObjects(Employee.class);
        Enumeration e = employees.elements();
        while (e.hasMoreElements()) {
            Employee emp = (Employee)e.nextElement();
            Enumeration pe = emp.getPhoneNumbers().elements();
            while (pe.hasMoreElements()) {
                PhoneNumber phone = (PhoneNumber)pe.nextElement();
                if (!phone.getAreaCode().equals("613")) continue;
                Object[] result = new Object[]{emp.getFirstName(), emp.getLastName(), phone.getNumber()};
                this.addResult(result, null);
            }
        }
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.reportQuery = new ReportQuery(new ExpressionBuilder());
        this.reportQuery.setReferenceClass(Employee.class);
        this.reportQuery.addAttribute("firstName");
        this.reportQuery.addAttribute("lastName");
        this.reportQuery.addAttribute("number", this.reportQuery.getExpressionBuilder().get("phoneNumbers").get("number"));
        this.reportQuery.setSQLString("SELECT T0.F_NAME, T0.L_NAME, T1.P_NUMBER FROM EMPLOYEE T0, PHONE T1 WHERE T0.EMP_ID = T1.EMP_ID AND T1.AREA_CODE = '613'");
    }
}

